/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.messaging;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.Trigger;
import java.io.Serializable;

public class SchedulerRequest
implements Serializable {
    public static final String COMMAND_REGISTER = "REGISTER";
    public static final String COMMAND_RETRIEVE = "RETRIEVE";
    public static final String COMMAND_SHUTDOWN = "SHUTDOWN";
    public static final String COMMAND_STARTUP = "STARTUP";
    public static final String COMMAND_UNREGISTER = "UNREGISTER";
    private String _command;
    private String _description;
    private String _destination;
    private Message _message;
    private Trigger _trigger;

    public static SchedulerRequest createRegisterRequest(Trigger trigger, String description, String destination, Message message) {
        return new SchedulerRequest(COMMAND_REGISTER, trigger, description, destination, message);
    }

    public static SchedulerRequest createRetrieveRequest(Trigger trigger) {
        return new SchedulerRequest(COMMAND_RETRIEVE, trigger, null, null, null);
    }

    public static SchedulerRequest createRetrieveResponseRequest(Trigger trigger, String description, Message message) {
        return new SchedulerRequest(null, trigger, description, null, message);
    }

    public static SchedulerRequest createShutdownRequest() {
        return new SchedulerRequest(COMMAND_SHUTDOWN, null, null, null, null);
    }

    public static SchedulerRequest createStartupRequest() {
        return new SchedulerRequest(COMMAND_STARTUP, null, null, null, null);
    }

    public static SchedulerRequest createUnregisterRequest(Trigger trigger) {
        return new SchedulerRequest(COMMAND_UNREGISTER, trigger, null, null, null);
    }

    public String getCommand() {
        return this._command;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDestination() {
        return this._destination;
    }

    public Message getMessage() {
        return this._message;
    }

    public Trigger getTrigger() {
        return this._trigger;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDestination(String destination) {
        this._destination = destination;
    }

    public void setMessage(Message message) {
        this._message = message;
    }

    public void setTrigger(Trigger trigger) {
        this._trigger = trigger;
    }

    private SchedulerRequest(String command, Trigger trigger, String description, String destination, Message message) {
        this._command = command;
        this._trigger = trigger;
        this._description = description;
        this._destination = destination;
        this._message = message;
    }
}

