/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.jmx;

import com.liferay.portal.kernel.jmx.MBeanRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestinationEventListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.jmx.DestinationManager;
import com.liferay.portal.kernel.messaging.jmx.DestinationStatisticsManager;
import com.liferay.portal.kernel.messaging.jmx.MessageBusManager;
import java.util.Collection;

public class JMXMessageListener
extends BaseDestinationEventListener {
    private static final String _MESSAGE_BUS_MANAGER_OBJECT_NAME_CACHE_KEY = "messageBusManager";
    private static Log log = LogFactoryUtil.getLog(JMXMessageListener.class);
    private MBeanRegistry _mBeanRegistry;
    private MessageBus _messageBus;

    public void afterPropertiesSet() throws Exception {
        block6: {
            if (this._mBeanRegistry == null || this._messageBus == null) {
                throw new IllegalStateException("MBean server and message bus are not configured");
            }
            try {
                this._mBeanRegistry.replace(_MESSAGE_BUS_MANAGER_OBJECT_NAME_CACHE_KEY, new MessageBusManager(this._messageBus), MessageBusManager.createObjectName());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn("Unable to register message bus manager", e);
            }
        }
        Collection<Destination> destinations = this._messageBus.getDestinations();
        for (Destination destination : destinations) {
            try {
                this.registerDestination(destination);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Unable to register destination " + destination.getName(), e);
            }
        }
    }

    public void destinationAdded(Destination destination) {
        try {
            this.registerDestination(destination);
        }
        catch (Exception e) {
            log.error("Unable to register destination " + destination.getName(), e);
        }
    }

    public void destinationRemoved(Destination destination) {
        try {
            this.unregisterDestination(destination);
        }
        catch (Exception e) {
            log.error("Unable to unregister destination " + destination.getName(), e);
        }
    }

    public void destroy() throws Exception {
        block5: {
            Collection<Destination> destinations = this._messageBus.getDestinations();
            for (Destination destination : destinations) {
                try {
                    this.unregisterDestination(destination);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Unable to unregister destination " + destination.getName(), e);
                }
            }
            try {
                this._mBeanRegistry.unregister(_MESSAGE_BUS_MANAGER_OBJECT_NAME_CACHE_KEY, MessageBusManager.createObjectName());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn("Unable to unregister message bus manager", e);
            }
        }
    }

    public void init() throws Exception {
        this.afterPropertiesSet();
    }

    public void setMBeanRegistry(MBeanRegistry mBeanRegistry) {
        this._mBeanRegistry = mBeanRegistry;
    }

    public void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    protected void unregisterDestination(Destination destination) throws Exception {
        String destinationName = destination.getName();
        this._mBeanRegistry.unregister(destinationName, DestinationManager.createObjectName(destinationName));
        this._mBeanRegistry.unregister(this._getStatisticsObjectNameCacheKey(destinationName), DestinationStatisticsManager.createObjectName(destinationName));
    }

    protected void registerDestination(Destination destination) throws Exception {
        String destinationName = destination.getName();
        this._mBeanRegistry.replace(destinationName, new DestinationManager(destination), DestinationManager.createObjectName(destinationName));
        this._mBeanRegistry.replace(this._getStatisticsObjectNameCacheKey(destinationName), new DestinationStatisticsManager(destination), DestinationStatisticsManager.createObjectName(destinationName));
    }

    private String _getStatisticsObjectNameCacheKey(String destinationName) {
        return String.valueOf(destinationName) + "statistics";
    }
}

