/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.util.StringBundler;

public class FinderPath {
    private static final String _ARGS_SEPARATOR = "_A_";
    private static final String _PARAMS_SEPARATOR = "_P_";
    private String _cacheKeyPrefix;
    private String _className;
    private boolean _entityCacheEnabled;
    private boolean _finderCacheEnabled;
    private String _localCacheKeyPrefix;
    private String _methodName;
    private String[] _params;

    public FinderPath(boolean entityCacheEnabled, boolean finderCacheEnabled, String className, String methodName, String[] params) {
        this._entityCacheEnabled = entityCacheEnabled;
        this._finderCacheEnabled = finderCacheEnabled;
        this._className = className;
        this._methodName = methodName;
        this._params = params;
        this._initCacheKeyPrefix();
        this._initLocalCacheKeyPrefix();
    }

    public String encodeCacheKey(Object[] args) {
        StringBundler sb = new StringBundler(args.length * 2 + 3);
        sb.append(ShardUtil.getCurrentShardName());
        sb.append(".");
        sb.append(this._cacheKeyPrefix);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(".");
            sb.append(String.valueOf(arg));
            ++n2;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(FinderCache.class.getName());
        return cacheKeyGenerator.getCacheKey(sb);
    }

    public String encodeLocalCacheKey(Object[] args) {
        StringBundler sb = new StringBundler(args.length * 2 + 3);
        sb.append(ShardUtil.getCurrentShardName());
        sb.append(".");
        sb.append(this._localCacheKeyPrefix);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            sb.append(".");
            sb.append(String.valueOf(arg));
            ++n2;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(FinderCache.class.getName());
        return cacheKeyGenerator.getCacheKey(sb);
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String[] getParams() {
        return this._params;
    }

    public boolean isEntityCacheEnabled() {
        return this._entityCacheEnabled;
    }

    public boolean isFinderCacheEnabled() {
        return this._finderCacheEnabled;
    }

    private void _initCacheKeyPrefix() {
        StringBundler sb = new StringBundler(this._params.length * 2 + 3);
        sb.append(this._methodName);
        sb.append(_PARAMS_SEPARATOR);
        String[] stringArray = this._params;
        int n = this._params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            sb.append(".");
            sb.append(param);
            ++n2;
        }
        sb.append(_ARGS_SEPARATOR);
        this._cacheKeyPrefix = sb.toString();
    }

    private void _initLocalCacheKeyPrefix() {
        this._localCacheKeyPrefix = this._className.concat(".").concat(this._cacheKeyPrefix);
    }
}

