/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster.messaging;

import com.liferay.portal.kernel.cluster.ClusterLinkUtil;
import com.liferay.portal.kernel.cluster.messaging.ClusterMessageListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.Validator;

public class ClusterForwardMessageListener
implements ClusterMessageListener {
    private static Log _log = LogFactoryUtil.getLog(ClusterForwardMessageListener.class);

    public void receive(Message message) {
        String destinationName = message.getDestinationName();
        if (Validator.isNotNull(destinationName)) {
            if (_log.isInfoEnabled()) {
                _log.info("Forwarding cluster link message " + message + " to " + destinationName);
            }
            ClusterLinkUtil.setForwardMessage(message);
            MessageBusUtil.sendMessage(destinationName, message);
        } else if (_log.isErrorEnabled()) {
            _log.error("Forwarded cluster link message has no destination " + message);
        }
    }
}

