/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.util.Cloneable;

public class GridEnvelope2D
extends Rectangle
implements GridEnvelope,
Cloneable {
    private static final long serialVersionUID = -3370515914148690059L;

    public GridEnvelope2D() {
    }

    public GridEnvelope2D(Rectangle rectangle) {
        super(rectangle);
    }

    public GridEnvelope2D(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public final int getDimension() {
        return 2;
    }

    public GridCoordinates2D getLow() {
        return new GridCoordinates2D(this.x, this.y);
    }

    public GridCoordinates2D getHigh() {
        return new GridCoordinates2D(this.x + this.width - 1, this.y + this.height - 1);
    }

    public int getLow(int dimension) {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public int getHigh(int dimension) {
        switch (dimension) {
            case 0: {
                return this.x + this.width - 1;
            }
            case 1: {
                return this.y + this.height - 1;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public int getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.width;
            }
            case 1: {
                return this.height;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public String toString() {
        return GeneralGridEnvelope.toString(this);
    }

    public GridEnvelope2D clone() {
        return (GridEnvelope2D)super.clone();
    }
}

