/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.helper;

import java.io.IOException;
import org.cyberneko.html.parsers.SAXParser;
import org.outerj.daisy.diff.helper.MergeCharacterEventsHandler;
import org.outerj.daisy.diff.helper.SaxBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NekoHtmlParser {
    public SaxBuffer parse(InputSource is) throws IOException, SAXException {
        SaxBuffer buffer = new SaxBuffer();
        this.parse(is, buffer);
        return buffer;
    }

    public void parse(InputSource is, ContentHandler consumer) throws IOException, SAXException {
        if (is == null) {
            throw new NullPointerException("is argument is required.");
        }
        SAXParser parser = new SAXParser();
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setFeature("http://cyberneko.org/html/features/override-namespaces", false);
        parser.setFeature("http://cyberneko.org/html/features/insert-namespaces", false);
        parser.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
        parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)"UTF-8");
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
        parser.setContentHandler((ContentHandler)new RemoveNamespacesHandler(new MergeCharacterEventsHandler(consumer)));
        parser.parse(is);
    }

    static class RemoveNamespacesHandler
    implements ContentHandler {
        private ContentHandler consumer;

        public RemoveNamespacesHandler(ContentHandler consumer) {
            this.consumer = consumer;
        }

        public void endDocument() throws SAXException {
            this.consumer.endDocument();
        }

        public void startDocument() throws SAXException {
            this.consumer.startDocument();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.consumer.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.consumer.ignorableWhitespace(ch, start, length);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.consumer.setDocumentLocator(locator);
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.consumer.endElement("", localName, localName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl newAtts = new AttributesImpl(atts);
            for (int i = 0; i < atts.getLength(); ++i) {
                newAtts.setURI(i, "");
                newAtts.setQName(i, newAtts.getLocalName(i));
            }
            this.consumer.startElement("", localName, localName, atts);
        }
    }
}

