/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.swing.FileView;
import de.schlichtherle.io.swing.FilterFileSystemView;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.UIManager;

public class FileSystemView
extends FilterFileSystemView {
    private static FileSystemView defaultView = new FileSystemView(javax.swing.filechooser.FileSystemView.getFileSystemView(), null);
    private ArchiveDetector archiveDetector;

    public static final javax.swing.filechooser.FileSystemView getFileSystemView() {
        return FileSystemView.getFileSystemView(null);
    }

    public static final javax.swing.filechooser.FileSystemView getFileSystemView(ArchiveDetector archiveDetector) {
        return archiveDetector != null ? new FileSystemView(javax.swing.filechooser.FileSystemView.getFileSystemView(), archiveDetector) : defaultView;
    }

    private FileSystemView(javax.swing.filechooser.FileSystemView delegate, ArchiveDetector archiveDetector) {
        super(delegate);
        this.archiveDetector = archiveDetector;
    }

    public ArchiveDetector getArchiveDetector() {
        return this.archiveDetector != null ? this.archiveDetector : File.getDefaultArchiveDetector();
    }

    public void setArchiveDetector(ArchiveDetector archiveDetector) {
        this.archiveDetector = archiveDetector;
    }

    protected File wrap(java.io.File file) {
        if (file == null) {
            return null;
        }
        return file instanceof File ? (File)file : this.getArchiveDetector().createFile(file);
    }

    protected java.io.File unwrap(java.io.File file) {
        return file instanceof File ? ((File)file).getDelegate() : file;
    }

    public java.io.File createFileObject(java.io.File file) {
        if (file == null) {
            return null;
        }
        File wFile = this.wrap(file);
        return wFile.isArchive() || wFile.isEntry() ? wFile : this.unwrap(file);
    }

    public boolean isRoot(java.io.File file) {
        return super.isRoot(this.unwrap(file));
    }

    public Boolean isTraversable(java.io.File file) {
        File wFile = this.wrap(file);
        Boolean traversable = FileView.traversable(wFile);
        if (traversable != null) {
            return traversable;
        }
        return super.isTraversable(this.unwrap(file));
    }

    public String getSystemDisplayName(java.io.File file) {
        File wFile = this.wrap(file);
        if (wFile.isArchive() || wFile.isEntry()) {
            return wFile.getName();
        }
        return super.getSystemDisplayName(this.unwrap(file));
    }

    public String getSystemTypeDescription(java.io.File file) {
        File wFile = this.wrap(file);
        String typeDescription = FileView.typeDescription(wFile);
        if (typeDescription != null) {
            return typeDescription;
        }
        return super.getSystemTypeDescription(this.unwrap(file));
    }

    public Icon getSystemIcon(java.io.File file) {
        File wFile = this.wrap(file);
        Icon icon = FileView.closedIcon(wFile);
        if (icon != null) {
            return icon;
        }
        java.io.File uFile = this.unwrap(file);
        return uFile.exists() ? super.getSystemIcon(uFile) : null;
    }

    public boolean isParent(java.io.File folder, java.io.File file) {
        return super.isParent(this.wrap(folder), this.wrap(file)) || super.isParent(this.unwrap(folder), this.unwrap(file));
    }

    public java.io.File getChild(java.io.File parent, String child) {
        File wParent = this.wrap(parent);
        if (wParent.isArchive() || wParent.isEntry()) {
            return this.createFileObject(super.getChild(wParent, child));
        }
        return this.createFileObject(super.getChild(this.unwrap(parent), child));
    }

    public boolean isFileSystem(java.io.File file) {
        return super.isFileSystem(this.unwrap(file));
    }

    public java.io.File createNewFolder(java.io.File parent) throws IOException {
        File wParent = this.wrap(parent);
        if (wParent.isArchive() || wParent.isEntry()) {
            File folder = this.getArchiveDetector().createFile((java.io.File)wParent, UIManager.getString(File.separatorChar == '\\' ? "FileChooser.win32.newFolder" : "FileChooser.other.newFolder"));
            int i = 2;
            while (!folder.mkdirs()) {
                if (i > 100) {
                    throw new IOException(wParent + ": Could not create new directory entry!");
                }
                folder = this.getArchiveDetector().createFile((java.io.File)wParent, MessageFormat.format(UIManager.getString(File.separatorChar == '\\' ? "FileChooser.win32.newFolder.subsequent" : "FileChooser.other.newFolder.subsequent"), new Integer(i)));
                ++i;
            }
            return folder;
        }
        return this.createFileObject(super.createNewFolder(this.unwrap(parent)));
    }

    public boolean isHiddenFile(java.io.File file) {
        return super.isHiddenFile(this.unwrap(file));
    }

    public boolean isFileSystemRoot(java.io.File file) {
        return super.isFileSystemRoot(this.unwrap(file));
    }

    public boolean isDrive(java.io.File file) {
        return super.isDrive(this.unwrap(file));
    }

    public boolean isFloppyDrive(java.io.File file) {
        return super.isFloppyDrive(this.unwrap(file));
    }

    public boolean isComputerNode(java.io.File file) {
        return super.isComputerNode(this.unwrap(file));
    }

    public java.io.File createFileObject(java.io.File dir, String str) {
        return this.createFileObject(super.createFileObject(dir, str));
    }

    public java.io.File createFileObject(String str) {
        return this.createFileObject(super.createFileObject(str));
    }

    public java.io.File[] getFiles(java.io.File dir, final boolean useFileHiding) {
        File smartDir = this.wrap(dir);
        if (smartDir.isArchive() || smartDir.isEntry()) {
            return smartDir.listFiles(new FileFilter(){

                public boolean accept(java.io.File file) {
                    return !useFileHiding || !FileSystemView.this.isHiddenFile(file);
                }
            });
        }
        java.io.File[] files = super.getFiles(this.unwrap(dir), useFileHiding);
        if (files != null) {
            int i = files.length;
            while (--i >= 0) {
                files[i] = this.createFileObject(files[i]);
            }
        }
        return files;
    }

    public java.io.File getParentDirectory(java.io.File file) {
        File wFile = this.wrap(file);
        if (wFile.isEntry()) {
            return this.createFileObject(wFile.getParentFile());
        }
        return this.createFileObject(super.getParentDirectory(this.unwrap(file)));
    }
}

