/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.vendor.glassfish;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import uk.org.primrose.GeneralException;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.PoolLoader;
import uk.org.primrose.pool.datasource.GenericDataSourceFactory;
import uk.org.primrose.pool.datasource.PrimroseDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimroseDataSourceFactory
extends GenericDataSourceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object refObj, Name nm, Context ctx, Hashtable<?, ?> env) throws Exception {
        PrimroseDataSource pds = null;
        Reference ref = (Reference)refObj;
        if (ref.get("poolName") == null) {
            throw new Exception("You must specify a 'poolName' in the <Resource> tag");
        }
        String poolName = (String)ref.get("poolName").getContent();
        Pool alreadyLoadedPool = PoolLoader.findExistingPool(poolName);
        if (alreadyLoadedPool != null) {
            pds = new PrimroseDataSource();
            pds.setPoolName(poolName);
        } else {
            Properties poolProps = null;
            try {
                if (ref.get("primroseConfigFile") == null) {
                    poolProps = new Properties();
                    Enumeration<RefAddr> e = ref.getAll();
                    while (e.hasMoreElements()) {
                        StringRefAddr refAddr = (StringRefAddr)e.nextElement();
                        String name = refAddr.getType();
                        String value = (String)refAddr.getContent();
                        poolProps.setProperty(name, value);
                    }
                    pds = this.loadPool(poolName, poolProps);
                } else {
                    String primroseConfigFile = (String)ref.get("primroseConfigFile").getContent();
                    pds = this.loadPool(poolName, primroseConfigFile);
                }
            }
            catch (GeneralException ge) {
                throw new Exception("Error loading pool '" + poolName + "' : " + ge);
            }
            if (pds == null) {
                throw new Exception("Could not generate PrimroseDataSource object due to previous errors - check the settings in your config");
            }
        }
        return pds;
    }
}

