/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.sql.SQLException;
import uk.org.primrose.Logger;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.Pool;

public class PoolMonitor
extends Thread {
    Pool pool;
    boolean run = true;
    int sleepTime = 10000;
    Logger logger = null;

    public PoolMonitor(Pool pool, Logger logger) {
        this.pool = pool;
        this.logger = logger;
    }

    public void shutdown() {
        this.run = false;
    }

    public void run() {
        while (this.run) {
            try {
                long now = System.currentTimeMillis();
                for (ConnectionHolder ch : this.pool.connections) {
                    StackTraceElement[] els;
                    if (ch.status == 2) {
                        if (this.pool.iIdleTime == -1) continue;
                        long idle = now - ch.lastUsedTimestamp;
                        if (ch.lastUsedTimestamp == 0L || idle <= (long)this.pool.iIdleTime) continue;
                        this.logger.info("[PoolMonitor@" + this.pool.poolName + "] PoolConnection@" + ch.conn.hashCode() + " has exceeded max idle time (" + this.pool.iIdleTime + " ms) with idle time of (" + idle + " ms) - dropping connection");
                        try {
                            ch.conn.closePhysicalAsynch();
                        }
                        catch (SQLException sqle) {
                            this.logger.printStackTrace(sqle);
                        }
                        continue;
                    }
                    if (ch.status != 1 || this.pool.iKillActiveConnectionsOverAge == -1) continue;
                    long active = now - ch.connOpenedDate;
                    if (ch.connOpenedDate == 0L || active <= (long)this.pool.iKillActiveConnectionsOverAge) continue;
                    StringBuffer stack = new StringBuffer();
                    for (StackTraceElement el : els = ch.callStack) {
                        stack.append("\t");
                        stack.append(el.toString());
                        stack.append("\n");
                    }
                    String message = "[PoolMonitor@" + this.pool.poolName + "] PoolConnection@" + ch.conn.hashCode() + " has exceeded max execution time (" + this.pool.iKillActiveConnectionsOverAge + " ms) with active time of (" + active + " ms) - killing off connection\n" + stack.toString();
                    this.logger.email("KILL", message);
                    this.logger.info(message);
                    try {
                        ch.conn.closePhysicalAsynch();
                    }
                    catch (SQLException sqle) {
                        this.logger.printStackTrace(sqle);
                    }
                }
            }
            catch (Exception e) {
                this.logger.printStackTrace(e);
            }
            if (!this.run) continue;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.verbose("[PoolMonitor@" + this.pool.poolName + "] Exiting.");
    }
}

