/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import uk.org.primrose.DebugLogger;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.PoolCallableStatement;
import uk.org.primrose.pool.core.PoolData;
import uk.org.primrose.pool.core.PoolPreparedStatement;
import uk.org.primrose.pool.core.PoolResultSet;
import uk.org.primrose.pool.core.PoolStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolConnection
implements Connection {
    private Connection conn = null;
    private ConnectionHolder connHolder = null;

    protected PoolConnection(Connection conn, ConnectionHolder connHolder) {
        this.conn = conn;
        this.connHolder = connHolder;
    }

    private void checkAndCloseResultSets() {
        if (this.connHolder.resultsetObjects.size() > 0) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] els = e.getStackTrace();
                StringBuffer stack = new StringBuffer();
                for (StackTraceElement el : els) {
                    stack.append("\t");
                    stack.append(el.toString());
                    stack.append("\n");
                }
                String message = "[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() : Got " + this.connHolder.resultsetObjects.size() + " unclosed ResultSets !\n" + stack.toString();
                this.connHolder.logger.email("UNCLOSE", message);
                this.connHolder.logger.error(message);
                while (!this.connHolder.resultsetObjects.empty()) {
                    PoolResultSet rs = this.connHolder.resultsetObjects.pop();
                    this.connHolder.logger.error("[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() : ResultSet@" + rs.hashCode() + " used but not closed (I'm closing it)");
                    try {
                        rs.closeNoPop();
                    }
                    catch (SQLException sqle) {
                        this.connHolder.logger.printStackTrace(sqle);
                    }
                }
            }
        }
    }

    private void checkAndCloseStatements() {
        if (this.connHolder.statementObjects.size() > 0) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] els = e.getStackTrace();
                StringBuffer stack = new StringBuffer();
                for (StackTraceElement el : els) {
                    stack.append("\t");
                    stack.append(el.toString());
                    stack.append("\n");
                }
                String message = "[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() : Got " + this.connHolder.statementObjects.size() + " unclosed [Callable/Prepared]Statements !\n" + stack.toString();
                this.connHolder.logger.email("UNCLOSE", message);
                this.connHolder.logger.error(message);
                while (!this.connHolder.statementObjects.empty()) {
                    PoolStatement s = this.connHolder.statementObjects.pop();
                    this.connHolder.logger.error("[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() : [Callable/Prepared]Statement@" + s.hashCode() + " used but not closed (I'm closing it)");
                    try {
                        s.closeNoPop();
                    }
                    catch (SQLException sqle) {
                        this.connHolder.logger.printStackTrace(sqle);
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() called ...");
        }
        this.checkAndCloseStatements();
        this.checkAndCloseResultSets();
        if (this.connHolder.numberOfCloses + 1 > this.connHolder.numberOfOpens) {
            this.connHolder.logger.verbose("[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() called twice - this could have serious implications on your pooling ...");
            return;
        }
        ++this.connHolder.numberOfCloses;
        this.connHolder.lastUsedTimestamp = System.currentTimeMillis();
        this.connHolder.lastSql = this.connHolder.sql;
        this.connHolder.lastSqlTook = System.currentTimeMillis() - this.connHolder.connOpenedDate;
        if (this.connHolder.closeBehaviour == 14) {
            this.connHolder.myPool.connections.remove(this.connHolder);
            try {
                if (DebugLogger.getEnabled()) {
                    DebugLogger.log("[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() closing physical connection (Pool.ON_CLOSE_SHOULD_DIE=true)");
                }
                this.closePhysical();
                this.connHolder.sql = "connection_dumped";
                this.connHolder.status = 3;
            }
            catch (SQLException e) {
                this.connHolder.logger.printStackTrace(e);
            }
        } else {
            this.connHolder.sql = "none";
            this.connHolder.connOpenedDate = 0L;
            this.connHolder.status = 2;
        }
        this.connHolder.logger.verbose("[Pool@" + this.connHolder.poolName + ",id=" + this.connHolder.id + "] close() on conn hashcode " + this.connHolder.conn.hashCode() + ", SQL(took " + this.connHolder.lastSqlTook + " ms) : " + this.connHolder.lastSql);
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("[PoolConnection@" + this.hashCode() + "@" + this.connHolder.poolName + "] close() leaving ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runCheckSQL(String checkSQL) {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = this.conn.createStatement();
            rs = s.executeQuery(checkSQL);
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
        }
        catch (Exception e) {
            this.connHolder.logger.printStackTrace(e);
            this.connHolder.logger.error("[Pool@" + this.connHolder.poolName + "] checkIfConnectionIsValid() : SQL Check failed.");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return true;
    }

    protected void closePhysical() throws SQLException {
        this.conn.close();
    }

    protected void closePhysicalAsynch() throws SQLException {
        new PoolConnectionCloseThread().start();
    }

    public Connection getRealConnection() {
        return this.conn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        ++this.connHolder.numberOfJDBCStatementsRun;
        PoolStatement ps = new PoolStatement(this.conn.createStatement(), this.connHolder);
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolPreparedStatement pps = new PoolPreparedStatement(this.conn.prepareStatement(sql), this.connHolder);
        this.connHolder.sql = sql;
        return pps;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        ++this.connHolder.numberOfJDBCCallableStatementsRun;
        PoolCallableStatement pcs = new PoolCallableStatement(this.conn.prepareCall(sql), this.connHolder);
        this.connHolder.sql = sql;
        return pcs;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.connHolder.sql = sql;
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public boolean isClosed() {
        if (this.conn == null) {
            return false;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace(System.err);
            return true;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolStatement ps = new PoolStatement(this.conn.createStatement(resultSetType, resultSetConcurrency), this.connHolder);
        this.connHolder.sql = "";
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolPreparedStatement pps = new PoolPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency), this.connHolder);
        this.connHolder.sql = sql;
        return pps;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ++this.connHolder.numberOfJDBCCallableStatementsRun;
        PoolCallableStatement pcs = new PoolCallableStatement(this.conn.prepareCall(sql, resultSetType, resultSetConcurrency), this.connHolder);
        this.connHolder.sql = sql;
        return pcs;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ++this.connHolder.numberOfJDBCStatementsRun;
        PoolStatement ps = new PoolStatement(this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.connHolder);
        return ps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolPreparedStatement pps = new PoolPreparedStatement(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.connHolder);
        this.connHolder.sql = sql;
        return pps;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ++this.connHolder.numberOfJDBCCallableStatementsRun;
        PoolCallableStatement pcs = new PoolCallableStatement(this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.connHolder);
        this.connHolder.sql = sql;
        return pcs;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolPreparedStatement pps = new PoolPreparedStatement(this.conn.prepareStatement(sql, autoGeneratedKeys), this.connHolder);
        this.connHolder.sql = sql;
        return pps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolPreparedStatement pps = new PoolPreparedStatement(this.conn.prepareStatement(sql, columnIndexes), this.connHolder);
        this.connHolder.sql = sql;
        return pps;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        ++this.connHolder.numberOfJDBCPreparedStatementsRun;
        PoolPreparedStatement pps = new PoolPreparedStatement(this.conn.prepareStatement(sql, columnNames), this.connHolder);
        this.connHolder.sql = sql;
        return pps;
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        return this.conn.createArrayOf(arg0, arg1);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        return this.conn.createStruct(arg0, arg1);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return this.conn.getClientInfo(arg0);
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return this.conn.isValid(arg0);
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        this.conn.setClientInfo(arg0);
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        this.conn.setClientInfo(arg0, arg1);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.conn.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.conn.unwrap(arg0);
    }

    private class PoolConnectionCloseThread
    extends Thread {
        private PoolConnectionCloseThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PoolData.PoolLock poolLock = ((PoolConnection)PoolConnection.this).connHolder.lock;
            synchronized (poolLock) {
                ((PoolConnection)PoolConnection.this).connHolder.status = 4;
            }
            try {
                PoolConnection.this.conn.close();
                poolLock = ((PoolConnection)PoolConnection.this).connHolder.lock;
                synchronized (poolLock) {
                    ((PoolConnection)PoolConnection.this).connHolder.status = 3;
                    PoolConnection.this.connHolder.removeFromPool();
                }
            }
            catch (SQLException e) {
                ((PoolConnection)PoolConnection.this).connHolder.logger.error("[Pool@" + ((PoolConnection)PoolConnection.this).connHolder.poolName + ",id=" + ((PoolConnection)PoolConnection.this).connHolder.id + "] failed to close() on conn hashcode " + ((PoolConnection)PoolConnection.this).connHolder.conn.hashCode() + " : " + ((PoolConnection)PoolConnection.this).connHolder.lastSql);
                ((PoolConnection)PoolConnection.this).connHolder.logger.printStackTrace(e);
            }
        }
    }
}

