/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose;

import java.util.Calendar;

public class DebugLogger {
    private static boolean enabled = false;

    public static boolean getEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean bEnabled) {
        enabled = bEnabled;
    }

    public static void printStackTrace(Throwable t) {
        if (!enabled) {
            return;
        }
        t.printStackTrace(System.out);
    }

    public static void log(String message) {
        if (!enabled) {
            return;
        }
        Calendar now = Calendar.getInstance();
        String nowString = now.get(5) + "/" + (now.get(2) + 1) + "/" + now.get(1) + " " + now.get(11) + ":" + now.get(12) + ":" + now.get(13);
        message = nowString + " : PRIMROSE_DBG : " + message;
        System.out.println(message);
    }

    static {
        try {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion != null && javaVersion.startsWith("1.4")) {
                if (System.getProperty("PRIMROSE_DEBUG") != null && System.getProperty("PRIMROSE_DEBUG").trim().equalsIgnoreCase("TRUE")) {
                    DebugLogger.setEnabled(true);
                }
            } else if (System.getenv("PRIMROSE_DEBUG") != null && System.getenv("PRIMROSE_DEBUG").trim().equalsIgnoreCase("TRUE")) {
                DebugLogger.setEnabled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

