/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.io.IRepeatableInputStream;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class RepeatableInputStream
extends InputStream
implements IRepeatableInputStream,
InputStreamWrapper {
    private final Log log = LogFactory.getLog((Class)RepeatableInputStream.class);
    private InputStream is = null;
    private int bufferOffset = 0;
    private int bufferSize = 0;
    private int bytesReadTotal = 0;
    private byte[] buffer = null;

    public RepeatableInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = inputStream;
        this.bufferSize = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.stream-retry-buffer-size", 131072);
        this.buffer = new byte[this.bufferSize];
        this.log.debug((Object)("Underlying input stream will be repeatable up to " + this.buffer.length + " bytes"));
    }

    public void repeatInputStream() throws IOException {
        if (this.bytesReadTotal > this.bufferSize) {
            throw new UnrecoverableIOException("Input stream is not repeatable as " + this.bytesReadTotal + " bytes have been written, exceeding the available buffer size of " + this.bufferSize);
        }
        this.log.debug((Object)("Reset after reading " + this.bytesReadTotal + " bytes."));
        this.bufferOffset = 0;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public int read(byte[] out, int outOffset, int outLength) throws IOException {
        int length;
        byte[] tmp = new byte[outLength];
        if (this.bufferOffset < this.bytesReadTotal && this.bufferOffset < this.bufferSize) {
            int bytesFromBuffer = tmp.length;
            if (this.bufferOffset + bytesFromBuffer > this.bytesReadTotal) {
                bytesFromBuffer = this.bytesReadTotal - this.bufferOffset;
            }
            System.arraycopy(this.buffer, this.bufferOffset, out, outOffset, bytesFromBuffer);
            this.bufferOffset += bytesFromBuffer;
            return bytesFromBuffer;
        }
        int count = this.is.read(tmp);
        if (count <= 0) {
            return count;
        }
        int n = length = this.bytesReadTotal + count < this.bufferSize ? count : this.bufferSize - this.bytesReadTotal;
        if (length > 0) {
            System.arraycopy(tmp, 0, this.buffer, this.bytesReadTotal, length);
            this.bufferOffset += length;
        } else if (length < 0 && this.buffer != null) {
            this.log.debug((Object)("Buffer size " + this.bufferSize + " has been exceed and input stream is no longer repeatable, freeing buffer memory"));
            this.buffer = null;
        }
        System.arraycopy(tmp, 0, out, outOffset, count);
        this.bytesReadTotal += count;
        return count;
    }

    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp);
        if (count != -1) {
            return tmp[0];
        }
        return count;
    }

    public InputStream getWrappedInputStream() {
        return this.is;
    }
}

