/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jodd.mutable.MutableInteger;
import jodd.util.collection.Bag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBag<E>
implements Bag<E> {
    protected transient Map<E, MutableInteger> map = new HashMap<E, MutableInteger>();
    protected int size;
    private transient int modCount;

    public HashBag() {
    }

    public HashBag(Collection<? extends E> coll) {
        this();
        this.addAll(coll);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int getCount(Object object) {
        MutableInteger count = this.map.get(object);
        if (count != null) {
            return count.value;
        }
        return 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        if (coll instanceof Bag) {
            boolean result = true;
            for (Object current : ((Bag)coll).uniqueSet()) {
                boolean contains = this.getCount(current) >= ((Bag)coll).getCount(current);
                result = result && contains;
            }
            return result;
        }
        boolean result = true;
        for (Object current : coll) {
            boolean contains = this.getCount(current) >= 1;
            result = result && contains;
        }
        return result;
    }

    boolean containsAll(Bag other) {
        boolean result = true;
        for (Object current : other.uniqueSet()) {
            boolean contains = this.getCount(current) >= other.getCount(current);
            result = result && contains;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return new BagIterator(this);
    }

    @Override
    public boolean add(E object) {
        return this.add(object, 1);
    }

    @Override
    public boolean add(E object, int copies) {
        if (copies <= 0) {
            throw new IllegalArgumentException("Invalid number of bag element copies (" + copies + ')');
        }
        ++this.modCount;
        MutableInteger mut = this.map.get(object);
        this.size += copies;
        if (mut == null) {
            this.map.put(object, new MutableInteger(copies));
            return true;
        }
        mut.value += copies;
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        boolean changed = false;
        for (E c : coll) {
            boolean added = this.add(c);
            changed = changed || added;
        }
        return changed;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        ++this.modCount;
        this.map.clear();
        this.size = 0;
    }

    @Override
    public boolean remove(Object object) {
        MutableInteger mut = this.map.get(object);
        if (mut == null) {
            return false;
        }
        ++this.modCount;
        this.map.remove(object);
        this.size -= mut.value;
        return true;
    }

    @Override
    public boolean remove(Object object, int copies) {
        if (copies <= 0) {
            throw new IllegalArgumentException("Invalid number of bag element copies (" + copies + ')');
        }
        MutableInteger mut = this.map.get(object);
        if (mut == null) {
            return false;
        }
        ++this.modCount;
        if (copies < mut.value) {
            mut.value -= copies;
            this.size -= copies;
        } else {
            this.map.remove(object);
            this.size -= mut.value;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        if (coll != null) {
            for (Object c : coll) {
                boolean changed = this.remove(c, 1);
                result = result || changed;
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        if (coll instanceof Bag) {
            boolean result = false;
            HashBag<E> excess = new HashBag<E>();
            for (E current : this.map.keySet()) {
                int myCount = this.getCount(current);
                int otherCount = ((Bag)coll).getCount(current);
                if (otherCount >= 1 && otherCount <= myCount) {
                    excess.add(current, myCount - otherCount);
                    continue;
                }
                excess.add(current, myCount);
            }
            if (!excess.isEmpty()) {
                result = this.removeAll(excess);
            }
            return result;
        }
        boolean result = false;
        HashBag<E> excess = new HashBag<E>();
        for (E current : this.map.keySet()) {
            int myCount = this.getCount(current);
            excess.add(current, myCount - 1);
        }
        if (!excess.isEmpty()) {
            result = this.removeAll(excess);
        }
        return result;
    }

    boolean retainAll(Bag other) {
        boolean result = false;
        HashBag<E> excess = new HashBag<E>();
        for (E current : this.map.keySet()) {
            int myCount = this.getCount(current);
            int otherCount = other.getCount(current);
            if (otherCount >= 1 && otherCount <= myCount) {
                excess.add(current, myCount - otherCount);
                continue;
            }
            excess.add(current, myCount);
        }
        if (!excess.isEmpty()) {
            result = this.removeAll(excess);
        }
        return result;
    }

    @Override
    public Set<E> uniqueSet() {
        return this.map.keySet();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (E current : this.map.keySet()) {
            for (int index = this.getCount(current); index > 0; --index) {
                result[i++] = current;
            }
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        int i = 0;
        for (E current : this.map.keySet()) {
            for (int index = this.getCount(current); index > 0; --index) {
                array[i++] = current;
            }
        }
        while (array.length > size) {
            array[size] = null;
            ++size;
        }
        return array;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag other = (Bag)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (E element : this.map.keySet()) {
            if (other.getCount(element) == this.getCount(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int total = 0;
        for (Map.Entry<E, MutableInteger> entry : this.map.entrySet()) {
            E element = entry.getKey();
            MutableInteger count = entry.getValue();
            total += (element == null ? 0 : element.hashCode()) ^ count.value;
        }
        return total;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator<E> it = this.uniqueSet().iterator();
        while (it.hasNext()) {
            E current = it.next();
            int count = this.getCount(current);
            buf.append(count);
            buf.append(':');
            buf.append(current);
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BagIterator<E>
    implements Iterator<E> {
        private HashBag<E> parent;
        private Iterator<Map.Entry<E, MutableInteger>> entryIterator;
        private Map.Entry<E, MutableInteger> current;
        private int itemCount;
        private final int mods;
        private boolean canRemove;

        BagIterator(HashBag<E> parent) {
            this.parent = parent;
            this.entryIterator = parent.map.entrySet().iterator();
            this.current = null;
            this.mods = ((HashBag)parent).modCount;
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            return this.itemCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (((HashBag)this.parent).modCount != this.mods) {
                throw new ConcurrentModificationException();
            }
            if (this.itemCount == 0) {
                this.current = this.entryIterator.next();
                this.itemCount = this.current.getValue().value;
            }
            this.canRemove = true;
            --this.itemCount;
            return this.current.getKey();
        }

        @Override
        public void remove() {
            if (((HashBag)this.parent).modCount != this.mods) {
                throw new ConcurrentModificationException();
            }
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            MutableInteger mut = this.current.getValue();
            if (mut.value > 1) {
                --mut.value;
            } else {
                this.entryIterator.remove();
            }
            --this.parent.size;
            this.canRemove = false;
        }
    }
}

