/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.UnsupportedEncodingException;
import jodd.typeconverter.StringArrayConverter;
import jodd.typeconverter.StringConverter;
import jodd.util.CharUtil;
import jodd.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static String replace(String s, String sub, String with) {
        int c = 0;
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        int sLen = s.length();
        StringBuilder buf = new StringBuilder(sLen + with.length());
        do {
            buf.append(s.substring(c, i));
            buf.append(with);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < sLen) {
            buf.append(s.substring(c, sLen));
        }
        return buf.toString();
    }

    public static String replaceChar(String s, char sub, char with) {
        char[] str = s.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != sub) continue;
            str[i] = with;
        }
        return new String(str);
    }

    public static String replaceChars(String s, char[] sub, char[] with) {
        char[] str = s.toCharArray();
        block0: for (int i = 0; i < str.length; ++i) {
            char c = str[i];
            for (int j = 0; j < sub.length; ++j) {
                if (c != sub[j]) continue;
                str[i] = with[j];
                continue block0;
            }
        }
        return new String(str);
    }

    public static String replaceFirst(String s, String sub, String with) {
        int i = s.indexOf(sub);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i) + with + s.substring(i + sub.length());
    }

    public static String replaceFirst(String s, char sub, char with) {
        char[] str = s.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != sub) continue;
            str[i] = with;
            break;
        }
        return new String(str);
    }

    public static String replaceLast(String s, String sub, String with) {
        int i = s.lastIndexOf(sub);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i) + with + s.substring(i + sub.length());
    }

    public static String replaceLast(String s, char sub, char with) {
        char[] str = s.toCharArray();
        for (int i = str.length - 1; i >= 0; --i) {
            if (str[i] != sub) continue;
            str[i] = with;
            break;
        }
        return new String(str);
    }

    public static String remove(String s, String sub) {
        int c = 0;
        int sublen = sub.length();
        if (sublen == 0) {
            return s;
        }
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        do {
            buf.append(s.substring(c, i));
        } while ((i = s.indexOf(sub, c = i + sublen)) != -1);
        if (c < s.length()) {
            buf.append(s.substring(c, s.length()));
        }
        return buf.toString();
    }

    public static String removeChars(String src, String chars) {
        int i = src.length();
        StringBuilder stringbuffer = new StringBuilder(i);
        for (int j = 0; j < i; ++j) {
            char c = src.charAt(j);
            if (chars.indexOf(c) != -1) continue;
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    public static String removeChars(String src, char ... chars) {
        int i = src.length();
        StringBuilder stringbuffer = new StringBuilder(i);
        block0: for (int j = 0; j < i; ++j) {
            char c = src.charAt(j);
            for (char aChar : chars) {
                if (c == aChar) continue block0;
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    public static String remove(String src, char chars) {
        int i = src.length();
        StringBuilder stringbuffer = new StringBuilder(i);
        for (int j = 0; j < i; ++j) {
            char c = src.charAt(j);
            if (c == chars) continue;
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    public static boolean equals(String s1, String s2) {
        return ObjectUtil.equals(s1, s2);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isAllEmpty(String ... strings) {
        for (String string : strings) {
            if (StringUtil.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String string) {
        return string == null || StringUtil.containsOnlyWhitespaces(string);
    }

    public static boolean isNotBlank(String string) {
        return string != null && !StringUtil.containsOnlyWhitespaces(string);
    }

    public static boolean isAllBlank(String ... strings) {
        for (String string : strings) {
            if (StringUtil.isBlank(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnlyWhitespaces(String string) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            char c = string.charAt(i);
            if (CharUtil.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return StringConverter.valueOf(obj);
    }

    public static String toNotNullString(Object obj) {
        if (obj == null) {
            return "";
        }
        return StringConverter.valueOf(obj);
    }

    public static String[] toStringArray(Object obj) {
        return StringArrayConverter.valueOf(obj);
    }

    public static String capitalize(String str) {
        return StringUtil.changeFirstCharacterCase(true, str);
    }

    public static String uncapitalize(String str) {
        return StringUtil.changeFirstCharacterCase(false, str);
    }

    private static String changeFirstCharacterCase(boolean capitalize, String str) {
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder(strLen);
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static String truncate(String string, int length) {
        if (string.length() > length) {
            string = string.substring(0, length);
        }
        return string;
    }

    public static String[] split(String src, String delimeter) {
        int i;
        int maxparts = src.length() / delimeter.length() + 2;
        int[] positions = new int[maxparts];
        int dellen = delimeter.length();
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = src.indexOf(delimeter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = src.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = src.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String[] splitc(String src, String d) {
        if (d.length() == 0 || src.length() == 0) {
            return new String[]{src};
        }
        char[] delimiters = d.toCharArray();
        char[] srcc = src.toCharArray();
        int maxparts = srcc.length + 1;
        int[] start = new int[maxparts];
        int[] end = new int[maxparts];
        int count = 0;
        start[0] = 0;
        int s = 0;
        if (CharUtil.equalsOne(srcc[0], delimiters)) {
            end[0] = 0;
            ++count;
            s = CharUtil.findFirstDiff(srcc, 1, delimiters);
            if (s == -1) {
                return new String[]{"", ""};
            }
            start[1] = s;
        }
        while (true) {
            int e;
            if ((e = CharUtil.findFirstEqual(srcc, s, delimiters)) == -1) {
                end[count] = srcc.length;
                break;
            }
            end[count] = e;
            ++count;
            s = CharUtil.findFirstDiff(srcc, e, delimiters);
            if (s == -1) {
                start[count] = end[count] = srcc.length;
                break;
            }
            start[count] = s;
        }
        String[] result = new String[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = src.substring(start[i], end[i]);
        }
        return result;
    }

    public static String[] splitc(String src, char delimiter) {
        if (src.length() == 0) {
            return new String[]{""};
        }
        char[] srcc = src.toCharArray();
        int maxparts = srcc.length + 1;
        int[] start = new int[maxparts];
        int[] end = new int[maxparts];
        int count = 0;
        start[0] = 0;
        int s = 0;
        if (srcc[0] == delimiter) {
            end[0] = 0;
            ++count;
            s = CharUtil.findFirstDiff(srcc, 1, delimiter);
            if (s == -1) {
                return new String[]{"", ""};
            }
            start[1] = s;
        }
        while (true) {
            int e;
            if ((e = CharUtil.findFirstEqual(srcc, s, delimiter)) == -1) {
                end[count] = srcc.length;
                break;
            }
            end[count] = e;
            ++count;
            s = CharUtil.findFirstDiff(srcc, e, delimiter);
            if (s == -1) {
                start[count] = end[count] = srcc.length;
                break;
            }
            start[count] = s;
        }
        String[] result = new String[++count];
        for (int i = 0; i < count; ++i) {
            result[i] = src.substring(start[i], end[i]);
        }
        return result;
    }

    public static int indexOf(String src, String sub, int startIndex, int endIndex) {
        int sublen;
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = src.length())) {
            endIndex = srclen;
        }
        if ((sublen = sub.length()) == 0) {
            return startIndex > srclen ? srclen : startIndex;
        }
        int total = endIndex - sublen + 1;
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i < total; ++i) {
            if (src.charAt(i) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                if (sub.charAt(j) != src.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(String src, char c, int startIndex, int endIndex) {
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = src.length())) {
            endIndex = srclen;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (src.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String src, char c, int startIndex, int endIndex) {
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = src.length())) {
            endIndex = srclen;
        }
        c = Character.toLowerCase(c);
        for (int i = startIndex; i < endIndex; ++i) {
            if (Character.toLowerCase(src.charAt(i)) != c) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String src, String subS) {
        return StringUtil.indexOfIgnoreCase(src, subS, 0, src.length());
    }

    public static int indexOfIgnoreCase(String src, String subS, int startIndex) {
        return StringUtil.indexOfIgnoreCase(src, subS, startIndex, src.length());
    }

    public static int indexOfIgnoreCase(String src, String sub, int startIndex, int endIndex) {
        int sublen;
        int srclen;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (srclen = src.length())) {
            endIndex = srclen;
        }
        if ((sublen = sub.length()) == 0) {
            return startIndex > srclen ? srclen : startIndex;
        }
        sub = sub.toLowerCase();
        int total = endIndex - sublen + 1;
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i < total; ++i) {
            if (Character.toLowerCase(src.charAt(i)) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                char source = Character.toLowerCase(src.charAt(k));
                if (sub.charAt(j) != source) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String s, String subS) {
        return StringUtil.lastIndexOfIgnoreCase(s, subS, s.length(), 0);
    }

    public static int lastIndexOfIgnoreCase(String src, String subS, int startIndex) {
        return StringUtil.lastIndexOfIgnoreCase(src, subS, startIndex, 0);
    }

    public static int lastIndexOfIgnoreCase(String src, String sub, int startIndex, int endIndex) {
        int sublen = sub.length();
        int srclen = src.length();
        if (sublen == 0) {
            return startIndex > srclen ? srclen : (startIndex < -1 ? -1 : startIndex);
        }
        sub = sub.toLowerCase();
        int total = srclen - sublen;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i >= endIndex; --i) {
            if (Character.toLowerCase(src.charAt(i)) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                char source = Character.toLowerCase(src.charAt(k));
                if (sub.charAt(j) != source) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String src, String sub, int startIndex, int endIndex) {
        int sublen = sub.length();
        int srclen = src.length();
        if (sublen == 0) {
            return startIndex > srclen ? srclen : (startIndex < -1 ? -1 : startIndex);
        }
        int total = srclen - sublen;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        char c = sub.charAt(0);
        block0: for (int i = startIndex; i >= endIndex; --i) {
            if (src.charAt(i) != c) continue;
            int j = 1;
            int k = i + 1;
            while (j < sublen) {
                if (sub.charAt(j) != src.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String src, char c, int startIndex, int endIndex) {
        int total = src.length() - 1;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        for (int i = startIndex; i >= endIndex; --i) {
            if (src.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String src, char c, int startIndex, int endIndex) {
        int total = src.length() - 1;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        c = Character.toLowerCase(c);
        for (int i = startIndex; i >= endIndex; --i) {
            if (Character.toLowerCase(src.charAt(i)) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfWhitespace(String src) {
        return StringUtil.lastIndexOfWhitespace(src, src.length(), 0);
    }

    public static int lastIndexOfWhitespace(String src, int startIndex) {
        return StringUtil.lastIndexOfWhitespace(src, startIndex, 0);
    }

    public static int lastIndexOfWhitespace(String src, int startIndex, int endIndex) {
        int total = src.length() - 1;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        for (int i = startIndex; i >= endIndex; --i) {
            if (!Character.isWhitespace(src.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfNonWhitespace(String src) {
        return StringUtil.lastIndexOfNonWhitespace(src, src.length(), 0);
    }

    public static int lastIndexOfNonWhitespace(String src, int startIndex) {
        return StringUtil.lastIndexOfNonWhitespace(src, startIndex, 0);
    }

    public static int lastIndexOfNonWhitespace(String src, int startIndex, int endIndex) {
        int total = src.length() - 1;
        if (total < 0) {
            return -1;
        }
        if (startIndex >= total) {
            startIndex = total;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        for (int i = startIndex; i >= endIndex; --i) {
            if (Character.isWhitespace(src.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWithIgnoreCase(String src, String subS) {
        return StringUtil.startsWithIgnoreCase(src, subS, 0);
    }

    public static boolean startsWithIgnoreCase(String src, String subS, int startIndex) {
        String sub = subS.toLowerCase();
        int sublen = sub.length();
        if (startIndex + sublen > src.length()) {
            return false;
        }
        int j = 0;
        int i = startIndex;
        while (j < sublen) {
            char source = Character.toLowerCase(src.charAt(i));
            if (sub.charAt(j) != source) {
                return false;
            }
            ++j;
            ++i;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String src, String subS) {
        String sub = subS.toLowerCase();
        int sublen = sub.length();
        int j = 0;
        int i = src.length() - sublen;
        if (i < 0) {
            return false;
        }
        while (j < sublen) {
            char source = Character.toLowerCase(src.charAt(i));
            if (sub.charAt(j) != source) {
                return false;
            }
            ++j;
            ++i;
        }
        return true;
    }

    public static boolean startsWithChar(String s, char c) {
        if (s.length() == 0) {
            return false;
        }
        return s.charAt(0) == c;
    }

    public static boolean endsWithChar(String s, char c) {
        if (s.length() == 0) {
            return false;
        }
        return s.charAt(s.length() - 1) == c;
    }

    public static int count(String source, String sub) {
        return StringUtil.count(source, sub, 0);
    }

    public static int count(String source, String sub, int start) {
        int i;
        int count = 0;
        int j = start;
        int sublen = sub.length();
        if (sublen == 0) {
            return 0;
        }
        while ((i = source.indexOf(sub, j)) != -1) {
            ++count;
            j = i + sublen;
        }
        return count;
    }

    public static int count(String source, char c) {
        return StringUtil.count(source, c, 0);
    }

    public static int count(String source, char c, int start) {
        int i;
        int count = 0;
        int j = start;
        while ((i = source.indexOf(c, j)) != -1) {
            ++count;
            j = i + 1;
        }
        return count;
    }

    public static int countIgnoreCase(String source, String sub) {
        int i;
        int count = 0;
        int j = 0;
        int sublen = sub.length();
        if (sublen == 0) {
            return 0;
        }
        while ((i = StringUtil.indexOfIgnoreCase(source, sub, j)) != -1) {
            ++count;
            j = i + sublen;
        }
        return count;
    }

    public static int[] indexOf(String s, String[] arr) {
        return StringUtil.indexOf(s, arr, 0);
    }

    public static int[] indexOf(String s, String[] arr, int start) {
        int[] nArray;
        int arrLen = arr.length;
        int index = Integer.MAX_VALUE;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = s.indexOf(arr[j], start);
            if (i == -1 || i >= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] indexOfIgnoreCase(String s, String[] arr) {
        return StringUtil.indexOfIgnoreCase(s, arr, 0);
    }

    public static int[] indexOfIgnoreCase(String s, String[] arr, int start) {
        int[] nArray;
        int arrLen = arr.length;
        int index = Integer.MAX_VALUE;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = StringUtil.indexOfIgnoreCase(s, arr[j], start);
            if (i == -1 || i >= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] lastIndexOf(String s, String[] arr) {
        return StringUtil.lastIndexOf(s, arr, s.length());
    }

    public static int[] lastIndexOf(String s, String[] arr, int fromIndex) {
        int[] nArray;
        int arrLen = arr.length;
        int index = -1;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = s.lastIndexOf(arr[j], fromIndex);
            if (i == -1 || i <= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static int[] lastIndexOfIgnoreCase(String s, String[] arr) {
        return StringUtil.lastIndexOfIgnoreCase(s, arr, s.length());
    }

    public static int[] lastIndexOfIgnoreCase(String s, String[] arr, int fromIndex) {
        int[] nArray;
        int arrLen = arr.length;
        int index = -1;
        int last = -1;
        for (int j = 0; j < arrLen; ++j) {
            int i = StringUtil.lastIndexOfIgnoreCase(s, arr[j], fromIndex);
            if (i == -1 || i <= index) continue;
            index = i;
            last = j;
        }
        if (last == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = last;
            nArray = nArray2;
            nArray2[1] = index;
        }
        return nArray;
    }

    public static boolean equals(String[] as, String[] as1) {
        if (as.length != as1.length) {
            return false;
        }
        for (int i = 0; i < as.length; ++i) {
            if (as[i].equals(as1[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String[] as, String[] as1) {
        if (as.length != as1.length) {
            return false;
        }
        for (int i = 0; i < as.length; ++i) {
            if (as[i].equalsIgnoreCase(as1[i])) continue;
            return false;
        }
        return true;
    }

    public static String replace(String s, String[] sub, String[] with) {
        int[] res;
        if (sub.length != with.length || sub.length == 0) {
            return s;
        }
        int start = 0;
        StringBuilder buf = new StringBuilder(s.length());
        while ((res = StringUtil.indexOf(s, sub, start)) != null) {
            int end = res[1];
            buf.append(s.substring(start, end));
            buf.append(with[res[0]]);
            start = end + sub[res[0]].length();
        }
        buf.append(s.substring(start));
        return buf.toString();
    }

    public static String replaceIgnoreCase(String s, String[] sub, String[] with) {
        int[] res;
        if (sub.length != with.length || sub.length == 0) {
            return s;
        }
        int start = 0;
        StringBuilder buf = new StringBuilder(s.length());
        while ((res = StringUtil.indexOfIgnoreCase(s, sub, start)) != null) {
            int end = res[1];
            buf.append(s.substring(start, end));
            buf.append(with[res[0]]);
            start = end + sub[0].length();
        }
        buf.append(s.substring(start));
        return buf.toString();
    }

    public static int equalsOne(String src, String[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            if (!src.equals(dest[i])) continue;
            return i;
        }
        return -1;
    }

    public static int equalsOneIgnoreCase(String src, String[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            if (!src.equalsIgnoreCase(dest[i])) continue;
            return i;
        }
        return -1;
    }

    public static int startsWithOne(String src, String[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !src.startsWith(m)) continue;
            return i;
        }
        return -1;
    }

    public static int startsWithOneIgnoreCase(String src, String[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !StringUtil.startsWithIgnoreCase(src, m)) continue;
            return i;
        }
        return -1;
    }

    public static int endsWithOne(String src, String[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !src.endsWith(m)) continue;
            return i;
        }
        return -1;
    }

    public static int endsWithOneIgnoreCase(String src, String[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            String m = dest[i];
            if (m == null || !StringUtil.endsWithIgnoreCase(src, m)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfChars(String string, String chars) {
        return StringUtil.indexOfChars(string, chars, 0);
    }

    public static int indexOfChars(String string, String chars, int startindex) {
        int stringLen = string.length();
        int charsLen = chars.length();
        if (startindex < 0) {
            startindex = 0;
        }
        for (int i = startindex; i < stringLen; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < charsLen; ++j) {
                if (c != chars.charAt(j)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfChars(String string, char[] chars) {
        return StringUtil.indexOfChars(string, chars, 0);
    }

    public static int indexOfChars(String string, char[] chars, int startindex) {
        int stringLen = string.length();
        int charsLen = chars.length;
        for (int i = startindex; i < stringLen; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < charsLen; ++j) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfWhitespace(String string) {
        return StringUtil.indexOfWhitespace(string, 0, string.length());
    }

    public static int indexOfWhitespace(String string, int startindex) {
        return StringUtil.indexOfWhitespace(string, startindex, string.length());
    }

    public static int indexOfWhitespace(String string, int startindex, int endindex) {
        for (int i = startindex; i < endindex; ++i) {
            if (!CharUtil.isWhitespace(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNonWhitespace(String string) {
        return StringUtil.indexOfNonWhitespace(string, 0, string.length());
    }

    public static int indexOfNonWhitespace(String string, int startindex) {
        return StringUtil.indexOfNonWhitespace(string, startindex, string.length());
    }

    public static int indexOfNonWhitespace(String string, int startindex, int endindex) {
        for (int i = startindex; i < endindex; ++i) {
            if (CharUtil.isWhitespace(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String stripLeadingChar(String string, char c) {
        if (string.length() > 0 && string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }

    public static String stripTrailingChar(String string, char c) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void trimAll(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (string == null) continue;
            strings[i] = string.trim();
        }
    }

    public static void trimDownAll(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (string == null) continue;
            strings[i] = StringUtil.trimDown(string);
        }
    }

    public static String trimDown(String string) {
        if ((string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static String crop(String string) {
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public static void cropAll(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (string != null) {
                string = StringUtil.crop(strings[i]);
            }
            strings[i] = string;
        }
    }

    public static String trimLeft(String src) {
        int st;
        int len = src.length();
        for (st = 0; st < len && CharUtil.isWhitespace(src.charAt(st)); ++st) {
        }
        return st > 0 ? src.substring(st) : src;
    }

    public static String trimRight(String src) {
        int len;
        int count = len = src.length();
        while (len > 0 && CharUtil.isWhitespace(src.charAt(len - 1))) {
            --len;
        }
        return len < count ? src.substring(0, len) : src;
    }

    public static int[] indexOfRegion(String string, String leftBoundary, String rightBoundary) {
        return StringUtil.indexOfRegion(string, leftBoundary, rightBoundary, 0);
    }

    public static int[] indexOfRegion(String string, String leftBoundary, String rightBoundary, int offset) {
        int ndx = offset;
        int[] res = new int[4];
        if ((ndx = string.indexOf(leftBoundary, ndx)) == -1) {
            return null;
        }
        res[0] = ndx;
        res[1] = ndx += leftBoundary.length();
        if ((ndx = string.indexOf(rightBoundary, ndx)) == -1) {
            return null;
        }
        res[2] = ndx;
        res[3] = ndx + rightBoundary.length();
        return res;
    }

    public static int[] indexOfRegion(String string, String leftBoundary, String rightBoundary, char escape) {
        return StringUtil.indexOfRegion(string, leftBoundary, rightBoundary, escape, 0);
    }

    public static int[] indexOfRegion(String string, String leftBoundary, String rightBoundary, char escape, int offset) {
        int leftBoundaryLen;
        int ndx = offset;
        int[] res = new int[4];
        while (true) {
            if ((ndx = string.indexOf(leftBoundary, ndx)) == -1) {
                return null;
            }
            leftBoundaryLen = leftBoundary.length();
            if (ndx <= 0 || string.charAt(ndx - 1) != escape) break;
            boolean cont = true;
            if (ndx > 1 && string.charAt(ndx - 2) == escape) {
                --ndx;
                ++leftBoundaryLen;
                cont = false;
            }
            if (!cont) break;
            ndx += leftBoundaryLen;
        }
        res[0] = ndx;
        res[1] = ndx += leftBoundaryLen;
        while (true) {
            if ((ndx = string.indexOf(rightBoundary, ndx)) == -1) {
                return null;
            }
            if (ndx <= 0 || string.charAt(ndx - 1) != escape) break;
            ndx += rightBoundary.length();
        }
        res[2] = ndx;
        res[3] = ndx + rightBoundary.length();
        return res;
    }

    public static String join(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    public static String join(Iterable<?> elements, String separator) {
        if (elements == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (separator == null) {
            separator = "";
        }
        for (Object o : elements) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(o);
        }
        return buf.toString();
    }

    public static String convertCharset(String source, String srcCharsetName, String newCharsetName) throws UnsupportedEncodingException {
        return new String(source.getBytes(srcCharsetName), newCharsetName);
    }

    public static boolean isCharAtEqual(String string, int index, char charToCompare) {
        if (index < 0 || index >= string.length()) {
            return false;
        }
        return string.charAt(index) == charToCompare;
    }

    public static String surround(String string, String fix) {
        return StringUtil.surround(string, fix, fix);
    }

    public static String surround(String string, String prefix, String suffix) {
        if (!string.startsWith(prefix)) {
            string = prefix + string;
        }
        if (!string.endsWith(suffix)) {
            string = string + suffix;
        }
        return string;
    }

    public static String prefix(String string, String prefix) {
        if (!string.startsWith(prefix)) {
            string = prefix + string;
        }
        return string;
    }

    public static String suffix(String string, String suffix) {
        if (!string.endsWith(suffix)) {
            string = string + suffix;
        }
        return string;
    }

    public static String cutFromIndexOf(String string, String substring) {
        int i = string.indexOf(substring);
        if (i != -1) {
            string = string.substring(0, i);
        }
        return string;
    }

    public static String cutFromIndexOf(String string, char c) {
        int i = string.indexOf(c);
        if (i != -1) {
            string = string.substring(0, i);
        }
        return string;
    }

    public static String cutToIndexOf(String string, String substring) {
        int i = string.indexOf(substring);
        if (i != -1) {
            string = string.substring(i);
        }
        return string;
    }

    public static String cutToIndexOf(String string, char c) {
        int i = string.indexOf(c);
        if (i != -1) {
            string = string.substring(i);
        }
        return string;
    }

    public static String cutPreffix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            string = string.substring(prefix.length());
        }
        return string;
    }

    public static String cutSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            string = string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String cutSurrounding(String string, String fix) {
        return StringUtil.cutSurrounding(string, fix, fix);
    }

    public static String cutSurrounding(String string, String prefix, String suffix) {
        int start = 0;
        int end = string.length();
        if (string.startsWith(prefix)) {
            start = prefix.length();
        }
        if (string.endsWith(suffix)) {
            end -= suffix.length();
        }
        return string.substring(start, end);
    }

    public static boolean isCharAtEscaped(String src, int ndx, char escapeChar) {
        if (ndx == 0) {
            return false;
        }
        return src.charAt(--ndx) == escapeChar;
    }

    public static int indexOfUnescapedChar(String src, char sub, char escapeChar) {
        return StringUtil.indexOfUnescapedChar(src, sub, escapeChar, 0);
    }

    public static int indexOfUnescapedChar(String src, char sub, char escapeChar, int startIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        int srclen = src.length();
        char c = '\u0000';
        for (int i = startIndex; i < srclen; ++i) {
            char previous = c;
            c = src.charAt(i);
            if (c != sub || i > startIndex && previous == escapeChar) continue;
            return i;
        }
        return -1;
    }

    public static String insert(String src, String insert) {
        return StringUtil.insert(src, insert, 0);
    }

    public static String insert(String src, String insert, int offset) {
        if (offset < 0) {
            offset = 0;
        }
        if (offset > src.length()) {
            offset = src.length();
        }
        StringBuilder sb = new StringBuilder(src);
        sb.insert(offset, insert);
        return sb.toString();
    }

    public static String repeat(String source, int count) {
        StringBuilder result = new StringBuilder(count * source.length());
        while (count > 0) {
            result.append(source);
            --count;
        }
        return result.toString();
    }

    public static String repeat(char c, int count) {
        StringBuilder result = new StringBuilder(count);
        while (count > 0) {
            result.append(c);
            --count;
        }
        return result.toString();
    }

    public static String reverse(String s) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static String maxCommonPrefix(String one, String two) {
        char currentChar;
        int minLength = Math.min(one.length(), two.length());
        StringBuilder sb = new StringBuilder(minLength);
        for (int pos = 0; pos < minLength && (currentChar = one.charAt(pos)) == two.charAt(pos); ++pos) {
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String camelCaseToWords(String input) {
        StringBuilder s = new StringBuilder();
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (Character.isUpperCase(ch) && i > 0) {
                s.append(' ');
                ch = Character.toLowerCase(ch);
            } else if (i == 0 && !Character.isUpperCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            if (ch == '.') {
                s.append(' ');
            }
            s.append(ch);
        }
        return s.toString();
    }

    public static String wordsToCamelCase(String input) {
        StringBuilder s = new StringBuilder();
        int length = input.length();
        boolean upperCase = false;
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (ch == ' ') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                s.append(Character.toUpperCase(ch));
                upperCase = false;
                continue;
            }
            s.append(ch);
        }
        return s.toString();
    }
}

