/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import jodd.JoddDefault;
import jodd.util.ReflectUtil;

public class ClassLoaderUtil {
    public static void addFileToClassPath(String path) {
        ClassLoaderUtil.addFileToClassPath(path, (URLClassLoader)JoddDefault.classLoader);
    }

    public static void addFileToClassPath(String path, URLClassLoader classLoader) {
        ClassLoaderUtil.addFileToClassPath(new File(path), classLoader);
    }

    public static void addFileToClassPath(File path) {
        ClassLoaderUtil.addFileToClassPath(path, (URLClassLoader)JoddDefault.classLoader);
    }

    public static void addFileToClassPath(File path, URLClassLoader classLoader) {
        try {
            ClassLoaderUtil.addUrlToClassPath(path.toURL(), classLoader);
        }
        catch (MalformedURLException muex) {
            throw new IllegalArgumentException("Unable to convert path to URL: '" + path + "'.", muex);
        }
    }

    public static void addUrlToClassPath(URL url) {
        ClassLoaderUtil.addUrlToClassPath(url, (URLClassLoader)JoddDefault.classLoader);
    }

    public static void addUrlToClassPath(URL url, URLClassLoader classLoader) {
        try {
            ReflectUtil.invokeDeclared(URLClassLoader.class, classLoader, "addURL", new Class[]{URL.class}, new Object[]{url});
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to extend classpath with URL: '" + url + "'.", ex);
        }
    }

    public static Class defineClass(byte[] classData) {
        return ClassLoaderUtil.defineClass(null, classData, JoddDefault.classLoader);
    }

    public static Class defineClass(String className, byte[] classData) {
        return ClassLoaderUtil.defineClass(className, classData, JoddDefault.classLoader);
    }

    public static Class defineClass(byte[] classData, ClassLoader classLoader) {
        return ClassLoaderUtil.defineClass(null, classData, classLoader);
    }

    public static Class defineClass(String className, byte[] classData, ClassLoader classLoader) {
        try {
            return (Class)ReflectUtil.invokeDeclared(ClassLoader.class, classLoader, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{className, classData, new Integer(0), new Integer(classData.length)});
        }
        catch (Throwable th) {
            throw new RuntimeException("Unable to define class '" + className + "'.", th);
        }
    }

    public static Class findClass(String className) {
        return ClassLoaderUtil.findClass(className, ClassLoaderUtil.getFullClassPath(ClassLoaderUtil.class), null);
    }

    public static Class findClass(String className, ClassLoader parent) {
        return ClassLoaderUtil.findClass(className, ClassLoaderUtil.getFullClassPath(ClassLoaderUtil.class), parent);
    }

    public static Class findClass(String className, URL[] classPath) {
        return ClassLoaderUtil.findClass(className, classPath, null);
    }

    public static Class findClass(String className, URL[] classPath, ClassLoader parent) {
        URLClassLoader tempClassLoader = parent != null ? new URLClassLoader(classPath, parent) : new URLClassLoader(classPath);
        try {
            return (Class)ReflectUtil.invokeDeclared(URLClassLoader.class, tempClassLoader, "findClass", new Class[]{String.class}, new Object[]{className});
        }
        catch (Throwable th) {
            throw new RuntimeException("Unable to find class '" + className + "'.", th);
        }
    }

    public static URL[] getFullClassPath(Class clazz) {
        return ClassLoaderUtil.getFullClassPath(clazz.getClassLoader());
    }

    public static URL[] getFullClassPath(ClassLoader classLoader) {
        ArrayList<URL> list = new ArrayList<URL>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                list.addAll(Arrays.asList(urls));
            }
            classLoader = classLoader.getParent();
        }
        URL[] result = new URL[list.size()];
        return list.toArray(result);
    }

    public static URL getResourceUrl(String resourceName) {
        return ClassLoaderUtil.getResourceUrl(resourceName, null);
    }

    public static URL getResourceUrl(String resourceName, Class callingClass) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = ClassLoaderUtil.class.getClassLoader().getResource(resourceName);
        }
        if (url == null && callingClass != null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        return url;
    }

    public static File getResourceFile(String resourceName) {
        return ClassLoaderUtil.getResourceFile(resourceName, null);
    }

    public static File getResourceFile(String resourceName, Class callingClass) {
        try {
            return new File(ClassLoaderUtil.getResourceUrl(resourceName, callingClass).toURI());
        }
        catch (URISyntaxException usex) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(resourceName, ClassLoaderUtil.class);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) throws IOException {
        URL url = ClassLoaderUtil.getResourceUrl(resourceName, callingClass);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class clazz) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(clazz), clazz);
    }

    public static InputStream getClassAsStream(String className) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(className), ClassLoaderUtil.class);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass(className, null);
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfex1) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnfex2) {
                try {
                    return ClassLoaderUtil.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException cnfex3) {
                    if (callingClass != null) {
                        return callingClass.getClassLoader().loadClass(className);
                    }
                    throw cnfex3;
                }
            }
        }
    }

    public static String getClassFileName(Class clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return ClassLoaderUtil.getClassFileName(clazz.getName());
    }

    public static String getClassFileName(String className) {
        return className.replace('.', '/') + ".class";
    }
}

