/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArrayConverter
implements TypeConverter<short[]> {
    public static short[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof Number) {
                return new short[]{((Number)value).shortValue()};
            }
            try {
                return new short[]{Short.parseShort(value.toString())};
            }
            catch (NumberFormatException nfex) {
                throw new TypeConversionException(value, (Throwable)nfex);
            }
        }
        if (type == short[].class) {
            return (short[])value;
        }
        if (type == int[].class) {
            int[] values = (int[])value;
            short[] results = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (short)values[i];
            }
            return results;
        }
        if (type == long[].class) {
            long[] values = (long[])value;
            short[] results = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (short)values[i];
            }
            return results;
        }
        if (type == double[].class) {
            double[] values = (double[])value;
            short[] results = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (short)values[i];
            }
            return results;
        }
        if (type == byte[].class) {
            byte[] values = (byte[])value;
            short[] results = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == float[].class) {
            float[] values = (float[])value;
            short[] results = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (short)values[i];
            }
            return results;
        }
        if (type == boolean[].class) {
            boolean[] values = (boolean[])value;
            short[] results = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (short)(values[i] ? 1 : 0);
            }
            return results;
        }
        Object[] values = (Object[])value;
        short[] results = new short[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] instanceof Number ? ((Number)values[i]).shortValue() : Short.parseShort(values[i].toString());
            }
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
        return results;
    }

    @Override
    public short[] convert(Object value) {
        return ShortArrayConverter.valueOf(value);
    }
}

