/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload.impl;

import java.io.File;
import java.io.IOException;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.FileUploadFactory;
import jodd.servlet.upload.MultipartRequestInputStream;
import jodd.servlet.upload.impl.DiskFileUpload;
import jodd.util.SystemUtil;

public class DiskFileUploadFactory
implements FileUploadFactory {
    protected File destFolder;
    protected int maxFileSize = 102400;

    public DiskFileUploadFactory() throws IOException {
        this(SystemUtil.getTempDir());
    }

    public DiskFileUploadFactory(String destFolder) throws IOException {
        this(destFolder, 102400);
    }

    public DiskFileUploadFactory(String destFolder, int maxFileSize) throws IOException {
        this.setUploadDir(destFolder);
        this.maxFileSize = maxFileSize;
    }

    public void setUploadDir(String destFolder) throws IOException {
        File destination;
        if (destFolder == null) {
            destFolder = SystemUtil.getTempDir();
        }
        if (!(destination = new File(destFolder)).exists()) {
            destination.mkdirs();
        }
        if (!destination.isDirectory()) {
            throw new IOException("Destination folder is invalid: '" + destFolder + "'.");
        }
        this.destFolder = destination;
    }

    public DiskFileUploadFactory uploadDir(String destFolder) throws IOException {
        this.setUploadDir(destFolder);
        return this;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public DiskFileUploadFactory maxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public FileUpload create(MultipartRequestInputStream input) {
        return new DiskFileUpload(input, this.destFolder, this.maxFileSize);
    }
}

