/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import jodd.util.StringUtil;

public abstract class ResourceScanner {
    protected static final String WEB_INF_PATH = "/WEB-INF/";
    protected final ServletContext servletContext;
    protected boolean ignoreWebInf;
    protected boolean recursive;
    protected boolean includeDirs = true;
    protected boolean includeFiles = true;

    protected ResourceScanner(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean isIgnoreWebInf() {
        return this.ignoreWebInf;
    }

    public void setIgnoreWebInf(boolean ignoreWebInf) {
        this.ignoreWebInf = ignoreWebInf;
    }

    public ResourceScanner ignoreWebInf(boolean ignoreWebibnf) {
        this.ignoreWebInf = ignoreWebibnf;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public ResourceScanner recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isIncludeDirs() {
        return this.includeDirs;
    }

    public void setIncludeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
    }

    public ResourceScanner includeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
        return this;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }

    public ResourceScanner includeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
        return this;
    }

    public ResourceScanner includeFilesAndFolders() {
        this.includeDirs = true;
        this.includeFiles = true;
        return this;
    }

    public void scan() {
        this.scan("/");
    }

    public void scan(String startPath) {
        Set allpaths = this.servletContext.getResourcePaths(startPath);
        if (allpaths == null) {
            return;
        }
        for (String path : allpaths) {
            this.process(path);
        }
    }

    protected void process(String path) {
        boolean isFolder = StringUtil.endsWithChar(path, '/');
        if (isFolder) {
            if (this.ignoreWebInf && StringUtil.startsWithIgnoreCase(path, WEB_INF_PATH)) {
                return;
            }
            if (this.includeDirs) {
                this.onResource(path, isFolder);
            }
            if (this.recursive && this.acceptFolder(path)) {
                this.scan(path);
            }
            return;
        }
        if (this.includeFiles) {
            this.onResource(path, isFolder);
        }
    }

    protected boolean acceptFolder(String path) {
        return true;
    }

    protected abstract void onResource(String var1, boolean var2);

    protected InputStream openResource(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    protected String getResourceName(String path) {
        int ndx = path.lastIndexOf(47);
        if (ndx == -1) {
            return path;
        }
        return path.substring(ndx);
    }
}

