/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail.att;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import jodd.JoddDefault;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.StreamUtil;

public class ByteArrayDataSource
implements DataSource {
    protected byte[] data;
    protected String type;

    public ByteArrayDataSource(File f, String type) throws IOException {
        if (type == null) {
            type = FileTypeMap.getDefaultFileTypeMap().getContentType(f);
        }
        this.type = type;
        FileInputStream in = new FileInputStream(f);
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        StreamUtil.copy((InputStream)in, (OutputStream)out);
        this.data = out.toByteArray();
        StreamUtil.close(in);
    }

    public ByteArrayDataSource(InputStream is, String type) throws IOException {
        this.type = type;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        StreamUtil.copy(is, (OutputStream)out);
        this.data = out.toByteArray();
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.type = type;
        this.data = data;
    }

    public ByteArrayDataSource(String data, String type) {
        this(data, type, JoddDefault.encoding);
    }

    public ByteArrayDataSource(String data, String type, String encoding) {
        this.type = type;
        try {
            this.data = data.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uex) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("No data.");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not supported.");
    }

    public String getContentType() {
        return this.type;
    }

    public void setContentType(String type) {
        this.type = type;
    }

    public String getName() {
        return "";
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.data);
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public int getSize() {
        if (this.data == null) {
            return -1;
        }
        return this.data.length;
    }

    public String getText() {
        try {
            return new String(this.data, this.type);
        }
        catch (UnsupportedEncodingException uex) {
            try {
                return new String(this.data, JoddDefault.encoding);
            }
            catch (UnsupportedEncodingException uex1) {
                return null;
            }
        }
    }
}

