/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.Map;
import jodd.cache.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheMap<K, V>
implements Cache<K, V> {
    protected Map<K, CacheObject> cacheMap;
    protected int cacheSize;
    protected long timeout;
    protected boolean existCustomTimeout;

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getCacheTimeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    @Override
    public void put(K key, V object, long timeout) {
        CacheObject co = new CacheObject(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.prune();
        }
        this.cacheMap.put(key, co);
    }

    @Override
    public V get(K key) {
        CacheObject co = this.cacheMap.get(key);
        if (co == null) {
            return null;
        }
        if (co.isExpired()) {
            this.remove(key);
            return null;
        }
        return co.getObject();
    }

    @Override
    public abstract int prune();

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.cacheSize;
    }

    @Override
    public void remove(K key) {
        this.cacheMap.remove(key);
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheObject {
        final K key;
        final V cachedObject;
        long lastAccess;
        int accessCount;
        long ttl;

        CacheObject(K key, V object, long ttl) {
            this.key = key;
            this.cachedObject = object;
            this.ttl = ttl;
            this.lastAccess = System.currentTimeMillis();
        }

        boolean isExpired() {
            if (this.ttl == 0L) {
                return false;
            }
            return this.lastAccess + this.ttl < System.currentTimeMillis();
        }

        V getObject() {
            this.lastAccess = System.currentTimeMillis();
            ++this.accessCount;
            return this.cachedObject;
        }
    }
}

