/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.TreeSet;
import jodd.bean.BeanException;
import jodd.bean.BeanLoaderManager;
import jodd.bean.BeanUtil;
import jodd.bean.loader.BeanLoader;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.util.ArraysUtil;
import jodd.util.PrettyStringBuilder;

public class BeanTool {
    private static final String MACRO_START = "${";

    public static void copy(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.copy(source, destination, true, suppressSecurity);
    }

    public static void apply(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.copy(source, destination, false, suppressSecurity);
    }

    public static void copy(Object source, Object destination) {
        BeanTool.copy(source, destination, true, false);
    }

    public static void apply(Object source, Object destination) {
        BeanTool.copy(source, destination, false, false);
    }

    public static void copy(Object source, Object destination, boolean copyNulls, boolean suppressSecurity) {
        String[] mdata;
        ClassDescriptor cdSrc = ClassIntrospector.lookup(source.getClass());
        ClassDescriptor cdDest = ClassIntrospector.lookup(destination.getClass());
        for (String name : mdata = cdSrc.getAllBeanGetterNames(suppressSecurity)) {
            if (cdDest.getBeanSetter(name, suppressSecurity) == null) continue;
            Object value = BeanUtil.getProperty(source, name);
            if (!copyNulls && value == null) continue;
            BeanUtil.setPropertySilent(destination, name, value);
        }
    }

    public static void copyProperties(Object source, Object destination) {
        BeanTool.copyProperties(source, destination, null, true);
    }

    public static void copyProperties(Object source, Object destination, String[] properties, boolean include) {
        String[] mdata;
        ClassDescriptor cdSrc = ClassIntrospector.lookup(source.getClass());
        ClassDescriptor cdDest = ClassIntrospector.lookup(destination.getClass());
        for (String name : mdata = cdSrc.getAllBeanGetterNames()) {
            if (properties != null && (!include ? ArraysUtil.contains(properties, name) : !ArraysUtil.contains(properties, name)) || cdDest.getBeanSetter(name) == null) continue;
            Object value = BeanUtil.getProperty(source, name);
            BeanUtil.setPropertySilent(destination, name, value);
        }
    }

    public static void copyProperties(Object source, Object destination, Class editable) {
        ClassDescriptor cd = ClassIntrospector.lookup(editable);
        String[] properties = cd.getAllBeanGetterNames();
        BeanTool.copyProperties(source, destination, properties, true);
    }

    public static void copyFields(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.copyFields(source, destination, true, suppressSecurity);
    }

    public static void applyFields(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.copyFields(source, destination, false, suppressSecurity);
    }

    public static void copyFields(Object source, Object destination, boolean copyNulls, boolean suppressSecurity) {
        Field[] fields;
        ClassDescriptor cdSrc = ClassIntrospector.lookup(source.getClass());
        ClassDescriptor cdDest = ClassIntrospector.lookup(destination.getClass());
        for (Field field : fields = cdSrc.getAllFields(suppressSecurity)) {
            Field destField = cdDest.getField(field.getName(), suppressSecurity);
            if (destField == null) continue;
            try {
                Object value = field.get(source);
                if (!copyNulls && value == null) continue;
                destField.set(destination, value);
            }
            catch (IllegalAccessException iaex) {
                // empty catch block
            }
        }
    }

    public static void copyFields(Object source, Object destination) {
        BeanTool.copyFields(source, destination, true, false);
    }

    public static void applyFields(Object source, Object destination) {
        BeanTool.copyFields(source, destination, false, false);
    }

    public static void load(Object bean, Object source) {
        BeanLoader loader = BeanLoaderManager.lookup(source);
        if (loader == null) {
            throw new BeanException("No registered bean loader for source: " + source.getClass().getName());
        }
        loader.load(bean, source);
    }

    public static void load(Object bean, Object source, Class type) {
        BeanLoader loader = BeanLoaderManager.lookup(type);
        if (loader == null) {
            throw new BeanException("No registered bean loader for type: " + type.getName());
        }
        loader.load(bean, source);
    }

    public static String parseTemplate(String template, Object context) {
        StringBuilder result = new StringBuilder(template.length());
        int i = 0;
        int len = template.length();
        while (i < len) {
            int ndx = template.indexOf(MACRO_START, i);
            if (ndx == -1) {
                result.append(i == 0 ? template : template.substring(i));
                break;
            }
            boolean escape = false;
            int count = 0;
            for (int j = ndx - 1; j >= 0 && template.charAt(j) == '\\'; --j) {
                boolean bl = escape = !escape;
                if (!escape) continue;
                ++count;
            }
            result.append(template.substring(i, ndx - count));
            if (escape) {
                result.append(MACRO_START);
                i = ndx + 2;
                continue;
            }
            int ndx2 = template.indexOf(125, ndx += 2);
            if (ndx2 == -1) {
                throw new BeanException("Bad bean template format - unclosed macro at: " + (ndx - 2));
            }
            String name = template.substring(ndx, ndx2);
            Object value = BeanUtil.getDeclaredProperty(context, name);
            if (value != null) {
                result.append(value.toString());
            }
            i = ndx2 + 1;
        }
        return result.toString();
    }

    public static String attributesToString(Object bean) {
        Field[] fields;
        PrettyStringBuilder prettyString = new PrettyStringBuilder();
        if (bean == null) {
            return prettyString.toString(bean);
        }
        TreeSet<String> ts = new TreeSet<String>();
        ClassDescriptor cd = ClassIntrospector.lookup(bean.getClass());
        for (Field field : fields = cd.getAllFields(true)) {
            StringBuilder s = new StringBuilder();
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                s.append('+');
            } else if (Modifier.isProtected(modifiers)) {
                s.append('#');
            } else if (Modifier.isPrivate(modifiers)) {
                s.append('-');
            } else {
                s.append(' ');
            }
            s.append(field.getName()).append(':');
            try {
                Object value = field.get(bean);
                s.append(prettyString.toString(value));
            }
            catch (IllegalAccessException iaex) {
                s.append("N/A");
            }
            s.append('\n');
            ts.add(s.toString());
        }
        StringBuilder s = new StringBuilder();
        for (String s1 : ts) {
            s.append(s1);
        }
        return s.toString();
    }
}

