/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.javax.converter.support;

import java.io.FileReader;
import java.io.PrintWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.compass.core.xml.javax.converter.support.Stax2DomBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Dom2StaxSerializer {
    protected final XMLStreamWriter mWriter;
    protected final boolean mRepairing;

    public Dom2StaxSerializer(XMLStreamWriter sw) {
        this.mWriter = sw;
        Object o = sw.getProperty("javax.xml.stream.isRepairingNamespaces");
        this.mRepairing = o instanceof Boolean && (Boolean)o != false;
    }

    public void output(Document doc) throws XMLStreamException {
        this.mWriter.writeStartDocument();
        NsStack nsStack = NsStack.defaultInstance();
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.doOutputNode(child, nsStack);
        }
        this.mWriter.writeEndDocument();
        this.doClose();
    }

    public void outputFragment(NodeList nodes) throws XMLStreamException {
        NsStack nss = NsStack.defaultInstance();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            this.doOutputNode(nodes.item(i), nss);
        }
    }

    public void outputFragment(Node node) throws XMLStreamException {
        this.doOutputNode(node, NsStack.defaultInstance());
    }

    protected void doOutputElement(Element elem, NsStack nsStack) throws XMLStreamException {
        String elemUri;
        boolean sharedNsStack = true;
        String elemPrefix = elem.getPrefix();
        if (elemPrefix == null) {
            elemPrefix = "";
        }
        if ((elemUri = elem.getNamespaceURI()) == null) {
            elemUri = "";
        }
        this.mWriter.writeStartElement(elemPrefix, elem.getLocalName(), elemUri);
        if (!this.mRepairing && !nsStack.hasBinding(elemPrefix, elemUri)) {
            nsStack = nsStack.childInstance();
            sharedNsStack = false;
            nsStack.addBinding(elemPrefix, elemUri);
            if (elemPrefix.length() == 0) {
                this.mWriter.setDefaultNamespace(elemUri);
                this.mWriter.writeDefaultNamespace(elemUri);
            } else {
                this.mWriter.setPrefix(elemPrefix, elemUri);
                this.mWriter.writeNamespace(elemPrefix, elemUri);
            }
        }
        NamedNodeMap attrs = elem.getAttributes();
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String aPrefix = attr.getPrefix();
            String ln = attr.getLocalName();
            String value = attr.getValue();
            if (aPrefix == null || aPrefix.length() == 0) {
                this.mWriter.writeAttribute(ln, value);
                continue;
            }
            String aNsUri = attr.getNamespaceURI();
            if (!this.mRepairing && !nsStack.hasBinding(aPrefix, aNsUri)) {
                if (sharedNsStack) {
                    nsStack = nsStack.childInstance();
                    sharedNsStack = false;
                }
                nsStack.addBinding(aPrefix, aNsUri);
                this.mWriter.setPrefix(aPrefix, aNsUri);
                this.mWriter.writeNamespace(aPrefix, aNsUri);
            }
            this.mWriter.writeAttribute(aPrefix, aNsUri, attr.getLocalName(), attr.getValue());
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.doOutputNode(child, nsStack);
        }
        this.mWriter.writeEndElement();
    }

    protected void doOutputNode(Node node, NsStack nsStack) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 1: {
                this.doOutputElement((Element)node, nsStack);
                break;
            }
            case 3: {
                this.mWriter.writeCharacters(node.getNodeValue());
                break;
            }
            case 4: {
                this.mWriter.writeCData(node.getNodeValue());
                break;
            }
            case 8: {
                this.mWriter.writeComment(node.getNodeValue());
                break;
            }
            case 5: {
                this.mWriter.writeEntityRef(node.getNodeName());
                break;
            }
            case 7: {
                String target = node.getNodeName();
                String data = node.getNodeValue();
                if (data == null || data.length() == 0) {
                    this.mWriter.writeProcessingInstruction(target);
                    break;
                }
                this.mWriter.writeProcessingInstruction(target, data);
                break;
            }
            case 10: {
                this.mWriter.writeDTD(this.buildDTD((DocumentType)node));
                break;
            }
            default: {
                throw new XMLStreamException("Unrecognized or unexpected node class: " + node.getClass().getName());
            }
        }
    }

    protected void doClose() throws XMLStreamException {
        this.mWriter.close();
    }

    protected String buildDTD(DocumentType doctype) {
        String intSubset;
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE ");
        sb.append(doctype.getName());
        String pubId = doctype.getPublicId();
        String sysId = doctype.getSystemId();
        if (pubId == null || pubId.length() == 0) {
            if (sysId != null && sysId.length() > 0) {
                sb.append("SYSTEM \"");
                sb.append(sysId);
                sb.append('\"');
            }
        } else {
            sb.append("PUBLIC \"");
            sb.append(pubId);
            sb.append("\" \"");
            sb.append(sysId);
            sb.append('\"');
        }
        if ((intSubset = doctype.getInternalSubset()) != null && intSubset.length() > 0) {
            sb.append(" [");
            sb.append(intSubset);
            sb.append(']');
        }
        sb.append('>');
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java ... [file]");
            System.exit(1);
        }
        String filename = args[0];
        FileReader r = new FileReader(filename);
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLStreamReader sr = f.createXMLStreamReader(r);
        Stax2DomBuilder builder = new Stax2DomBuilder();
        Document domDoc = builder.build(sr);
        PrintWriter pw = new PrintWriter(System.out);
        XMLOutputFactory of = XMLOutputFactory.newInstance();
        XMLStreamWriter sw = of.createXMLStreamWriter(pw);
        Dom2StaxSerializer outputter = new Dom2StaxSerializer(sw);
        outputter.output(domDoc);
        sw.flush();
        sw.close();
    }

    private static final class NsStack {
        static final NsStack sEmptyStack;
        String[] mNsData;
        int mEnd = 0;

        private NsStack(String[] data, int end) {
            this.mNsData = data;
            this.mEnd = end;
        }

        public static NsStack defaultInstance() {
            return sEmptyStack;
        }

        public NsStack childInstance() {
            if (this == sEmptyStack) {
                String[] data = new String[16];
                System.arraycopy(this.mNsData, 0, data, 0, this.mEnd);
                return new NsStack(data, this.mEnd);
            }
            return new NsStack(this.mNsData, this.mEnd);
        }

        public boolean hasBinding(String prefix, String uri) {
            for (int i = this.mEnd - 2; i >= 0; i -= 2) {
                if (!this.mNsData[i].equals(prefix)) continue;
                return this.mNsData[i + 1].equals(uri);
            }
            return false;
        }

        public void addBinding(String prefix, String uri) {
            if (prefix == null) {
                prefix = "";
            }
            if (this.mEnd >= this.mNsData.length) {
                String[] old = this.mNsData;
                this.mNsData = new String[old.length * 2];
                System.arraycopy(old, 0, this.mNsData, 0, old.length);
            }
            this.mNsData[this.mEnd] = prefix;
            this.mNsData[this.mEnd + 1] = uri;
            this.mEnd += 2;
        }

        static {
            String[] predefd = new String[]{"xml", "http://www.w3.org/XML/1998/namespace", "xmlns", "http://www.w3.org/2000/xmlns/", "", ""};
            sEmptyStack = new NsStack(predefd, predefd.length);
        }
    }
}

