/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.localcache;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.store.localcache.LocalDirectoryCache;
import org.compass.core.lucene.engine.store.localcache.MemoryDirectoryCache;
import org.compass.core.util.FileSystemUtils;

public class LocalCacheManager {
    private static final Log log = LogFactory.getLog(LocalCacheManager.class);
    private final boolean disableLocalCache;
    private final Map<String, CompassSettings> subIndexLocalCacheGroups;
    private final LuceneSearchEngineFactory searchEngineFactory;
    private final LockFactory lockFactory = new SingleInstanceLockFactory();

    public LocalCacheManager(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
        this.disableLocalCache = searchEngineFactory.getSettings().getSettingAsBoolean("compass.engine.disableLocalCache", false);
        this.subIndexLocalCacheGroups = searchEngineFactory.getSettings().getSettingGroups("compass.engine.localCache");
        for (Map.Entry<String, CompassSettings> entry : this.subIndexLocalCacheGroups.entrySet()) {
            String connection = entry.getValue().getSetting("connection", "ram://");
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Local Cache for [" + entry.getKey() + "] configured with connection [" + connection + "]"));
        }
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Directory createLocalCache(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        String path;
        RAMDirectory localCacheDirectory;
        if (this.disableLocalCache) {
            return dir;
        }
        CompassSettings settings = this.subIndexLocalCacheGroups.get(subIndex);
        if (settings == null && (settings = this.subIndexLocalCacheGroups.get("__default__")) == null) {
            return dir;
        }
        String connection = settings.getSetting("connection", "ram://");
        if (connection.startsWith("memory://")) {
            String connectionString = connection.substring("memory://".length());
            return new MemoryDirectoryCache(connectionString, dir, this);
        }
        if (connection.startsWith("ram://")) {
            localCacheDirectory = new RAMDirectory();
            return new LocalDirectoryCache(subIndex, dir, (Directory)localCacheDirectory, this);
        }
        if (!connection.startsWith("file://") && !connection.startsWith("mmap://") && !connection.startsWith("niofs://") && connection.indexOf("://") != -1) throw new SearchEngineException("Local cache does not supprt the following connection [" + connection + "]");
        if (connection.indexOf("://") != -1) {
            if (connection.startsWith("file://")) {
                path = connection.substring("file://".length());
            } else if (connection.startsWith("mmap://")) {
                path = connection.substring("mmap://".length());
            } else {
                if (!connection.startsWith("niofs://")) throw new RuntimeException("Internal error in Compass, should not happen");
                path = connection.substring("niofs://".length());
            }
        } else {
            path = connection;
        }
        path = path + "/" + subContext + "/" + subIndex;
        File filePath = new File(path);
        FileSystemUtils.deleteRecursively(filePath);
        if (!filePath.exists()) {
            LocalCacheManager localCacheManager = this;
            synchronized (localCacheManager) {
                boolean created = filePath.mkdirs();
                if (!created) {
                    throw new SearchEngineException("Failed to create directory for local cache with path [" + path + "]");
                }
            }
        }
        try {
            localCacheDirectory = FSDirectory.getDirectory((String)path, (LockFactory)this.lockFactory);
            return new LocalDirectoryCache(subIndex, dir, (Directory)localCacheDirectory, this);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create direcotry with path [" + path + "]", e);
        }
    }

    public void close() {
    }
}

