/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.compass.core.engine.SearchEngineQueryFilter;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngineQueryFilter;
import org.compass.core.lucene.support.ChainedFilter;

public class LuceneSearchEngineBooleanQueryFilterBuilder
implements SearchEngineQueryFilterBuilder.SearchEngineBooleanQueryFilterBuilder {
    private ArrayList<Integer> types = new ArrayList();
    private ArrayList<Filter> filters = new ArrayList();

    public void and(SearchEngineQueryFilter filter) {
        this.types.add(1);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public void or(SearchEngineQueryFilter filter) {
        this.types.add(0);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public void andNot(SearchEngineQueryFilter filter) {
        this.types.add(2);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public void xor(SearchEngineQueryFilter filter) {
        this.types.add(3);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public SearchEngineQueryFilter toFilter() {
        if (this.filters.size() == 0) {
            throw new IllegalArgumentException("Must add at least one filter");
        }
        Filter[] filtersArr = this.filters.toArray(new Filter[this.filters.size()]);
        int[] typesArr = new int[this.types.size()];
        for (int i = 0; i < typesArr.length; ++i) {
            typesArr[i] = this.types.get(i);
        }
        return new LuceneSearchEngineQueryFilter(new ChainedFilter(filtersArr, typesArr));
    }
}

