/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.json.impl;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.compass.core.json.JsonArray;
import org.compass.core.json.impl.DefaultJSONException;
import org.compass.core.json.impl.DefaultJSONObject;
import org.compass.core.json.impl.DefaultJSONTokener;

public class DefaultJSONArray
implements JsonArray {
    private ArrayList myArrayList;

    public DefaultJSONArray() {
        this.myArrayList = new ArrayList();
    }

    public DefaultJSONArray(DefaultJSONTokener x) throws DefaultJSONException {
        this();
        char q;
        char c = x.nextClean();
        if (c == '[') {
            q = ']';
        } else if (c == '(') {
            q = ')';
        } else {
            throw x.syntaxError("A DefaultJSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.myArrayList.add(null);
            } else {
                x.back();
                this.myArrayList.add(x.nextValue());
            }
            c = x.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ')': 
                case ']': {
                    if (q != c) {
                        throw x.syntaxError("Expected a '" + new Character(q) + "'");
                    }
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public DefaultJSONArray(String source) throws DefaultJSONException {
        this(new DefaultJSONTokener(source));
    }

    public DefaultJSONArray(Collection collection) {
        this.myArrayList = collection == null ? new ArrayList() : new ArrayList(collection);
    }

    public DefaultJSONArray(Object array) throws DefaultJSONException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.put(Array.get(array, i));
            }
        } else {
            throw new DefaultJSONException("DefaultJSONArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int index) throws DefaultJSONException {
        Object o = this.opt(index);
        if (o == null) {
            throw new DefaultJSONException("DefaultJSONArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) throws DefaultJSONException {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new DefaultJSONException("DefaultJSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) throws DefaultJSONException {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new DefaultJSONException("DefaultJSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) throws DefaultJSONException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public DefaultJSONArray getJSONArray(int index) throws DefaultJSONException {
        Object o = this.get(index);
        if (o instanceof DefaultJSONArray) {
            return (DefaultJSONArray)o;
        }
        throw new DefaultJSONException("DefaultJSONArray[" + index + "] is not a DefaultJSONArray.");
    }

    public DefaultJSONObject getJSONObject(int index) throws DefaultJSONException {
        Object o = this.get(index);
        if (o instanceof DefaultJSONObject) {
            return (DefaultJSONObject)o;
        }
        throw new DefaultJSONException("DefaultJSONArray[" + index + "] is not a DefaultJSONObject.");
    }

    public long getLong(int index) throws DefaultJSONException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) throws DefaultJSONException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return DefaultJSONObject.NULL.equals(this.opt(index));
    }

    public String join(String separator) throws DefaultJSONException {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(DefaultJSONObject.valueToString(this.myArrayList.get(i)));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public DefaultJSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof DefaultJSONArray ? (DefaultJSONArray)o : null;
    }

    public DefaultJSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof DefaultJSONObject ? (DefaultJSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public DefaultJSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public DefaultJSONArray put(Collection value) {
        this.put(new DefaultJSONArray(value));
        return this;
    }

    public DefaultJSONArray put(double value) throws DefaultJSONException {
        Double d = new Double(value);
        DefaultJSONObject.testValidity(d);
        this.put(d);
        return this;
    }

    public DefaultJSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public DefaultJSONArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    public DefaultJSONArray put(Map value) {
        this.put(new DefaultJSONObject(value));
        return this;
    }

    public DefaultJSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public DefaultJSONArray put(int index, boolean value) throws DefaultJSONException {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public DefaultJSONArray put(int index, Collection value) throws DefaultJSONException {
        this.put(index, new DefaultJSONArray(value));
        return this;
    }

    public DefaultJSONArray put(int index, double value) throws DefaultJSONException {
        this.put(index, new Double(value));
        return this;
    }

    public DefaultJSONArray put(int index, int value) throws DefaultJSONException {
        this.put(index, new Integer(value));
        return this;
    }

    public DefaultJSONArray put(int index, long value) throws DefaultJSONException {
        this.put(index, new Long(value));
        return this;
    }

    public DefaultJSONArray put(int index, Map value) throws DefaultJSONException {
        this.put(index, new DefaultJSONObject(value));
        return this;
    }

    public DefaultJSONArray put(int index, Object value) throws DefaultJSONException {
        DefaultJSONObject.testValidity(value);
        if (index < 0) {
            throw new DefaultJSONException("DefaultJSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.myArrayList.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(DefaultJSONObject.NULL);
            }
            this.put(value);
        }
        return this;
    }

    public DefaultJSONObject toJSONObject(DefaultJSONArray names) throws DefaultJSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        DefaultJSONObject jo = new DefaultJSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws DefaultJSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws DefaultJSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(DefaultJSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(DefaultJSONObject.valueToString(this.myArrayList.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) throws DefaultJSONException {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.myArrayList.get(i)) instanceof DefaultJSONObject) {
                    ((DefaultJSONObject)v).write(writer);
                } else if (v instanceof DefaultJSONArray) {
                    ((DefaultJSONArray)v).write(writer);
                } else {
                    writer.write(DefaultJSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new DefaultJSONException(e);
        }
    }
}

