/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.xsem;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.engine.naming.PropertyPath;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.xsem.XmlPropertyMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.xml.XmlObject;

public class SimpleXmlValueConverter
implements Converter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        PropertyPath path;
        String propertyName;
        XmlPropertyMapping xmlPropertyMapping = (XmlPropertyMapping)mapping;
        if (root == null && !this.handleNulls(xmlPropertyMapping, context)) {
            return false;
        }
        XmlObject xmlObject = (XmlObject)root;
        String sValue = this.getNullValue(xmlPropertyMapping, context);
        if (root != null) {
            sValue = this.toString(xmlObject, xmlPropertyMapping);
        }
        String string = propertyName = (path = xmlPropertyMapping.getPath()) == null ? null : path.getPath();
        if (propertyName == null) {
            if (xmlObject == null) {
                return false;
            }
            propertyName = xmlObject.getName();
        }
        Property p = context.getResourceFactory().createProperty(propertyName, sValue, xmlPropertyMapping);
        this.doSetBoost(p, root, xmlPropertyMapping, context);
        resource.addProperty(p);
        return xmlPropertyMapping.getStore() != Property.Store.NO;
    }

    protected boolean handleNulls(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.hasNullValue() || context.handleNulls();
    }

    protected String getNullValue(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.getNullValue();
    }

    protected void doSetBoost(Property property, Object root, ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) throws ConversionException {
        property.setBoost(resourcePropertyMapping.getBoost());
    }

    public String toString(XmlObject xmlObject, ResourcePropertyMapping resourcePropertyMapping) {
        return xmlObject.getValue();
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        throw new ConversionException("Not supported");
    }
}

