/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassDynamicPropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public class ClassDynamicPropertyMappingConverter
implements Converter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        ClassDynamicPropertyMapping dynamicPropertyMapping = (ClassDynamicPropertyMapping)mapping;
        if (root == null) {
            return false;
        }
        if (dynamicPropertyMapping.getObjectType() == ClassDynamicPropertyMapping.ObjectType.MAP) {
            return this.marshallMap(resource, root, context, dynamicPropertyMapping);
        }
        return this.marshallSimple(resource, root, context, dynamicPropertyMapping);
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        return null;
    }

    private boolean marshallMap(Resource resource, Object root, MarshallingContext context, ClassDynamicPropertyMapping dynamicPropertyMapping) {
        Map map = (Map)root;
        if (map.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object nameObj = entry.getKey();
            if (dynamicPropertyMapping.getNameGetter() != null) {
                nameObj = dynamicPropertyMapping.getNameGetter().get(nameObj);
            }
            if (nameObj == null) continue;
            ResourcePropertyConverter nameConverter = dynamicPropertyMapping.getNameConverter();
            if (nameConverter == null) {
                nameConverter = (ResourcePropertyConverter)context.getConverterLookup().lookupConverter(nameObj.getClass());
            }
            String name = nameConverter.toString(nameObj, null);
            if (dynamicPropertyMapping.getNamePrefix() != null) {
                name = dynamicPropertyMapping.getNamePrefix() + name;
            }
            Object valueObj = entry.getValue();
            if (dynamicPropertyMapping.getMapValueType() == ClassDynamicPropertyMapping.ValueType.PLAIN) {
                if (dynamicPropertyMapping.getValueGetter() != null) {
                    valueObj = dynamicPropertyMapping.getValueGetter().get(valueObj);
                }
                if (valueObj == null && !this.handleNulls(dynamicPropertyMapping.getResourcePropertyMapping(), context)) continue;
                this.processNameAndValue(resource, context, dynamicPropertyMapping, name, valueObj);
                continue;
            }
            if (dynamicPropertyMapping.getMapValueType() == ClassDynamicPropertyMapping.ValueType.ARRAY) {
                int size = Array.getLength(valueObj);
                for (int i = 0; i < size; ++i) {
                    Object valueItem = Array.get(valueObj, i);
                    if (dynamicPropertyMapping.getValueGetter() != null) {
                        valueItem = dynamicPropertyMapping.getValueGetter().get(valueItem);
                    }
                    if (valueItem == null && !this.handleNulls(dynamicPropertyMapping.getResourcePropertyMapping(), context)) continue;
                    this.processNameAndValue(resource, context, dynamicPropertyMapping, name, valueItem);
                }
                continue;
            }
            if (dynamicPropertyMapping.getMapValueType() != ClassDynamicPropertyMapping.ValueType.COLLECTION) continue;
            Collection valueCol = (Collection)valueObj;
            for (Object valueItem : valueCol) {
                if (dynamicPropertyMapping.getValueGetter() != null) {
                    valueItem = dynamicPropertyMapping.getValueGetter().get(valueItem);
                }
                if (valueItem == null && !this.handleNulls(dynamicPropertyMapping.getResourcePropertyMapping(), context)) continue;
                this.processNameAndValue(resource, context, dynamicPropertyMapping, name, valueItem);
            }
        }
        return dynamicPropertyMapping.getResourcePropertyMapping().getStore() != Property.Store.NO;
    }

    private boolean marshallSimple(Resource resource, Object root, MarshallingContext context, ClassDynamicPropertyMapping dynamicPropertyMapping) {
        Object valueObj;
        Object nameObj = dynamicPropertyMapping.getNameGetter().get(root);
        if (nameObj == null) {
            return false;
        }
        String name = dynamicPropertyMapping.getNameConverter().toString(nameObj, null);
        if (dynamicPropertyMapping.getNamePrefix() != null) {
            name = dynamicPropertyMapping.getNamePrefix() + name;
        }
        if ((valueObj = dynamicPropertyMapping.getValueGetter().get(root)) == null && !this.handleNulls(dynamicPropertyMapping.getResourcePropertyMapping(), context)) {
            return false;
        }
        this.processNameAndValue(resource, context, dynamicPropertyMapping, name, valueObj);
        return dynamicPropertyMapping.getResourcePropertyMapping().getStore() != Property.Store.NO;
    }

    private void processNameAndValue(Resource resource, MarshallingContext context, ClassDynamicPropertyMapping dynamicPropertyMapping, String name, Object valueObj) {
        if (dynamicPropertyMapping.getValueType() == ClassDynamicPropertyMapping.ValueType.ARRAY) {
            int size = Array.getLength(valueObj);
            for (int i = 0; i < size; ++i) {
                Object valueItem = Array.get(valueObj, i);
                if (valueItem == null && !this.handleNulls(dynamicPropertyMapping.getResourcePropertyMapping(), context)) continue;
                this.addProperty(resource, dynamicPropertyMapping, context, name, valueItem);
            }
        } else if (dynamicPropertyMapping.getValueType() == ClassDynamicPropertyMapping.ValueType.COLLECTION) {
            Collection valueCol = (Collection)valueObj;
            for (Object valueItem : valueCol) {
                if (valueItem == null && !this.handleNulls(dynamicPropertyMapping.getResourcePropertyMapping(), context)) continue;
                this.addProperty(resource, dynamicPropertyMapping, context, name, valueItem);
            }
        } else {
            ResourcePropertyConverter valueConverter = dynamicPropertyMapping.getValueConverter();
            if (valueConverter == null) {
                valueConverter = (ResourcePropertyConverter)context.getConverterLookup().lookupConverter(valueObj.getClass());
            }
            String value = valueConverter.toString(valueObj, dynamicPropertyMapping.getResourcePropertyMapping());
            Property property = context.getResourceFactory().createProperty(name, value, dynamicPropertyMapping.getResourcePropertyMapping());
            resource.addProperty(property);
        }
    }

    protected void addProperty(Resource resource, ClassDynamicPropertyMapping mapping, MarshallingContext context, String name, Object valueObj) {
        String value = mapping.getValueConverter().toString(valueObj, mapping.getResourcePropertyMapping());
        Property property = context.getResourceFactory().createProperty(name, value, mapping.getResourcePropertyMapping());
        resource.addProperty(property);
    }

    protected boolean handleNulls(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.hasNullValue() || context.handleNulls();
    }

    protected String getNullValue(ResourcePropertyMapping resourcePropertyMapping, MarshallingContext context) {
        return resourcePropertyMapping.getNullValue();
    }
}

