/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.faces.converter;

import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class PhoneNumberConverter
implements Converter,
StateHolder {
    private boolean _transient;
    private String _unitedStatesFormat;

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean value) {
        this._transient = value;
    }

    public String getUnitedStatesFormat() {
        return this._unitedStatesFormat;
    }

    public void setUnitedStatesFormat(String unitedStatesFormat) {
        this._unitedStatesFormat = unitedStatesFormat;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (value != null) {
            StringBuilder integerChars = new StringBuilder(value.length());
            StringBuilder invalidChars = new StringBuilder(value.length());
            int i = 0;
            while (i < value.length()) {
                char curChar = value.charAt(i);
                if (Character.isDigit(curChar)) {
                    integerChars.append(curChar);
                } else if (curChar != '-' && curChar != '(' && curChar != ')' && curChar != '.' && curChar != '+' && curChar != ' ') {
                    invalidChars.append(curChar);
                }
                ++i;
            }
            if (invalidChars.length() > 0) {
                ExternalContext externalContext = facesContext.getExternalContext();
                Locale locale = externalContext.getRequestLocale();
                String summary = LanguageUtil.get((Locale)locale, (String)"the-following-are-invalid-characters");
                summary = String.valueOf(summary) + " " + invalidChars.toString();
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null);
                throw new ConverterException(facesMessage);
            }
            if (integerChars.length() == 10) {
                StringBuilder unitedStatesPhoneNumber = new StringBuilder(this._unitedStatesFormat.length());
                int integerDigitIndex = 0;
                int i2 = 0;
                while (i2 < this._unitedStatesFormat.length()) {
                    char curChar = this._unitedStatesFormat.charAt(i2);
                    if (curChar == '#') {
                        unitedStatesPhoneNumber.append(integerChars.charAt(integerDigitIndex++));
                    } else {
                        unitedStatesPhoneNumber.append(curChar);
                    }
                    ++i2;
                }
                return unitedStatesPhoneNumber.toString();
            }
        }
        return value;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) throws ConverterException {
        return (String)value;
    }

    public void restoreState(FacesContext facesContext, Object obj) {
        Object[] values = (Object[])obj;
        this._unitedStatesFormat = (String)values[0];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._unitedStatesFormat};
        return values;
    }
}

