/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.util.AbstractList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTypeImpl
implements DynamicType {
    protected ClassDescriptor descriptor;
    protected List<String> propertyNames = new PropertyNameList();
    protected DynamicType parentType;
    protected Set<DatabaseMapping> mappingsRequiringInitialization = new HashSet<DatabaseMapping>();

    public DynamicTypeImpl(ClassDescriptor descriptor, DynamicType parentType) {
        this.descriptor = descriptor;
        this.parentType = parentType;
    }

    @Override
    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public DynamicType getParentType() {
        return this.parentType;
    }

    public List<DatabaseMapping> getMappings() {
        return this.getDescriptor().getMappings();
    }

    @Override
    public String getName() {
        return this.getDescriptor().getAlias();
    }

    @Override
    public String getClassName() {
        return this.getDescriptor().getJavaClassName();
    }

    @Override
    public int getNumberOfProperties() {
        return this.getMappings().size();
    }

    public Set<DatabaseMapping> getMappingsRequiringInitialization() {
        return this.mappingsRequiringInitialization;
    }

    public boolean isInitialized() {
        return this.getDescriptor().isFullyInitialized();
    }

    @Override
    public boolean containsProperty(String propertyName) {
        return this.getPropertiesNames().contains(propertyName);
    }

    @Override
    public Class<?> getJavaClass() {
        return this.getDescriptor().getJavaClass();
    }

    public DatabaseMapping getMapping(String propertyName) {
        DatabaseMapping mapping = this.getDescriptor().getMappingForAttributeName(propertyName);
        if (mapping == null) {
            throw DynamicException.invalidPropertyName(this, propertyName);
        }
        return mapping;
    }

    public DatabaseMapping getMapping(int propertyIndex) {
        if (propertyIndex < 0 || propertyIndex >= this.getMappings().size()) {
            throw DynamicException.invalidPropertyIndex(this, propertyIndex);
        }
        DatabaseMapping mapping = this.getMappings().get(propertyIndex);
        return mapping;
    }

    @Override
    public List<String> getPropertiesNames() {
        return this.propertyNames;
    }

    @Override
    public int getPropertyIndex(String propertyName) {
        return this.getMappings().indexOf(this.getMapping(propertyName));
    }

    @Override
    public Class<?> getPropertyType(int propertyIndex) {
        return this.getMapping(propertyIndex).getAttributeClassification();
    }

    @Override
    public Class<?> getPropertyType(String propertyName) {
        return this.getMapping(propertyName).getAttributeClassification();
    }

    @Override
    public DynamicEntity newDynamicEntity() {
        return (DynamicEntity)this.getDescriptor().getInstantiationPolicy().buildNewInstance();
    }

    public String toString() {
        return "EntityType(" + this.getName() + ") - " + this.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyNameList
    extends AbstractList<String> {
        private PropertyNameList() {
        }

        @Override
        public String get(int index) {
            return DynamicTypeImpl.this.getMapping(index).getAttributeName();
        }

        @Override
        public int size() {
            return DynamicTypeImpl.this.getNumberOfProperties();
        }
    }
}

