/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Replace
extends MatchingTask {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File sourceFile = null;
    private NestedString token = null;
    private NestedString value = new NestedString();
    private Resource propertyResource = null;
    private Resource replaceFilterResource = null;
    private Properties properties = null;
    private ArrayList replacefilters = new ArrayList();
    private File dir = null;
    private int fileCount;
    private int replaceCount;
    private boolean summary = false;
    private String encoding = null;
    private Union resources;
    private boolean preserveLastModified = false;
    private boolean failOnNoReplacements = false;
    static /* synthetic */ Class class$org$apache$tools$ant$types$resources$FileProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Properties savedProperties;
        ArrayList savedFilters = (ArrayList)this.replacefilters.clone();
        Properties properties = savedProperties = this.properties == null ? null : (Properties)this.properties.clone();
        if (this.token != null) {
            StringBuffer val = new StringBuffer(this.value.getText());
            this.stringReplace(val, "\r\n", "\n");
            this.stringReplace(val, "\n", StringUtils.LINE_SEP);
            StringBuffer tok = new StringBuffer(this.token.getText());
            this.stringReplace(tok, "\r\n", "\n");
            this.stringReplace(tok, "\n", StringUtils.LINE_SEP);
            Replacefilter firstFilter = this.createPrimaryfilter();
            firstFilter.setToken(tok.toString());
            firstFilter.setValue(val.toString());
        }
        try {
            if (this.replaceFilterResource != null) {
                Properties props = this.getProperties(this.replaceFilterResource);
                Iterator<Object> e = props.keySet().iterator();
                while (e.hasNext()) {
                    String tok = e.next().toString();
                    Replacefilter replaceFilter = this.createReplacefilter();
                    replaceFilter.setToken(tok);
                    replaceFilter.setValue(props.getProperty(tok));
                }
            }
            this.validateAttributes();
            if (this.propertyResource != null) {
                this.properties = this.getProperties(this.propertyResource);
            }
            this.validateReplacefilters();
            this.fileCount = 0;
            this.replaceCount = 0;
            if (this.sourceFile != null) {
                this.processFile(this.sourceFile);
            }
            if (this.dir != null) {
                DirectoryScanner ds = super.getDirectoryScanner(this.dir);
                String[] srcs = ds.getIncludedFiles();
                for (int i = 0; i < srcs.length; ++i) {
                    File file = new File(this.dir, srcs[i]);
                    this.processFile(file);
                }
            }
            if (this.resources != null) {
                Iterator i = this.resources.iterator();
                while (i.hasNext()) {
                    FileProvider fp = (FileProvider)((Resource)i.next()).as(class$org$apache$tools$ant$types$resources$FileProvider == null ? Replace.class$("org.apache.tools.ant.types.resources.FileProvider") : class$org$apache$tools$ant$types$resources$FileProvider);
                    this.processFile(fp.getFile());
                }
            }
            if (this.summary) {
                this.log("Replaced " + this.replaceCount + " occurrences in " + this.fileCount + " files.", 2);
            }
            if (this.failOnNoReplacements && this.replaceCount == 0) {
                throw new BuildException("didn't replace anything");
            }
        }
        finally {
            this.replacefilters = savedFilters;
            this.properties = savedProperties;
        }
    }

    public void validateAttributes() throws BuildException {
        if (this.sourceFile == null && this.dir == null && this.resources == null) {
            String message = "Either the file or the dir attribute or nested resources must be specified";
            throw new BuildException(message, this.getLocation());
        }
        if (this.propertyResource != null && !this.propertyResource.isExists()) {
            String message = "Property file " + this.propertyResource.getName() + " does not exist.";
            throw new BuildException(message, this.getLocation());
        }
        if (this.token == null && this.replacefilters.size() == 0) {
            String message = "Either token or a nested replacefilter must be specified";
            throw new BuildException(message, this.getLocation());
        }
        if (this.token != null && "".equals(this.token.getText())) {
            String message = "The token attribute must not be an empty string.";
            throw new BuildException(message, this.getLocation());
        }
    }

    public void validateReplacefilters() throws BuildException {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter element = (Replacefilter)this.replacefilters.get(i);
            element.validate();
        }
    }

    public Properties getProperties(File propertyFile) throws BuildException {
        return this.getProperties(new FileResource(this.getProject(), propertyFile));
    }

    public Properties getProperties(Resource propertyResource) throws BuildException {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = propertyResource.getInputStream();
            props.load(in);
        }
        catch (IOException e) {
            String message = "Property resource (" + propertyResource.getName() + ") cannot be loaded.";
            throw new BuildException(message);
        }
        finally {
            FileUtils.close(in);
        }
        return props;
    }

    private void processFile(File src) throws BuildException {
        if (!src.exists()) {
            throw new BuildException("Replace: source file " + src.getPath() + " doesn't exist", this.getLocation());
        }
        File temp = null;
        FileInput in = null;
        FileOutput out = null;
        try {
            block13: {
                try {
                    boolean changes;
                    in = new FileInput(src);
                    temp = FILE_UTILS.createTempFile("rep", ".tmp", src.getParentFile(), false, true);
                    out = new FileOutput(temp);
                    int repCountStart = this.replaceCount;
                    this.logFilterChain(src.getPath());
                    out.setInputBuffer(this.buildFilterChain(in.getOutputBuffer()));
                    while (in.readChunk()) {
                        if (!this.processFilterChain()) continue;
                        out.process();
                    }
                    this.flushFilterChain();
                    out.flush();
                    in.close();
                    in = null;
                    out.close();
                    out = null;
                    boolean bl = changes = this.replaceCount != repCountStart;
                    if (!changes) break block13;
                    ++this.fileCount;
                    long origLastModified = src.lastModified();
                    FILE_UTILS.rename(temp, src);
                    if (this.preserveLastModified) {
                        FILE_UTILS.setFileLastModified(src, origLastModified);
                    }
                    temp = null;
                }
                catch (IOException ioe) {
                    throw new BuildException("IOException in " + src + " - " + ioe.getClass().getName() + ":" + ioe.getMessage(), ioe, this.getLocation());
                }
            }
            Object var10_9 = null;
            if (null != in) {
                in.closeQuietly();
            }
            if (null != out) {
                out.closeQuietly();
            }
            if (temp != null && !temp.delete()) {
                temp.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null != in) {
                in.closeQuietly();
            }
            if (null != out) {
                out.closeQuietly();
            }
            if (temp != null && !temp.delete()) {
                temp.deleteOnExit();
            }
            throw throwable;
        }
    }

    private void flushFilterChain() {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter filter = (Replacefilter)this.replacefilters.get(i);
            filter.flush();
        }
    }

    private boolean processFilterChain() {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter filter = (Replacefilter)this.replacefilters.get(i);
            if (filter.process()) continue;
            return false;
        }
        return true;
    }

    private StringBuffer buildFilterChain(StringBuffer inputBuffer) {
        StringBuffer buf = inputBuffer;
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter filter = (Replacefilter)this.replacefilters.get(i);
            filter.setInputBuffer(buf);
            buf = filter.getOutputBuffer();
        }
        return buf;
    }

    private void logFilterChain(String filename) {
        for (int i = 0; i < this.replacefilters.size(); ++i) {
            Replacefilter filter = (Replacefilter)this.replacefilters.get(i);
            this.log("Replacing in " + filename + ": " + filter.getToken() + " --> " + filter.getReplaceValue(), 3);
        }
    }

    public void setFile(File file) {
        this.sourceFile = file;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public void setReplaceFilterFile(File replaceFilterFile) {
        this.setReplaceFilterResource(new FileResource(this.getProject(), replaceFilterFile));
    }

    public void setReplaceFilterResource(Resource replaceFilter) {
        this.replaceFilterResource = replaceFilter;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setToken(String token) {
        this.createReplaceToken().addText(token);
    }

    public void setValue(String value) {
        this.createReplaceValue().addText(value);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            this.token = new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    public void setPropertyFile(File propertyFile) {
        this.setPropertyResource(new FileResource(propertyFile));
    }

    public void setPropertyResource(Resource propertyResource) {
        this.propertyResource = propertyResource;
    }

    public Replacefilter createReplacefilter() {
        Replacefilter filter = new Replacefilter();
        this.replacefilters.add(filter);
        return filter;
    }

    public void addConfigured(ResourceCollection rc) {
        if (!rc.isFilesystemOnly()) {
            throw new BuildException("only filesystem resources are supported");
        }
        if (this.resources == null) {
            this.resources = new Union();
        }
        this.resources.add(rc);
    }

    public void setPreserveLastModified(boolean b) {
        this.preserveLastModified = b;
    }

    public void setFailOnNoReplacements(boolean b) {
        this.failOnNoReplacements = b;
    }

    private Replacefilter createPrimaryfilter() {
        Replacefilter filter = new Replacefilter();
        this.replacefilters.add(0, filter);
        return filter;
    }

    private void stringReplace(StringBuffer str, String str1, String str2) {
        int found = str.indexOf(str1);
        int str1Length = str1.length();
        int str2Length = str2.length();
        while (found >= 0) {
            str.replace(found, found + str1Length, str2);
            found = str.indexOf(str1, found + str2Length);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FileOutput {
        private StringBuffer inputBuffer;
        private Writer writer;

        FileOutput(File out) throws IOException {
            this.writer = Replace.this.encoding == null ? new BufferedWriter(new FileWriter(out)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), Replace.this.encoding));
        }

        void setInputBuffer(StringBuffer input) {
            this.inputBuffer = input;
        }

        boolean process() throws IOException {
            this.writer.write(this.inputBuffer.toString());
            this.inputBuffer.delete(0, this.inputBuffer.length());
            return false;
        }

        void flush() throws IOException {
            this.process();
            this.writer.flush();
        }

        void close() throws IOException {
            this.writer.close();
        }

        void closeQuietly() {
            FileUtils.close(this.writer);
        }
    }

    private class FileInput {
        private StringBuffer outputBuffer = new StringBuffer();
        private Reader reader;
        private char[] buffer = new char[4096];
        private static final int BUFF_SIZE = 4096;

        FileInput(File source) throws IOException {
            this.reader = Replace.this.encoding == null ? new BufferedReader(new FileReader(source)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), Replace.this.encoding));
        }

        StringBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        boolean readChunk() throws IOException {
            int bufferLength = 0;
            bufferLength = this.reader.read(this.buffer);
            if (bufferLength < 0) {
                return false;
            }
            this.outputBuffer.append(new String(this.buffer, 0, bufferLength));
            return true;
        }

        void close() throws IOException {
            this.reader.close();
        }

        void closeQuietly() {
            FileUtils.close(this.reader);
        }
    }

    public class Replacefilter {
        private NestedString token;
        private NestedString value;
        private String replaceValue;
        private String property;
        private StringBuffer inputBuffer;
        private StringBuffer outputBuffer = new StringBuffer();

        public void validate() throws BuildException {
            if (this.token == null) {
                String message = "token is a mandatory for replacefilter.";
                throw new BuildException(message);
            }
            if ("".equals(this.token.getText())) {
                String message = "The token must not be an empty string.";
                throw new BuildException(message);
            }
            if (this.value != null && this.property != null) {
                String message = "Either value or property can be specified, but a replacefilter element cannot have both.";
                throw new BuildException(message);
            }
            if (this.property != null) {
                if (Replace.this.propertyResource == null) {
                    String message = "The replacefilter's property attribute can only be used with the replacetask's propertyFile/Resource attribute.";
                    throw new BuildException(message);
                }
                if (Replace.this.properties == null || Replace.this.properties.getProperty(this.property) == null) {
                    String message = "property \"" + this.property + "\" was not found in " + Replace.this.propertyResource.getName();
                    throw new BuildException(message);
                }
            }
            this.replaceValue = this.getReplaceValue();
        }

        public String getReplaceValue() {
            if (this.property != null) {
                return Replace.this.properties.getProperty(this.property);
            }
            if (this.value != null) {
                return this.value.getText();
            }
            if (Replace.this.value != null) {
                return Replace.this.value.getText();
            }
            return "";
        }

        public void setToken(String t) {
            this.createReplaceToken().addText(t);
        }

        public String getToken() {
            return this.token.getText();
        }

        public void setValue(String value) {
            this.createReplaceValue().addText(value);
        }

        public String getValue() {
            return this.value.getText();
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public NestedString createReplaceToken() {
            if (this.token == null) {
                this.token = new NestedString();
            }
            return this.token;
        }

        public NestedString createReplaceValue() {
            if (this.value == null) {
                this.value = new NestedString();
            }
            return this.value;
        }

        StringBuffer getOutputBuffer() {
            return this.outputBuffer;
        }

        void setInputBuffer(StringBuffer input) {
            this.inputBuffer = input;
        }

        boolean process() {
            String t = this.getToken();
            if (this.inputBuffer.length() > t.length()) {
                int pos = this.replace();
                pos = Math.max(this.inputBuffer.length() - t.length(), pos);
                this.outputBuffer.append(this.inputBuffer.substring(0, pos));
                this.inputBuffer.delete(0, pos);
                return true;
            }
            return false;
        }

        void flush() {
            this.replace();
            this.outputBuffer.append(this.inputBuffer);
            this.inputBuffer.delete(0, this.inputBuffer.length());
        }

        private int replace() {
            String t = this.getToken();
            int found = this.inputBuffer.indexOf(t);
            int pos = -1;
            int tokenLength = t.length();
            int replaceValueLength = this.replaceValue.length();
            while (found >= 0) {
                this.inputBuffer.replace(found, found + tokenLength, this.replaceValue);
                pos = found + replaceValueLength;
                found = this.inputBuffer.indexOf(t, pos);
                ++Replace.this.replaceCount;
            }
            return pos;
        }
    }

    public class NestedString {
        private boolean expandProperties = false;
        private StringBuffer buf = new StringBuffer();

        public void setExpandProperties(boolean b) {
            this.expandProperties = b;
        }

        public void addText(String val) {
            this.buf.append(val);
        }

        public String getText() {
            String s = this.buf.toString();
            return this.expandProperties ? Replace.this.getProject().replaceProperties(s) : s;
        }
    }
}

