/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;

public class FSDirectoryManager
implements DirectoryManager {
    private File baseDir;

    public void init(SearchIndex handler) throws IOException {
        this.baseDir = new File(handler.getPath());
    }

    public boolean hasDirectory(String name) throws IOException {
        return new File(this.baseDir, name).exists();
    }

    public Directory getDirectory(String name) throws IOException {
        File dir = name.equals(".") ? this.baseDir : new File(this.baseDir, name);
        return FSDirectory.getDirectory((File)dir, (LockFactory)new NativeFSLockFactory(dir));
    }

    public String[] getDirectoryNames() throws IOException {
        File[] dirs = this.baseDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (dirs != null) {
            String[] names = new String[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                names[i] = dirs[i].getName();
            }
            return names;
        }
        throw new IOException("listFiles for " + this.baseDir.getPath() + " returned null");
    }

    public boolean delete(String name) {
        File directory = new File(this.baseDir, name);
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                return false;
            }
        } else {
            return false;
        }
        return directory.delete();
    }

    public boolean rename(String from, String to) {
        File src = new File(this.baseDir, from);
        File dest = new File(this.baseDir, to);
        return src.renameTo(dest);
    }

    public void dispose() {
    }
}

