/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.EventDispatcher;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingObservationDispatcher
extends EventDispatcher {
    private static Logger log = LoggerFactory.getLogger((Class)DelegatingObservationDispatcher.class);
    private final HashSet dispatchers = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatcher(ObservationDispatcher dispatcher) {
        HashSet hashSet = this.dispatchers;
        synchronized (hashSet) {
            this.dispatchers.add(dispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDispatcher(ObservationDispatcher dispatcher) {
        HashSet hashSet = this.dispatchers;
        synchronized (hashSet) {
            this.dispatchers.remove(dispatcher);
        }
    }

    public EventStateCollection createEventStateCollection(SessionImpl session, Path pathPrefix) {
        return new EventStateCollection(this, session, pathPrefix);
    }

    void prepareEvents(EventStateCollection events) {
    }

    void prepareDeleted(EventStateCollection events, ChangeLog changes) {
    }

    void dispatchEvents(EventStateCollection events) {
        this.dispatch(events.getEvents(), events.getSession(), events.getPathPrefix(), events.getUserData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(List eventList, SessionImpl session, Path pathPrefix, String userData) {
        ObservationDispatcher[] disp;
        HashSet hashSet = this.dispatchers;
        synchronized (hashSet) {
            disp = this.dispatchers.toArray(new ObservationDispatcher[this.dispatchers.size()]);
        }
        for (int i = 0; i < disp.length; ++i) {
            EventStateCollection events = new EventStateCollection(disp[i], session, pathPrefix);
            events.setUserData(userData);
            try {
                events.addAll(eventList);
                events.prepare();
                events.dispatch();
                continue;
            }
            catch (Exception e) {
                log.error("Error while dispatching events.", (Throwable)e);
            }
        }
    }
}

