/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.util.Digest;

public class MergeData
implements Externalizable {
    Address sender = null;
    boolean merge_rejected = false;
    View view = null;
    Digest digest = null;

    public MergeData() {
    }

    public MergeData(Address sender, View view, Digest digest) {
        this.sender = sender;
        this.view = view;
        this.digest = digest;
    }

    public Address getSender() {
        return this.sender;
    }

    public View getView() {
        return this.view;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public void setView(View v) {
        this.view = v;
    }

    public void setDigest(Digest d) {
        this.digest = d;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sender);
        out.writeBoolean(this.merge_rejected);
        if (!this.merge_rejected) {
            out.writeObject(this.view);
            out.writeObject(this.digest);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sender = (Address)in.readObject();
        this.merge_rejected = in.readBoolean();
        if (!this.merge_rejected) {
            this.view = (View)in.readObject();
            this.digest = (Digest)in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sender=").append(this.sender);
        if (this.merge_rejected) {
            sb.append(" (merge_rejected)");
        } else {
            sb.append(", view=").append(this.view).append(", digest=").append(this.digest);
        }
        return sb.toString();
    }
}

