/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.persistence.CannotPersistException;
import org.jgroups.persistence.CannotRemoveException;
import org.jgroups.persistence.PersistenceFactory;
import org.jgroups.persistence.PersistenceManager;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

@Unsupported
public class DistributedHashtable
extends Hashtable
implements ExtendedMessageListener,
ExtendedMembershipListener {
    private static final long serialVersionUID = 7910133360803785134L;
    private transient Channel channel;
    protected transient RpcDispatcher disp = null;
    private String groupname = null;
    private final transient Vector notifs = new Vector();
    private final Vector members = new Vector();
    private transient Class[] put_signature = null;
    private transient Class[] putAll_signature = null;
    private transient Class[] clear_signature = null;
    private transient Class[] remove_signature = null;
    private transient boolean persistent = false;
    private transient PersistenceManager persistence_mgr = null;
    private transient boolean send_message = false;
    protected final transient Promise<Boolean> state_promise = new Promise();
    protected final Log log = LogFactory.getLog(this.getClass());

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        this.groupname = groupname;
        this.initSignatures();
        this.channel = factory != null ? (properties != null ? factory.createChannel((Object)properties) : factory.createChannel()) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, boolean persistent, long state_timeout) throws ChannelException {
        this.groupname = groupname;
        this.persistent = persistent;
        this.initSignatures();
        this.channel = factory != null ? (properties != null ? factory.createChannel((Object)properties) : factory.createChannel()) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedHashtable(Channel channel, long state_timeout) {
        this(channel, false, state_timeout);
    }

    public DistributedHashtable(Channel channel, boolean persistent, long state_timeout) {
        this.groupname = channel.getClusterName();
        this.channel = channel;
        this.persistent = persistent;
        this.init(state_timeout);
    }

    public DistributedHashtable(PullPushAdapter adapter, Serializable id, long state_timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.initSignatures();
        this.channel = (Channel)adapter.getTransport();
        this.groupname = this.channel.getClusterName();
        this.disp = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
        this.start(state_timeout);
    }

    public DistributedHashtable(PullPushAdapter adapter, Serializable id) {
        this.initSignatures();
        this.channel = (Channel)adapter.getTransport();
        this.groupname = this.channel.getClusterName();
        this.disp = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
    }

    protected final void init(long state_timeout) {
        this.initSignatures();
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
    }

    public final void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (this.persistent) {
            if (this.log.isInfoEnabled()) {
                this.log.info("fetching state from database");
            }
            try {
                this.persistence_mgr = PersistenceFactory.getInstance().createManager();
            }
            catch (Throwable ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                }
                this.persistent = false;
            }
        }
        this.state_promise.reset();
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            Boolean result;
            if (this.log.isInfoEnabled()) {
                this.log.info("state was retrieved successfully, waiting for setState()");
            }
            if ((result = this.state_promise.getResult(state_timeout)) == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("setState() never got called");
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info("setState() was called");
            }
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info("state could not be retrieved (first member)");
            }
            if (this.persistent) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("fetching state from database");
                }
                try {
                    Map m = this.persistence_mgr.retrieveAll();
                    if (m != null) {
                        for (Map.Entry entry : m.entrySet()) {
                            Object key = entry.getKey();
                            Object val = entry.getValue();
                            if (this.log.isInfoEnabled()) {
                                this.log.info("inserting " + key + " --> " + val);
                            }
                            this.put(key, val);
                        }
                    }
                }
                catch (Throwable ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                    }
                    this.persistent = false;
                }
            }
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean p) {
        this.persistent = p;
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.disp != null) {
            this.disp.setDeadlockDetection(flag);
        }
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void removeNotifier(Notification n) {
        if (this.notifs.contains(n)) {
            this.notifs.removeElement(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public Object put(Object key, Object value) {
        Object prev_val = this.get(key);
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_put", new Object[]{key, value}, this.put_signature, 2, 0L);
            }
            catch (Exception e) {}
        } else {
            this._put(key, value);
        }
        return prev_val;
    }

    public void putAll(Map m) {
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_putAll", new Object[]{m}, this.putAll_signature, 2, 0L);
            }
            catch (Throwable throwable) {}
        } else {
            this._putAll(m);
        }
    }

    public void clear() {
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_clear", null, this.clear_signature, 2, 0L);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("exception=" + e);
                }
            }
        } else {
            this._clear();
        }
    }

    public Object remove(Object key) {
        Object retval = this.get(key);
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_remove", new Object[]{key}, this.remove_signature, 2, 0L);
            }
            catch (Exception exception) {}
        } else {
            this._remove(key);
        }
        return retval;
    }

    public Object _put(Object key, Object value) {
        Object retval;
        block6: {
            retval = super.put(key, value);
            if (this.persistent) {
                try {
                    this.persistence_mgr.save((Serializable)key, (Serializable)value);
                }
                catch (CannotPersistException cannot_persist_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed persisting " + key + " + " + value + ", exception=" + cannot_persist_ex);
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error("failed persisting " + key + " + " + value + ", exception=" + Util.printStackTrace(t));
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entrySet(key, value);
        }
        return retval;
    }

    public void _putAll(Map m) {
        block8: {
            if (m == null) {
                return;
            }
            for (Map.Entry entry : m.entrySet()) {
                super.put(entry.getKey(), entry.getValue());
            }
            if (this.persistent) {
                try {
                    this.persistence_mgr.saveAll(m);
                }
                catch (CannotPersistException persist_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed persisting contents: " + persist_ex);
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block8;
                    this.log.error("failed persisting contents: " + t);
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(m);
        }
    }

    public void _clear() {
        block6: {
            super.clear();
            if (this.persistent) {
                try {
                    this.persistence_mgr.clear();
                }
                catch (CannotRemoveException cannot_remove_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed clearing contents, exception=" + cannot_remove_ex);
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error("failed clearing contents, exception=" + t);
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsCleared();
        }
    }

    public Object _remove(Object key) {
        Object retval;
        block6: {
            retval = super.remove(key);
            if (this.persistent) {
                try {
                    this.persistence_mgr.remove((Serializable)key);
                }
                catch (CannotRemoveException cannot_remove_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed clearing contents, exception=" + cannot_remove_ex);
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error("failed clearing contents, exception=" + t);
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryRemoved(key);
        }
        return retval;
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Hashtable copy = new Hashtable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.get(key);
            copy.put(key, val);
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception marshalling state: " + ex);
            }
            return null;
        }
    }

    public void setState(byte[] new_state) {
        Hashtable new_copy;
        try {
            new_copy = (Hashtable)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception unmarshalling state: " + ex);
            }
            return;
        }
        this._putAll(new_copy);
        this.state_promise.setResult(Boolean.TRUE);
    }

    public void viewAccepted(View new_view) {
        Vector<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    final void initSignatures() {
        block6: {
            try {
                if (this.put_signature == null) {
                    this.put_signature = new Class[]{Object.class, Object.class};
                }
                if (this.putAll_signature == null) {
                    this.putAll_signature = new Class[]{Map.class};
                }
                if (this.clear_signature == null) {
                    this.clear_signature = new Class[0];
                }
                if (this.remove_signature == null) {
                    this.remove_signature = new Class[]{Object.class};
                }
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) break block6;
                this.log.error("exception=" + ex);
            }
        }
    }

    public static void main(String[] args) {
        try {
            JChannel c = new JChannel("file:/c:/JGroups-2.0/conf/state_transfer.xml");
            DistributedHashtable ht = new DistributedHashtable(c, false, 5000L);
            c.connect("demo");
            ht.start(5000L);
            ht.put("name", "Michelle Ban");
            Object old_key = ht.remove("name");
            System.out.println("old key was " + old_key);
            ht.put("newkey", "newvalue");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("k1", "v1");
            m.put("k2", "v2");
            ht.putAll(m);
            System.out.println("hashmap is " + ht);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public byte[] getState(String state_id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getState(OutputStream ostream) {
        Hashtable copy = new Hashtable();
        ObjectOutputStream oos = null;
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.get(key);
            copy.put(key, val);
        }
        try {
            oos = new ObjectOutputStream(ostream);
            oos.writeObject(copy);
        }
        catch (Throwable ex) {
            block5: {
                try {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("exception marshalling state: " + ex);
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
            }
            Util.close(oos);
        }
        Util.close(oos);
    }

    public void getState(String state_id, OutputStream ostream) {
    }

    public void setState(String state_id, byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(InputStream istream) {
        Hashtable new_copy = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(istream);
            new_copy = (Hashtable)ois.readObject();
            ois.close();
        }
        catch (Throwable e) {
            block5: {
                try {
                    e.printStackTrace();
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("exception marshalling state: " + e);
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
            }
            Util.close(ois);
        }
        Util.close(ois);
        if (new_copy != null) {
            this._putAll(new_copy);
        }
        this.state_promise.setResult(Boolean.TRUE);
    }

    public void setState(String state_id, InputStream istream) {
    }

    public void unblock() {
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsSet(Map var1);

        public void contentsCleared();
    }
}

