package ${packagePath}.service.base;

import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import ${beanLocatorUtil};
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.InfrastructureUtil;

import javax.sql.DataSource;

<#if sessionTypeName == "">
	import com.liferay.portal.service.base.PrincipalBean;
</#if>

<#if entity.hasColumns()>
	<#if entity.hasCompoundPK()>
		import ${packagePath}.service.persistence.${entity.name}PK;
	</#if>

	import ${packagePath}.model.${entity.name};
	import ${packagePath}.model.impl.${entity.name}Impl;

	import com.liferay.portal.kernel.dao.orm.DynamicQuery;
	import com.liferay.portal.kernel.exception.PortalException;
	import com.liferay.portal.kernel.util.OrderByComparator;

	import java.util.List;
</#if>

<#list referenceList as tempEntity>
	<#if tempEntity.hasLocalService()>
		import ${tempEntity.packagePath}.service.${tempEntity.name}LocalService;
	</#if>

	<#if tempEntity.hasRemoteService()>
		import ${tempEntity.packagePath}.service.${tempEntity.name}Service;
	</#if>

	<#if tempEntity.hasColumns() && (entity.name == "Counter" || tempEntity.name != "Counter")>
		import ${tempEntity.packagePath}.service.persistence.${tempEntity.name}Persistence;
		import ${tempEntity.packagePath}.service.persistence.${tempEntity.name}Util;
	</#if>

	<#if tempEntity.hasFinderClass() && (entity.name == "Counter" || tempEntity.name != "Counter")>
		import ${tempEntity.packagePath}.service.persistence.${tempEntity.name}Finder;
		import ${tempEntity.packagePath}.service.persistence.${tempEntity.name}FinderUtil;
	</#if>
</#list>

<#if sessionTypeName == "Local">
/**
 * The base implementation of the ${entity.humanName} local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link ${packagePath}.service.impl.${entity.name}LocalServiceImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this class directly. Always use {@link ${packagePath}.service.${entity.name}LocalServiceUtil} to access the ${entity.humanName} local service.
 * </p>
 *
 * @author ${author}
 * @see ${packagePath}.service.impl.${entity.name}LocalServiceImpl
 * @see ${packagePath}.service.${entity.name}LocalServiceUtil
 * @generated
 */
	public abstract class ${entity.name}LocalServiceBaseImpl implements ${entity.name}LocalService {
<#else>
/**
 * The base implementation of the ${entity.humanName} remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link ${packagePath}.service.impl.${entity.name}ServiceImpl}.
 * </p>
 *
 * <p>
 * Never modify or reference this class directly. Always use {@link ${packagePath}.service.${entity.name}ServiceUtil} to access the ${entity.humanName} remote service.
 * </p>
 *
 * @author ${author}
 * @see ${packagePath}.service.impl.${entity.name}ServiceImpl
 * @see ${packagePath}.service.${entity.name}ServiceUtil
 * @generated
 */
	public abstract class ${entity.name}ServiceBaseImpl extends PrincipalBean implements ${entity.name}Service {
</#if>

<#if sessionTypeName == "Local" && entity.hasColumns()>
	/**
	 * Adds the ${entity.humanName} to the database. Also notifies the appropriate model listeners.
	 *
	 * @param ${entity.varName} the ${entity.humanName} to add
	 * @return the ${entity.humanName} that was added
	 * @throws SystemException if a system exception occurred
	 */
	public ${entity.name} add${entity.name}(${entity.name} ${entity.varName}) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "add" + entity.name, [packagePath + ".model." + entity.name], ["SystemException"])} {
		${entity.varName}.setNew(true);

		return ${entity.varName}Persistence.update(${entity.varName}, false);
	}

	/**
	 * Creates a new ${entity.humanName} with the primary key. Does not add the ${entity.humanName} to the database.
	 *
	 * @param ${entity.PKVarName} the primary key for the new ${entity.humanName}
	 * @return the new ${entity.humanName}
	 */
	public ${entity.name} create${entity.name}(${entity.PKClassName} ${entity.PKVarName}) {
		return ${entity.varName}Persistence.create(${entity.PKVarName});
	}

	/**
	 * Deletes the ${entity.humanName} with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param ${entity.PKVarName} the primary key of the ${entity.humanName} to delete
	 * @throws PortalException if a ${entity.humanName} with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	public void delete${entity.name}(${entity.PKClassName} ${entity.PKVarName}) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "delete" + entity.name, [entity.PKClassName], ["PortalException", "SystemException"])} {
		${entity.varName}Persistence.remove(${entity.PKVarName});
	}

	/**
	 * Deletes the ${entity.humanName} from the database. Also notifies the appropriate model listeners.
	 *
	 * @param ${entity.varName} the ${entity.humanName} to delete
	 * @throws SystemException if a system exception occurred
	 */
	public void delete${entity.name}(${entity.name} ${entity.varName}) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "delete" + entity.name, [packagePath + ".model." + entity.name], ["SystemException"])} {
		${entity.varName}Persistence.remove(${entity.varName});
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query to search with
	 * @return the matching rows
	 * @throws SystemException if a system exception occurred
	 */
	@SuppressWarnings("rawtypes")
	public List dynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
		return ${entity.varName}Persistence.findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * <#include "range_comment.ftl">
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query to search with
	 * @param start the lower bound of the range of model instances to return
	 * @param end the upper bound of the range of model instances to return (not inclusive)
	 * @return the range of matching rows
	 * @throws SystemException if a system exception occurred
	 */
	@SuppressWarnings("rawtypes")
	public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
		return ${entity.varName}Persistence.findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * <#include "range_comment.ftl">
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query to search with
	 * @param start the lower bound of the range of model instances to return
	 * @param end the upper bound of the range of model instances to return (not inclusive)
	 * @param orderByComparator the comparator to order the results by
	 * @return the ordered range of matching rows
	 * @throws SystemException if a system exception occurred
	 */
	@SuppressWarnings("rawtypes")
	public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator orderByComparator) throws SystemException {
		return ${entity.varName}Persistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Counts the number of rows that match the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query to search with
	 * @return the number of rows that match the dynamic query
	 * @throws SystemException if a system exception occurred
	 */
	public long dynamicQueryCount(DynamicQuery dynamicQuery) throws SystemException {
		return ${entity.varName}Persistence.countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * Gets the ${entity.humanName} with the primary key.
	 *
	 * @param ${entity.PKVarName} the primary key of the ${entity.humanName} to get
	 * @return the ${entity.humanName}
	 * @throws PortalException if a ${entity.humanName} with the primary key could not be found
	 * @throws SystemException if a system exception occurred
	 */
	public ${entity.name} get${entity.name}(${entity.PKClassName} ${entity.PKVarName}) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "get" + entity.name, [entity.PKClassName], ["PortalException", "SystemException"])} {
		return ${entity.varName}Persistence.findByPrimaryKey(${entity.PKVarName});
	}

	<#if entity.hasUuid() && entity.hasColumn("groupId")>
		/**
		 * Gets the ${entity.humanName} with the UUID and group id.
		 *
		 * @param uuid the UUID of ${entity.humanName} to get
		 * @param groupId the group id of the ${entity.humanName} to get
		 * @return the ${entity.humanName}
		 * @throws PortalException if a ${entity.humanName} with the UUID and group id could not be found
		 * @throws SystemException if a system exception occurred
		 */
		public ${entity.name} get${entity.name}ByUuidAndGroupId(String uuid, long groupId) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "get" + entity.name, [entity.PKClassName], ["PortalException", "SystemException"])} {
			return ${entity.varName}Persistence.findByUUID_G(uuid, groupId);
		}
	</#if>

	/**
	 * Gets a range of all the ${entity.humanNames}.
	 *
	 * <p>
	 * <#include "range_comment.ftl">
	 * </p>
	 *
	 * @param start the lower bound of the range of ${entity.humanNames} to return
	 * @param end the upper bound of the range of ${entity.humanNames} to return (not inclusive)
	 * @return the range of ${entity.humanNames}
	 * @throws SystemException if a system exception occurred
	 */
	public List<${entity.name}> get${entity.names}(int start, int end) throws SystemException {
		return ${entity.varName}Persistence.findAll(start, end);
	}

	/**
	 * Gets the number of ${entity.humanNames}.
	 *
	 * @return the number of ${entity.humanNames}
	 * @throws SystemException if a system exception occurred
	 */
	public int get${entity.names}Count() throws SystemException {
		return ${entity.varName}Persistence.countAll();
	}

	/**
	 * Updates the ${entity.humanName} in the database. Also notifies the appropriate model listeners.
	 *
	 * @param ${entity.varName} the ${entity.humanName} to update
	 * @return the ${entity.humanName} that was updated
	 * @throws SystemException if a system exception occurred
	 */
	public ${entity.name} update${entity.name}(${entity.name} ${entity.varName}) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "update" + entity.name, [packagePath + ".model." + entity.name], ["SystemException"])} {
		${entity.varName}.setNew(false);

		return ${entity.varName}Persistence.update(${entity.varName}, true);
	}

	/**
	 * Updates the ${entity.humanName} in the database. Also notifies the appropriate model listeners.
	 *
	 * @param ${entity.varName} the ${entity.humanName} to update
	 * @param merge whether to merge the ${entity.humanName} with the current session. See {@link com.liferay.portal.service.persistence.BatchSession#update(com.liferay.portal.kernel.dao.orm.Session, com.liferay.portal.model.BaseModel, boolean)} for an explanation.
	 * @return the ${entity.humanName} that was updated
	 * @throws SystemException if a system exception occurred
	 */
	public ${entity.name} update${entity.name}(${entity.name} ${entity.varName}, boolean merge) ${serviceBuilder.getServiceBaseThrowsExceptions(methods, "update" + entity.name, [packagePath + ".model." + entity.name, "boolean"], ["SystemException"])} {
		${entity.varName}.setNew(false);

		return ${entity.varName}Persistence.update(${entity.varName}, merge);
	}
</#if>

<#list referenceList as tempEntity>
	<#if tempEntity.hasLocalService()>
		/**
		 * Gets the ${tempEntity.humanName} local service.
		 *
		 * @return the ${tempEntity.humanName} local service
		 */
		public ${tempEntity.name}LocalService get${tempEntity.name}LocalService() {
			return ${tempEntity.varName}LocalService;
		}

		/**
		 * Sets the ${tempEntity.humanName} local service.
		 *
		 * @param ${tempEntity.varName}LocalService the ${tempEntity.humanName} local service
		 */
		public void set${tempEntity.name}LocalService(${tempEntity.name}LocalService ${tempEntity.varName}LocalService) {
			this.${tempEntity.varName}LocalService = ${tempEntity.varName}LocalService;
		}
	</#if>

	<#if tempEntity.hasRemoteService()>
		/**
		 * Gets the ${tempEntity.humanName} remote service.
		 *
		 * @return the ${tempEntity.humanName} remote service
		 */
		public ${tempEntity.name}Service get${tempEntity.name}Service() {
			return ${tempEntity.varName}Service;
		}

		/**
		 * Sets the ${tempEntity.humanName} remote service.
		 *
		 * @param ${tempEntity.varName}Service the ${tempEntity.humanName} remote service
		 */
		public void set${tempEntity.name}Service(${tempEntity.name}Service ${tempEntity.varName}Service) {
			this.${tempEntity.varName}Service = ${tempEntity.varName}Service;
		}
	</#if>

	<#if tempEntity.hasColumns() && (entity.name == "Counter" || tempEntity.name != "Counter")>
		/**
		 * Gets the ${tempEntity.humanName} persistence.
		 *
		 * @return the ${tempEntity.humanName} persistence
		 */
		public ${tempEntity.name}Persistence get${tempEntity.name}Persistence() {
			return ${tempEntity.varName}Persistence;
		}

		/**
		 * Sets the ${tempEntity.humanName} persistence.
		 *
		 * @param ${tempEntity.varName}Persistence the ${tempEntity.humanName} persistence
		 */
		public void set${tempEntity.name}Persistence(${tempEntity.name}Persistence ${tempEntity.varName}Persistence) {
			this.${tempEntity.varName}Persistence = ${tempEntity.varName}Persistence;
		}
	</#if>

	<#if tempEntity.hasFinderClass() && (entity.name == "Counter" || tempEntity.name != "Counter")>
		/**
		 * Gets the ${tempEntity.humanName} finder.
		 *
		 * @return the ${tempEntity.humanName} finder
		 */
		public ${tempEntity.name}Finder get${tempEntity.name}Finder() {
			return ${tempEntity.varName}Finder;
		}

		/**
		 * Sets the ${tempEntity.humanName} finder.
		 *
		 * @param ${tempEntity.varName}Finder the ${tempEntity.humanName} finder
		 */
		public void set${tempEntity.name}Finder(${tempEntity.name}Finder ${tempEntity.varName}Finder) {
			this.${tempEntity.varName}Finder = ${tempEntity.varName}Finder;
		}
	</#if>
</#list>

/**
 * Performs an SQL query.
 *
 * @param sql the sql query to perform
 */
protected void runSQL(String sql) throws SystemException {
	try {
		<#if entity.hasColumns()>
			DataSource dataSource = ${entity.varName}Persistence.getDataSource();
		<#else>
			DataSource dataSource = InfrastructureUtil.getDataSource();
		</#if>

		SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, sql, new int[0]);

		sqlUpdate.update();
	}
	catch (Exception e) {
		throw new SystemException(e);
	}
}

<#list referenceList as tempEntity>
	<#if tempEntity.hasLocalService()>
		@BeanReference(type = ${tempEntity.name}LocalService.class)
		protected ${tempEntity.name}LocalService ${tempEntity.varName}LocalService;
	</#if>

	<#if tempEntity.hasRemoteService()>
		@BeanReference(type = ${tempEntity.name}Service.class)
		protected ${tempEntity.name}Service ${tempEntity.varName}Service;
	</#if>

	<#if tempEntity.hasColumns() && (entity.name == "Counter" || tempEntity.name != "Counter")>
		@BeanReference(type = ${tempEntity.name}Persistence.class)
		protected ${tempEntity.name}Persistence ${tempEntity.varName}Persistence;
	</#if>

	<#if tempEntity.hasFinderClass() && (entity.name == "Counter" || tempEntity.name != "Counter")>
		@BeanReference(type = ${tempEntity.name}Finder.class)
		protected ${tempEntity.name}Finder ${tempEntity.varName}Finder;
	</#if>
</#list>

}