/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.lifecycle;

import java.util.ArrayList;
import javax.persistence.EntityManagerFactory;
import org.compass.gps.device.jpa.AbstractDeviceJpaEntityListener;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.impl.SessionFactoryImpl;

public class HibernateJpaEntityLifecycleInjector
implements JpaEntityLifecycleInjector {
    protected final boolean registerPostCommitListeneres;

    public HibernateJpaEntityLifecycleInjector() {
        this(false);
    }

    public HibernateJpaEntityLifecycleInjector(boolean registerPostCommitListeneres) {
        this.registerPostCommitListeneres = registerPostCommitListeneres;
    }

    public boolean requireRefresh() {
        return false;
    }

    public void injectLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)hibernateEntityManagerFactory.getSessionFactory();
        EventListeners eventListeners = sessionFactory.getEventListeners();
        Object hibernateEventListener = this.doCreateListener(device);
        if (hibernateEventListener instanceof PostInsertEventListener) {
            PostInsertEventListener[] postInsertEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitInsertEventListeners() : eventListeners.getPostInsertEventListeners();
            PostInsertEventListener[] tempPostInsertEventListeners = new PostInsertEventListener[postInsertEventListeners.length + 1];
            System.arraycopy(postInsertEventListeners, 0, tempPostInsertEventListeners, 0, postInsertEventListeners.length);
            tempPostInsertEventListeners[postInsertEventListeners.length] = (PostInsertEventListener)hibernateEventListener;
            if (this.registerPostCommitListeneres) {
                eventListeners.setPostCommitInsertEventListeners(tempPostInsertEventListeners);
            } else {
                eventListeners.setPostInsertEventListeners(tempPostInsertEventListeners);
            }
        }
        if (hibernateEventListener instanceof PostUpdateEventListener) {
            PostUpdateEventListener[] postUpdateEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitUpdateEventListeners() : eventListeners.getPostUpdateEventListeners();
            PostUpdateEventListener[] tempPostUpdateEventListeners = new PostUpdateEventListener[postUpdateEventListeners.length + 1];
            System.arraycopy(postUpdateEventListeners, 0, tempPostUpdateEventListeners, 0, postUpdateEventListeners.length);
            tempPostUpdateEventListeners[postUpdateEventListeners.length] = (PostUpdateEventListener)hibernateEventListener;
            if (this.registerPostCommitListeneres) {
                eventListeners.setPostCommitUpdateEventListeners(tempPostUpdateEventListeners);
            } else {
                eventListeners.setPostUpdateEventListeners(tempPostUpdateEventListeners);
            }
        }
        if (hibernateEventListener instanceof PostDeleteEventListener) {
            PostDeleteEventListener[] postDeleteEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitDeleteEventListeners() : eventListeners.getPostDeleteEventListeners();
            PostDeleteEventListener[] tempPostDeleteEventListeners = new PostDeleteEventListener[postDeleteEventListeners.length + 1];
            System.arraycopy(postDeleteEventListeners, 0, tempPostDeleteEventListeners, 0, postDeleteEventListeners.length);
            tempPostDeleteEventListeners[postDeleteEventListeners.length] = (PostDeleteEventListener)hibernateEventListener;
            if (this.registerPostCommitListeneres) {
                eventListeners.setPostCommitDeleteEventListeners(tempPostDeleteEventListeners);
            } else {
                eventListeners.setPostDeleteEventListeners(tempPostDeleteEventListeners);
            }
        }
    }

    public void removeLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)hibernateEntityManagerFactory.getSessionFactory();
        EventListeners eventListeners = sessionFactory.getEventListeners();
        PostInsertEventListener[] postInsertEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitInsertEventListeners() : eventListeners.getPostInsertEventListeners();
        ArrayList<PostInsertEventListener> tempPostInsertEventListeners = new ArrayList<PostInsertEventListener>();
        for (PostInsertEventListener postInsertEventListener : postInsertEventListeners) {
            if (postInsertEventListener instanceof HibernateEventListener) continue;
            tempPostInsertEventListeners.add(postInsertEventListener);
        }
        if (this.registerPostCommitListeneres) {
            eventListeners.setPostCommitInsertEventListeners(tempPostInsertEventListeners.toArray(new PostInsertEventListener[tempPostInsertEventListeners.size()]));
        } else {
            eventListeners.setPostInsertEventListeners(tempPostInsertEventListeners.toArray(new PostInsertEventListener[tempPostInsertEventListeners.size()]));
        }
        PostUpdateEventListener[] postUpdateEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitUpdateEventListeners() : eventListeners.getPostUpdateEventListeners();
        ArrayList<PostUpdateEventListener> tempPostUpdateEventListeners = new ArrayList<PostUpdateEventListener>();
        for (PostUpdateEventListener postUpdateEventListener : postUpdateEventListeners) {
            if (postUpdateEventListener instanceof HibernateEventListener) continue;
            tempPostUpdateEventListeners.add(postUpdateEventListener);
        }
        if (this.registerPostCommitListeneres) {
            eventListeners.setPostCommitUpdateEventListeners(tempPostUpdateEventListeners.toArray(new PostUpdateEventListener[tempPostUpdateEventListeners.size()]));
        } else {
            eventListeners.setPostUpdateEventListeners(tempPostUpdateEventListeners.toArray(new PostUpdateEventListener[tempPostUpdateEventListeners.size()]));
        }
        PostDeleteEventListener[] postDeleteEventListeners = this.registerPostCommitListeneres ? eventListeners.getPostCommitDeleteEventListeners() : eventListeners.getPostDeleteEventListeners();
        ArrayList<PostDeleteEventListener> tempPostDeleteEventListeners = new ArrayList<PostDeleteEventListener>();
        for (PostDeleteEventListener postDeleteEventListener : postDeleteEventListeners) {
            if (postDeleteEventListener instanceof HibernateEventListener) continue;
            tempPostDeleteEventListeners.add(postDeleteEventListener);
        }
        if (this.registerPostCommitListeneres) {
            eventListeners.setPostCommitDeleteEventListeners(tempPostDeleteEventListeners.toArray(new PostDeleteEventListener[tempPostDeleteEventListeners.size()]));
        } else {
            eventListeners.setPostDeleteEventListeners(tempPostDeleteEventListeners.toArray(new PostDeleteEventListener[tempPostDeleteEventListeners.size()]));
        }
    }

    protected Object doCreateListener(JpaGpsDevice device) {
        return new HibernateEventListener(device);
    }

    public static class HibernateEventListener
    extends AbstractDeviceJpaEntityListener
    implements PostInsertEventListener,
    PostUpdateEventListener,
    PostDeleteEventListener {
        private JpaGpsDevice device;

        public HibernateEventListener(JpaGpsDevice device) {
            this.device = device;
        }

        protected JpaGpsDevice getDevice() {
            return this.device;
        }

        public void onPostInsert(PostInsertEvent postInsertEvent) {
            this.postPersist(postInsertEvent.getEntity());
        }

        public void onPostUpdate(PostUpdateEvent postUpdateEvent) {
            this.postUpdate(postUpdateEvent.getEntity());
        }

        public void onPostDelete(PostDeleteEvent postDeleteEvent) {
            this.postRemove(postDeleteEvent.getEntity());
        }
    }
}

