/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Hits;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHighlighter;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineHighlighter;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;

public class DefaultLuceneSearchEngineHits
implements LuceneSearchEngineHits {
    private final LuceneSearchEngine searchEngine;
    private final LuceneSearchEngineQuery query;
    private LuceneSearchEngineInternalSearch internalSearch;
    private SearchEngineHighlighter highlighter;
    private final Hits hits;

    public DefaultLuceneSearchEngineHits(Hits hits, LuceneSearchEngine searchEngine, LuceneSearchEngineQuery query, LuceneSearchEngineInternalSearch internalSearch) {
        this.hits = hits;
        this.searchEngine = searchEngine;
        this.query = query;
        this.internalSearch = internalSearch;
    }

    public Resource getResource(int i) throws SearchEngineException {
        this.verifyWithinTransaction();
        try {
            Document doc = this.hits.doc(i);
            return new LuceneResource(doc, this.hits.id(i), this.searchEngine.getSearchEngineFactory());
        }
        catch (IOException ioe) {
            throw new SearchEngineException("Failed to find hit [" + i + "]", ioe);
        }
    }

    public int getLength() {
        return this.hits.length();
    }

    public float score(int i) throws SearchEngineException {
        this.verifyWithinTransaction();
        try {
            return this.hits.score(i);
        }
        catch (IOException ioe) {
            throw new SearchEngineException("Failed to fetch score for hit [" + i + "]", ioe);
        }
    }

    public Hits getHits() {
        return this.hits;
    }

    public SearchEngineHighlighter getHighlighter() throws SearchEngineException {
        this.verifyWithinTransaction();
        if (this.highlighter == null) {
            this.highlighter = new LuceneSearchEngineHighlighter(this.query.getOriginalQuery(), this.internalSearch.getReader(), this.searchEngine);
        }
        return this.highlighter.clear();
    }

    public Explanation explain(int i) throws SearchEngineException {
        this.verifyWithinTransaction();
        try {
            return this.internalSearch.getSearcher().explain(this.query.getQuery(), this.hits.id(i));
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to explain hit [" + i + "]", e);
        }
    }

    public void closeDelegate() throws SearchEngineException {
        this.close(false);
    }

    public void close() throws SearchEngineException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean removeDelegate) throws SearchEngineException {
        if (this.internalSearch != null) {
            try {
                this.internalSearch.close();
            }
            finally {
                this.internalSearch = null;
                if (removeDelegate) {
                    this.searchEngine.removeDelegatedClose(this);
                }
            }
        }
    }

    private void verifyWithinTransaction() throws SearchEngineException {
        if (!this.searchEngine.isWithinTransaction()) {
            throw new SearchEngineException("Accessing hits outside of a running transaction, either expand the transaction scope or detach the hits");
        }
    }
}

