/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.jgroups.blocks.ReplCache;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridOutputStream
extends OutputStream {
    final ReplCache<String, byte[]> cache;
    final short repl_count;
    final int chunk_size;
    final String name;
    int index = 0;
    int local_index = 0;
    final byte[] current_buffer;
    static final Log log = LogFactory.getLog(GridOutputStream.class);

    public GridOutputStream(String name, ReplCache<String, byte[]> cache, short repl_count, int chunk_size) throws FileNotFoundException {
        this(name, false, cache, repl_count, chunk_size);
    }

    public GridOutputStream(File file, ReplCache<String, byte[]> cache, short repl_count, int chunk_size) throws FileNotFoundException {
        this(file.getName(), false, cache, repl_count, chunk_size);
    }

    public GridOutputStream(String name, boolean append, ReplCache<String, byte[]> cache, short repl_count, int chunk_size) throws FileNotFoundException {
        this.name = name;
        this.cache = cache;
        this.repl_count = repl_count;
        this.chunk_size = chunk_size;
        this.current_buffer = new byte[chunk_size];
    }

    public GridOutputStream(File file, boolean append, ReplCache<String, byte[]> cache, short repl_count, int chunk_size) throws FileNotFoundException {
        this(file.getName(), append, cache, repl_count, chunk_size);
    }

    @Override
    public void write(int b) throws IOException {
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.flush();
            this.local_index = 0;
            remaining = this.chunk_size;
        }
        this.current_buffer[this.local_index] = (byte)b;
        ++this.local_index;
        ++this.index;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int remaining = this.getBytesRemainingInChunk();
            if (remaining == 0) {
                this.flush();
                this.local_index = 0;
                remaining = this.chunk_size;
            }
            int bytes_to_write = Math.min(remaining, len);
            System.arraycopy(b, off, this.current_buffer, this.local_index, bytes_to_write);
            off += bytes_to_write;
            len -= bytes_to_write;
            this.local_index += bytes_to_write;
            this.index += bytes_to_write;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.reset();
    }

    @Override
    public void flush() throws IOException {
        int chunk_number = this.getChunkNumber();
        String key = this.name + "#" + chunk_number;
        byte[] val = new byte[this.local_index];
        System.arraycopy(this.current_buffer, 0, val, 0, this.local_index);
        this.cache.put(key, val, this.repl_count, 0L);
        if (log.isTraceEnabled()) {
            log.trace("put(): index=" + this.index + ", key=" + key + ": " + val.length + " bytes");
        }
    }

    private int getBytesRemainingInChunk() {
        return this.chunk_size - this.local_index;
    }

    private int getChunkNumber() {
        return (this.index - 1) / this.chunk_size;
    }

    private void reset() {
        this.local_index = 0;
        this.index = 0;
    }
}

