/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.util.List;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.serializer.AbstractSerializationContext;
import org.apache.abdera.ext.serializer.Serializer;
import org.apache.abdera.ext.serializer.SerializerProvider;
import org.apache.abdera.util.ServiceUtil;
import org.apache.abdera.writer.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializationContext
extends AbstractSerializationContext {
    private static final long serialVersionUID = 740460842415905883L;
    private final List<SerializerProvider> providers;

    public DefaultSerializationContext(StreamWriter streamWriter) {
        super(streamWriter);
        this.initSerializers();
        this.providers = DefaultSerializationContext.loadConverterProviders();
    }

    public DefaultSerializationContext(Abdera abdera, StreamWriter streamWriter) {
        super(abdera, streamWriter);
        this.initSerializers();
        this.providers = DefaultSerializationContext.loadConverterProviders();
    }

    private void initSerializers() {
        SerializerProvider[] providers;
        for (SerializerProvider provider : providers = this.getConverterProviders()) {
            for (Map.Entry<Class, Serializer> entry : provider) {
                this.setSerializer(entry.getKey(), entry.getValue());
            }
        }
    }

    public SerializerProvider[] getConverterProviders() {
        return this.providers != null ? this.providers.toArray(new SerializerProvider[this.providers.size()]) : new SerializerProvider[]{};
    }

    protected static synchronized List<SerializerProvider> loadConverterProviders() {
        List<SerializerProvider> providers = ServiceUtil.loadimpls("META-INF/services/org.apache.abdera.converter.ConverterProvider");
        return providers;
    }
}

