/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.console;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import sun.misc.BASE64Decoder;
import uk.org.primrose.GeneralException;
import uk.org.primrose.Logger;
import uk.org.primrose.Util;
import uk.org.primrose.console.HttpRequest;
import uk.org.primrose.pool.PoolException;
import uk.org.primrose.pool.core.ConnectionHolder;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.PoolConfigImpl;
import uk.org.primrose.pool.core.PoolData;
import uk.org.primrose.pool.core.PoolLoader;

public class WebConsole {
    private static int port = -1;
    private static boolean alreadyStarted = false;
    private static boolean bKeepRunning = true;
    private static String username = null;
    private static String password = null;
    private Logger logger = null;
    List<Pool> loadedPools = null;

    public WebConsole(String username, String password, int port, Logger logger) {
        WebConsole.port = port;
        this.logger = logger;
        WebConsole.username = username;
        WebConsole.password = password;
    }

    public WebConsole(int port, Logger logger) {
        WebConsole.port = port;
        this.logger = logger;
    }

    public static void main(String[] args) throws IOException {
        new WebConsole(8080, null).start();
    }

    public void start() throws IOException {
        if (port > 0 && !alreadyStarted) {
            if (this.logger == null) {
                this.logger = new Logger();
            }
            this.logger.info("Starting WebConsole on port " + port);
            new WebConsoleStarter().start();
            Runtime.getRuntime().addShutdownHook(new WebConsoleStopper());
        }
    }

    public static void shutdown() {
        try {
            bKeepRunning = false;
            alreadyStarted = false;
            Socket s = new Socket("localhost", port);
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUsername(String username) {
        WebConsole.username = username;
    }

    public void setPassword(String password) {
        WebConsole.password = password;
    }

    public String getPassword() {
        return password;
    }

    public String getUsername() {
        return username;
    }

    class SocketHandler
    extends Thread {
        Socket s = null;
        HttpRequest httpRequest = new HttpRequest(WebConsole.access$200(WebConsole.this));
        OutputStream out = null;

        SocketHandler(Socket s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                this.out = this.s.getOutputStream();
                int iCountBlankLines = 0;
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) {
                        ++iCountBlankLines;
                    }
                    baos.write((line + "\n").getBytes());
                    if (iCountBlankLines != 1) continue;
                }
                baos.flush();
                byte[] requestData = baos.toByteArray();
                baos.close();
                if (this.httpRequest.parseRequest(new String(requestData))) {
                    this.handleRequest();
                }
                br.close();
                this.out.close();
            }
            catch (IOException ioe) {
                WebConsole.this.logger.printStackTrace(ioe);
            }
            finally {
                try {
                    this.s.close();
                }
                catch (IOException ioe) {
                    WebConsole.this.logger.printStackTrace(ioe);
                }
            }
        }

        private boolean userAuthorised() {
            if (username == null || password == null) {
                return true;
            }
            HashMap<String, String> headers = this.httpRequest.getHeaders();
            String value = headers.get("authorization");
            if (value == null) {
                value = headers.get("Authorization");
            }
            if (value != null) {
                String b64pass = value.split(" ")[1];
                BASE64Decoder decoder = new BASE64Decoder();
                String userpass = null;
                try {
                    userpass = new String(decoder.decodeBuffer(b64pass));
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (userpass != null && userpass.indexOf(":") != -1) {
                    String[] s = userpass.split(":");
                    if (password.equals(s[1]) && username.equals(s[0])) {
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleRequest() throws IOException {
            if (!this.userAuthorised()) {
                this.writeHeaders("text/html", "", 401, 0);
                return;
            }
            String resource = this.httpRequest.getResource();
            WebConsole.this.logger.verbose("Processing resource : '" + resource + "'");
            WebConsole.this.loadedPools = PoolLoader.getLoadedPools();
            if (resource == null || resource.length() == 0 || resource.equals("/") || resource.equals("/index.html")) {
                this.writeHeaders("text/html", "", 200, 0);
                this.writeTop();
                this.writeData("<br/><h4>Welcome to the Primrose Web Console</h4>");
                for (Pool pool : WebConsole.this.loadedPools) {
                    this.writeData("<p>");
                    this.writeData("<a href=\"/showPool?poolName=" + pool.getPoolName() + "\">Show '" + pool.getPoolName() + "' Pool</a>");
                    this.writeData("</p>");
                }
                this.writeBottom();
            } else if (resource.startsWith("/showPoolConfig")) {
                this.writeHeaders("text/html", "", 200, 0);
                this.writeTop();
                String poolName = this.httpRequest.getParameters().get("poolName");
                Pool pool = this.findPoolByName(poolName);
                if (pool != null) {
                    this.writeData("<p>");
                    this.writeData("<a href=\"/showPool?poolName=" + pool.getPoolName() + "\">Show '" + pool.getPoolName() + "' Connections</a>");
                    this.writeData("</p>");
                    this.writeData("<br/><form method=\"get\" action=\"alterPoolProperties\"><table>");
                    Method[] publicMethods = PoolConfigImpl.class.getMethods();
                    for (int j = 0; j < publicMethods.length; ++j) {
                        String methodName = publicMethods[j].getName();
                        if (methodName.startsWith("getClass") || !methodName.startsWith("get")) continue;
                        try {
                            Object ret = publicMethods[j].invoke((Object)pool, new Object[0]);
                            if (ret == null) {
                                ret = "";
                            }
                            this.writeData("<tr><td>" + methodName.replaceAll("get", "") + "</td><td><input type=\"text\" name=\"" + methodName.replaceAll("get", "") + "\" size=\"60\" value=\"" + ret + "\"/></td></tr>");
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.writeData("<tr><td colspan=\"2\"><input type=\"hidden\" value=\"" + poolName + "\"/></td></tr>");
                    this.writeData("<tr><td colspan=\"2\"><input type=\"submit\" value=\"Update Pool Now\"/></td></tr>");
                    this.writeData("</table></form>");
                    this.writeData("<p>If you update the pool settings, the existing pool will be restarted in order for the settings to take effect. Any running connections/SQL will NOT be affected - their jobs will finish normally, and then those connections will be retired.</p>");
                } else {
                    this.writeData("<p>Sorry, cannot find pool under name '" + poolName + "'</p>");
                }
                this.writeBottom();
            } else if (resource.equals("/webconsole.css")) {
                this.writeCSS();
            } else if (resource.startsWith("/poolStop")) {
                String poolName = this.httpRequest.getParameters().get("poolName");
                Pool pool = this.findPoolByName(poolName);
                try {
                    pool.stop(false);
                }
                catch (PoolException pe) {
                    WebConsole.this.logger.printStackTrace(pe);
                }
                this.writeHeaders("text/html", "/showPool?poolName=" + pool.getPoolName(), 302, 0);
            } else if (resource.startsWith("/poolStart")) {
                String poolName = this.httpRequest.getParameters().get("poolName");
                Pool pool = this.findPoolByName(poolName);
                try {
                    pool.start();
                }
                catch (PoolException pe) {
                    WebConsole.this.logger.printStackTrace(pe);
                }
                this.writeHeaders("text/html", "/showPool?poolName=" + pool.getPoolName(), 302, 0);
            } else if (resource.startsWith("/poolRestart")) {
                String poolName = this.httpRequest.getParameters().get("poolName");
                Pool pool = this.findPoolByName(poolName);
                try {
                    pool.restart(false);
                }
                catch (PoolException pe) {
                    WebConsole.this.logger.printStackTrace(pe);
                }
                this.writeHeaders("text/html", "/showPool?poolName=" + pool.getPoolName(), 302, 0);
            } else if (resource.startsWith("/showPool")) {
                String poolName = this.httpRequest.getParameters().get("poolName");
                String refreshRate = this.httpRequest.getParameters().get("refresh");
                Pool pool = this.findPoolByName(poolName);
                this.writeHeaders("text/html", "", 200, 0);
                this.writeTop(refreshRate);
                this.writeData("<table><tr><td><table><tr><td>Server date : " + new Date() + "</td></tr>");
                this.writeData("<tr><td>Primrose Version : 3.0.14</td></tr>");
                if (pool != null) {
                    int numberOfWaitingThreads = pool.getNumberOfWaitingThreads();
                    if (numberOfWaitingThreads > 0) {
                        this.writeData("<tr><td><span style='color:red'>Warning ! There are " + numberOfWaitingThreads + " threads waiting for a connection.</span> You may want to increase your base pool size.</td></tr>");
                    }
                    this.writeData("<tr><td>Total number of connections handed out : " + pool.getTotalConnectionsHandedOut() + "</td></tr>");
                    this.writeData("<tr><td><a href=\"/showPoolConfig?poolName=" + poolName + "\">Edit runtime config properties</a></td></tr></table></td><td>&nbsp;</td>");
                    this.writeData("<td><table><tr><td><a href=\"/poolStop?poolName=" + poolName + "\">Stop Pool</a></td></tr>");
                    this.writeData("<tr><td><a href=\"/poolStart?poolName=" + poolName + "\">Start Pool</a></td></tr>");
                    this.writeData("<tr><td><a href=\"/poolRestart?poolName=" + poolName + "\">Restart Pool</a></td></tr></table></td></tr></table>");
                    this.writeData("<p/><h5>Connection Data</h5>");
                    Vector<ConnectionHolder> connections = pool.getPoolConnections();
                    this.writeData("<table border=\"1\">");
                    this.writeData("<tr><td><h5>ID</h5></td><td><h5>Status</h5></td><td><h5>Opens</h5></td><td><h5>Closes</h5></td><td><h5>CallableStatement</h5></td><td><h5>PreparedStatement</h5></td><td><h5>Statement</h5></td><td><h5>Active For</h5></td><td><h5>Idle For</h5></td><td><h5>SQL</h5></td></tr>");
                    for (ConnectionHolder ch : connections) {
                        String status = PoolData.getStringStatus(-1);
                        String inusefor = "n/a";
                        String idlefor = "n/a";
                        if (ch.status == 1) {
                            status = "<span style='color:red'>" + PoolData.getStringStatus(ch.status) + "</span>";
                            inusefor = (System.currentTimeMillis() - ch.connOpenedDate) / 1000L + " secs";
                        } else if (ch.status == 2) {
                            status = "<span style='color:green'>" + PoolData.getStringStatus(ch.status) + "</span>";
                            if (ch.lastUsedTimestamp > 0L) {
                                idlefor = (System.currentTimeMillis() - ch.lastUsedTimestamp) / 1000L + " secs";
                            }
                        }
                        this.writeData("<tr><td>" + ch.conn.hashCode() + "</td><td>" + status + "</td>" + "<td>" + ch.numberOfOpens + "</td>" + "<td>" + ch.numberOfCloses + "</td>" + "<td>" + ch.numberOfJDBCCallableStatementsRun + "</td>" + "<td>" + ch.numberOfJDBCPreparedStatementsRun + "</td>" + "<td>" + ch.numberOfJDBCStatementsRun + "</td>" + "<td>" + inusefor + "</td>" + "<td>" + idlefor + "</td>" + "<td>" + ch.sql + "</td></tr>");
                    }
                    this.writeData("</table>");
                    this.writeData("<br/><p>ID - The PoolConnection class hashCode()<br/>Status - The Status of the connection<br/>Opens - How many times this connection has been extracted from the pool<br/>Closes - How many times this connection has been returned to the pool<br/>CallableStatement - How many JDBC CallableStatement objects have been created from this connection<br/>PreparedStatement - How many JDBC PreparedStatement objects have been created from this connection<br/>Statement - How many JDBC Statement objects have been created from this connection<br/>Active For - How many seconds this connection has been in use for(if active)<br/>Idle For - How many seconds this connection has been idle for (if inactive)<br/>SQL - The current executing SQL on this connection (if any)</p>");
                } else {
                    this.writeData("<p>Sorry, cannot find pool under name '" + poolName + "'</p>");
                }
                this.writeData("<p><form method=\"get\"><input type=\"text\" name=\"refresh\"/><input type=\"hidden\" name=\"poolName\" value=\"" + poolName + "\"/>&nbsp;<input type=\"submit\" value=\"Set Page Refresh Rate (seconds)\"/></form>");
                this.writeBottom();
            } else if (resource.startsWith("/alterPoolProperties")) {
                Pool pool = this.findPoolByName(this.httpRequest.parameters.get("PoolName"));
                for (String key : this.httpRequest.parameters.keySet()) {
                    String value = this.httpRequest.parameters.get(key);
                    if (key.equals("PoolName")) continue;
                    try {
                        WebConsole.this.logger.info("[WebConsole] alterPoolProperties() Setting " + key + "=" + value);
                        Util.callClassMethod(Pool.class, pool, "set" + key, new Object[]{value});
                    }
                    catch (GeneralException ge) {
                        this.showErrorPage("Error setting property " + key + " : " + ge);
                        return;
                    }
                }
                try {
                    pool.restart(false);
                }
                catch (PoolException pe) {
                    this.showErrorPage("Error restarting pool : " + pe);
                }
                this.writeHeaders("text/html", "/showPool?poolName=" + pool.getPoolName(), 302, 0);
            }
        }

        private void showErrorPage(String error) throws IOException {
            this.writeHeaders("text/html", "", 200, 0);
            this.writeTop();
            this.writeData(error);
            this.writeBottom();
        }

        private Pool findPoolByName(String poolName) {
            for (Pool pool : WebConsole.this.loadedPools) {
                if (!pool.getPoolName().equals(poolName)) continue;
                return pool;
            }
            return null;
        }

        private void writeHeaders(String contentType, String szExtraData, int iHttpStatusCode, int iContentLength) throws IOException {
            if (iHttpStatusCode == 500) {
                this.writeData("HTTP/1.1 500 " + szExtraData + ";");
            } else if (iHttpStatusCode == 401) {
                this.writeData("HTTP/1.1 401 Authenitcation Required;");
                this.writeData("WWW-Authenticate: Basic realm=\"Primrose Web Console\"");
            } else if (iHttpStatusCode == 302) {
                this.writeData("HTTP/1.1 302 Found;");
                this.writeData("Location: " + szExtraData + "");
            } else {
                this.writeData("HTTP/1.1 200 OK;");
            }
            this.writeData("Date: " + new Date() + "");
            this.writeData("Server: Primrose Web Console");
            this.writeData("LastModified: " + new Date() + "");
            this.writeData("Content-Type: " + contentType + "");
            if (iContentLength > 0) {
                this.writeData("Content-Length: " + iContentLength + "");
            }
            this.writeData("Connection:close");
            this.writeData("");
        }

        private void writeData(String data) throws IOException {
            data = data + "\n";
            this.out.write(data.getBytes());
            this.out.flush();
        }

        private void writeTop() throws IOException {
            this.writeTop(null);
        }

        private void writeTop(String refreshRate) throws IOException {
            this.writeData("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN'");
            this.writeData("  'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>");
            this.writeData("<!--<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
            this.writeData("\t\"http://www.w3.org/TR/html4/strict.dtd\">-->");
            this.writeData("<html lang=\"en\">");
            this.writeData("\t<head>");
            if (refreshRate != null) {
                this.writeData("<meta http-equiv=\"refresh\" content=\"" + refreshRate + "\"/>");
            }
            this.writeData("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"/>");
            this.writeData("\t\t<style type=\"text/css\"><!-- ");
            this.writeData("\t\t\t@import \"/webconsole.css\"; ");
            this.writeData("\t\t--></style>");
            this.writeData("\t\t<title>Primrose Web Console</title>");
            this.writeData("\t</head>");
            this.writeData("\t<body>");
            this.writeData("\t\t<div id=\"pageWrapper\">");
            this.writeData("\t\t\t");
            this.writeData("\t\t\t<!-- masthead content begin -->");
            this.writeData("\t\t\t");
            this.writeData("<!--banner -->");
            this.writeData("<div id=\"bannerOuterWrapper\">");
            this.writeData("  <div id=\"bannerWrapper\">");
            this.writeData("  ");
            this.writeData("    ");
            this.writeData("    <h1><a href=\"http://www.primrose.org.uk\"><img style=\"border:0\" src=\"http://www.primrose.org.uk/images/primrose_logo.jpg\" alt=\"Primrose Logo\" /></a></h1>");
            this.writeData("  </div>");
            this.writeData("</div>  ");
            this.writeData("\t\t\t<!-- masthead content end -->");
            this.writeData("\t\t\t");
            this.writeData("\t\t\t<!-- horizontal nav begin -->");
            this.writeData("\t\t\t<div class=\"hnav\">");
            this.writeData("\t<hr class=\"hide\"/>");
            this.writeData("</div>");
            this.writeData("\t\t\t<!-- horizontal nav end -->");
            this.writeData("<!--- middle (main content) column begin -->");
            this.writeData("\t\t\t<div id=\"outerColumnContainer\">");
            this.writeData("\t\t\t\t<div id=\"innerColumnContainer\">");
            this.writeData("\t\t\t\t\t<div id=\"SOWrap\">");
            this.writeData("\t\t\t\t\t\t<div id=\"middleColumn\">");
            this.writeData("\t\t\t\t\t\t\t<div class=\"inside\">");
        }

        private void writeBottom() throws IOException {
            this.writeData("\t\t<hr class=\"hide\"/>");
            this.writeData("\t</div>");
            this.writeData("</div>");
            this.writeData("<!--- middle (main content) column end -->");
            this.writeData("<!--- left column begin -->");
            this.writeData("\t\t\t\t\t\t<div id=\"leftColumn\">");
            this.writeData("\t\t\t\t\t\t\t<div class=\"inside\">");
            this.writeData("<div class=\"vnav\"><p>&nbsp;</p></div>");
            this.writeData("<div class=\"vnav\">");
            this.writeData("\t<h3>&nbsp;</h3>");
            this.writeData("\t<h3>Site Navigation</h3>");
            this.writeData("\t<p></p>");
            this.writeData("\t<ul");
            this.writeData("\t\t><li");
            this.writeData("\t\t\t><a href=\"/\">Home</a");
            this.writeData("\t\t></li");
            for (Pool pool : WebConsole.this.loadedPools) {
                this.writeData("\t\t><li");
                this.writeData("\t\t\t><a href=\"/showPool?poolName=" + pool.getPoolName() + "\">Show '" + pool.getPoolName() + "' Pool</a");
                this.writeData("\t\t></li");
            }
            this.writeData("\t\t");
            this.writeData("\t></ul>");
            this.writeData("</div>");
            this.writeData("\t\t\t\t\t\t<hr class=\"hide\"/>");
            this.writeData("\t\t\t\t\t\t\t</div>");
            this.writeData("\t\t\t\t\t\t</div>");
            this.writeData("\t\t\t\t\t\t<div class=\"clear\"></div>");
            this.writeData("\t\t\t\t\t</div>");
            this.writeData("<!--- left column end -->");
            this.writeData("<!--- right column begin -->");
            this.writeData("\t\t\t\t\t<div id=\"rightColumn\">");
            this.writeData("\t\t\t\t\t\t<div class=\"inside\">");
            this.writeData("<p>&nbsp;</p>");
            this.writeData("\t\t\t\t\t\t\t<hr class=\"hide\"/>");
            this.writeData("\t\t\t\t\t\t</div>");
            this.writeData("\t\t\t\t\t</div>");
            this.writeData("\t\t\t\t\t<div class=\"clear\"></div>");
            this.writeData("\t\t\t\t</div>");
            this.writeData("\t\t\t</div>");
            this.writeData("<!--- right column end -->");
            this.writeData("<!-- footer begin -->");
            this.writeData("\t\t\t<!-- horizontal nav begin -->");
            this.writeData("\t\t\t<div class=\"hnav\">");
            this.writeData("\t<hr class=\"hide\"/>");
            this.writeData("</div>");
            this.writeData("\t\t\t<!-- horizontal nav end -->");
            this.writeData("<div id=\"bannerWrapperRepeat\">");
            this.writeData("  ");
            this.writeData("    ");
            this.writeData("    <div id=\"footer\">");
            this.writeData("\t<p style=\"margin:0;\">");
            this.writeData("\t\t&copy; www.primrose.org.uk<br/>");
            this.writeData("    \t");
            this.writeData("\t\t <a href=\"http://www.primrose.org.uk\"><img style=\"border:0;\"");
            this.writeData("\t\t\tsrc=\"http://www.primrose.org.uk/images/primrose_powered_by_centre_small.jpg\"");
            this.writeData("\t\t\talt=\"Powered By Primrose\"/></a>\t        \t");
            this.writeData("\t</p>\t");
            this.writeData("    </div>");
            this.writeData("</div>  ");
            this.writeData("<!-- footer end -->");
            this.writeData("\t\t</div>");
            this.writeData("\t</body>");
            this.writeData("</html>");
        }

        private void writeCSS() throws IOException {
            this.writeData("@charset \"iso-8859-1\";");
            this.writeData("/* begin with generic selectors so that they can be overridden if needed");
            this.writeData(" * by classes deeper in the stylesheet");
            this.writeData(" */");
            this.writeData(".clear");
            this.writeData("{");
            this.writeData("\tclear: both;");
            this.writeData("\tpadding-bottom: 1px;\t/* for Gecko-based browsers */");
            this.writeData("\tmargin-bottom: -1px;\t/* for Gecko-based browsers */");
            this.writeData("}");
            this.writeData(".hide");
            this.writeData("{");
            this.writeData("\tdisplay: none !important;");
            this.writeData("}");
            this.writeData(".inside");
            this.writeData("{");
            this.writeData("\t/* glitch in IE caused by vertical padding in this class, so 0 padding is");
            this.writeData("\t * set here and those blocks that need the vertical padding must be ");
            this.writeData("\t * applied to the parent element. the purpose of this class is to provide");
            this.writeData("\t * horizontal padding without using hacks to get around IE's broken box ");
            this.writeData("\t * model. so it's okay to apply vertical padding to the parent element, ");
            this.writeData("\t * just not horizontal padding.");
            this.writeData("\t */");
            this.writeData("\tpadding: 0 1em;");
            this.writeData("}");
            this.writeData("/* margin values and font sizes for headings, and margins on paragraphs");
            this.writeData(" * and lists are not consistent across browser platforms. to achieve a");
            this.writeData(" * consistent look we need to explicity set these values here. it may");
            this.writeData(" * seem an odd way to declare the margins like this but you never");
            this.writeData(" * know what kind of horizontal padding a browser may be using on an");
            this.writeData(" * element, and I only want to change the vertical padding.");
            this.writeData(" *");
            this.writeData(" * pixels are used here, rather than ems, because I want a consistent");
            this.writeData(" * margin on the different headings. if I use ems, 1em for an h1 element");
            this.writeData(" * is much larger than 1em on an h6 element. I don't wnat this.");
            this.writeData(" *");
            this.writeData(" * salt to taste");
            this.writeData(" */");
            this.writeData("ul, ol, dl, p, h1, h2, h3, h4, h5, h6");
            this.writeData("{");
            this.writeData("\tmargin-top: 14px;");
            this.writeData("\tmargin-bottom: 14px;");
            this.writeData("\tpadding-top: 0;");
            this.writeData("\tpadding-bottom: 0;");
            this.writeData("}");
            this.writeData("h1");
            this.writeData("{");
            this.writeData("\tfont-size: 220%;");
            this.writeData("}");
            this.writeData("h2");
            this.writeData("{");
            this.writeData("\tfont-size: 160%;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("}");
            this.writeData("h3");
            this.writeData("{");
            this.writeData("\tfont-size: 160%;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("}");
            this.writeData("h4");
            this.writeData("{");
            this.writeData("\tfont-size: 130%;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("}");
            this.writeData("h5");
            this.writeData("{");
            this.writeData("\tmargin-top: 0px;");
            this.writeData("\tmargin-bottom: 0px;");
            this.writeData("\tfont-size: 100%;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("}");
            this.writeData("h6");
            this.writeData("{");
            this.writeData("\tfont-size: 70%;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("}");
            this.writeData("/* alter some HTML elements' default style");
            this.writeData(" */");
            this.writeData("a, a:link, a:visited, a:active");
            this.writeData("{");
            this.writeData("\ttext-decoration: underline;");
            this.writeData("\tcolor: #3388CC;");
            this.writeData("}");
            this.writeData("a:hover");
            this.writeData("{");
            this.writeData("\ttext-decoration: none;");
            this.writeData("}");
            this.writeData("code");
            this.writeData("{");
            this.writeData("\tfont-family: \"Courier New\", Courier, monospace;");
            this.writeData("}");
            this.writeData("label");
            this.writeData("{");
            this.writeData("\tcursor: pointer;");
            this.writeData("}");
            this.writeData("table");
            this.writeData("{");
            this.writeData("\tfont-size: 100%;");
            this.writeData("}");
            this.writeData("td, th");
            this.writeData("{");
            this.writeData("\tvertical-align: top;");
            this.writeData("}");
            this.writeData("#pageWrapper");
            this.writeData("{");
            this.writeData("\tborder: solid 1px #fff;");
            this.writeData("\tborder-width: 0 0px;");
            this.writeData("\tmin-width: 0em;\t/* IE doens't understand this property. EMs are used");
            this.writeData("\t\t\t\t   so that as the font size increases, the proportional");
            this.writeData("\t\t\t\t   limitations (min-width) increase with it, rather");
            this.writeData("\t\t\t\t   than creating a middle column that can only fit");
            this.writeData("\t\t\t\t   3 or 4 characters in it. */");
            this.writeData("\twidth: auto;");
            this.writeData("}");
            this.writeData("* html #pageWrapper");
            this.writeData("{");
            this.writeData("\t\tword-wrap: break-word;");
            this.writeData("}");
            this.writeData("#masthead");
            this.writeData("{");
            this.writeData("\tborder: solid 1px #fff;");
            this.writeData("\tborder-width: 1px 0;");
            this.writeData("\tpadding: 0.5em;");
            this.writeData("}");
            this.writeData("#masthead h1");
            this.writeData("{");
            this.writeData("\tpadding: 0;");
            this.writeData("\tmargin: 0;");
            this.writeData("}");
            this.writeData("#outerColumnContainer");
            this.writeData("{");
            this.writeData("\t/* reserves space for the left and right columns. you can use either");
            this.writeData("\t * padding, margins, or borders, depending on your needs. however you");
            this.writeData("\t * can use the border method to create a background color for both left");
            this.writeData("\t * and right columns");
            this.writeData("\t */");
            this.writeData("\tborder-left: solid 15em #fff;");
            this.writeData("\tborder-right: solid 0em #fff;");
            this.writeData("}");
            this.writeData("#innerColumnContainer");
            this.writeData("{");
            this.writeData("\tborder: solid 1px #fff;");
            this.writeData("\tborder-width: 0 0px;");
            this.writeData("\tmargin: 0 -1px;\t\t/* compensate for the borders because of");
            this.writeData("\t\t\t\t   100% width declaration */");
            this.writeData("\twidth: 100%;");
            this.writeData("\tz-index: 1;");
            this.writeData("}");
            this.writeData("#leftColumn, #middleColumn, #rightColumn, * html #SOWrap");
            this.writeData("{");
            this.writeData("\toverflow: visible;\t/* fix for IE italics bug */");
            this.writeData("\tposition: relative;\t/* fix some rendering issues */");
            this.writeData("}");
            this.writeData("#SOWrap");
            this.writeData("{");
            this.writeData("\tfloat: left;");
            this.writeData("\tmargin: 0 -1px 0 0;");
            this.writeData("\twidth: 100%;");
            this.writeData("\tz-index: 3;");
            this.writeData("}");
            this.writeData("#middleColumn");
            this.writeData("{");
            this.writeData("\tfloat: right;");
            this.writeData("\tmargin: 0 0 0 -1px;");
            this.writeData("\twidth: 100%;");
            this.writeData("\tz-index: 5;");
            this.writeData("}");
            this.writeData("#leftColumn");
            this.writeData("{");
            this.writeData("\tfloat: left;");
            this.writeData("\tmargin: 0 1px 0 -15em;");
            this.writeData("\twidth: 15em;");
            this.writeData("\tz-index: 4;");
            this.writeData("}");
            this.writeData("#rightColumn");
            this.writeData("{");
            this.writeData("\tfloat: right;");
            this.writeData("\t/*width: 14em;");
            this.writeData("\tmargin: 0 -14em 0 1px;*/");
            this.writeData("\tz-index: 2;");
            this.writeData("}");
            this.writeData("#footer");
            this.writeData("{");
            this.writeData("\tborder: solid 1px #fff;");
            this.writeData("\tborder-width: 1px 0;");
            this.writeData("\tpadding: 0.5em;");
            this.writeData("}");
            this.writeData("p.fontsize-set");
            this.writeData("{");
            this.writeData("\ttext-align: center;");
            this.writeData("}");
            this.writeData("p.fontsize-set img");
            this.writeData("{");
            this.writeData("\tborder-width: 0;");
            this.writeData("}");
            this.writeData(".vnav");
            this.writeData("{");
            this.writeData("\tmargin: 1em 0;");
            this.writeData("}");
            this.writeData(".vnav ul, .vnav ul li");
            this.writeData("{");
            this.writeData("\tmargin: 0;");
            this.writeData("\tpadding: 0;");
            this.writeData("\tlist-style-type: none;");
            this.writeData("\tdisplay: block;");
            this.writeData("}");
            this.writeData(".vnav ul");
            this.writeData("{");
            this.writeData("\tborder: solid 1px #fff;");
            this.writeData("\tborder-bottom-width: 0;");
            this.writeData("}");
            this.writeData(".vnav ul li");
            this.writeData("{");
            this.writeData("\tborder-bottom: solid 1px #fff;");
            this.writeData("}");
            this.writeData(".vnav ul li, .vnav ul li a");
            this.writeData("{");
            this.writeData("\tmargin: 0;");
            this.writeData("\tdisplay: block;");
            this.writeData("\tpadding: 0;");
            this.writeData("\tline-height: normal;");
            this.writeData("}");
            this.writeData(".vnav ul li a");
            this.writeData("{");
            this.writeData("\tdisplay: block;");
            this.writeData("\tpadding: 2px 5px 3px 5px;");
            this.writeData("}");
            this.writeData(".vnav ul li a, .vnav ul li a:link, .vnav ul li a:visited, .vnav ul li a:active, .vnav ul li a:hover");
            this.writeData("{");
            this.writeData("\ttext-decoration: none;");
            this.writeData("\tcursor: pointer;");
            this.writeData("}");
            this.writeData(".vnav h3");
            this.writeData("{");
            this.writeData("\tmargin-bottom: 0;");
            this.writeData("\tpadding-bottom: 0;");
            this.writeData("\tfont-size: 126%;");
            this.writeData("}");
            this.writeData("* html .vnav ul li a/* hide from IE5.0/Win & IE5/Mac */");
            this.writeData("{");
            this.writeData("\theight: 0.01%;");
            this.writeData("}");
            this.writeData("* html .vnav ul");
            this.writeData("{");
            this.writeData("\tposition: relative;\t/* IE needs this to fix a rendering problem */");
            this.writeData("}");
            this.writeData("/* horizontal navigation elements. create a DIV element with the class hnav");
            this.writeData(" * and stick one unordered list inside it to generate a horizontal menu.");
            this.writeData(" */");
            this.writeData(".hnav");
            this.writeData("{");
            this.writeData("\tborder-bottom: solid 1px #fff;");
            this.writeData("\ttext-align: center;");
            this.writeData("}");
            this.writeData(".hnav, .hnav ul li a");
            this.writeData("{");
            this.writeData("\tpadding-top: 3px;");
            this.writeData("\tpadding-bottom: 4px;");
            this.writeData("}");
            this.writeData(".hnav ul, .hnav ul li");
            this.writeData("{");
            this.writeData("\tdisplay: inline;");
            this.writeData("\tlist-style-type: none;");
            this.writeData("\tmargin: 0;");
            this.writeData("\tpadding: 0;");
            this.writeData("}");
            this.writeData(".hnav ul li a");
            this.writeData("{");
            this.writeData("\tmargin: 0 -1px 0 0;");
            this.writeData("\tpadding-left: 10px;");
            this.writeData("\tpadding-right: 10px;\t/* short-hand padding attribute would overwrite");
            this.writeData("\t\t\t\t   top/bottom padding set in a previous rule */");
            this.writeData("\tborder-left: solid 1px #000;");
            this.writeData("\tborder-right: solid 1px #000;");
            this.writeData("\twhite-space: nowrap;");
            this.writeData("}");
            this.writeData(".hnav ul li a:link, .hnav ul li a:visited, .hnav ul li a:active, .hnav ul li a:hover");
            this.writeData("{");
            this.writeData("\ttext-decoration: none;");
            this.writeData("}");
            this.writeData(".hnav ul li span.divider");
            this.writeData("{");
            this.writeData("\tdisplay: none;");
            this.writeData("}");
            this.writeData("* html .hnav ul li, * html .hnav ul li a");
            this.writeData("{");
            this.writeData("\twidth: 1%; /* IE/Mac needs this */");
            this.writeData("\tdisplay: inline-block;\t/* IE/Mac needs this */");
            this.writeData("\t\twidth: auto;");
            this.writeData("\t\tdisplay: inline;");
            this.writeData("\t/* reset above hack */");
            this.writeData("}");
            this.writeData("* html .hnav, * html .hnav ul a");
            this.writeData("{");
            this.writeData("\theight: 0.01%; /* hasLayout hack to fix render bugs in IE/Win. ");
            this.writeData("\t\t\t\t IE/Mac will ignore this rule. */");
            this.writeData("}");
            this.writeData("* html .HNAV");
            this.writeData("{");
            this.writeData("\tpadding: 0;\t/* IE5/Win will resize #hnav to fit the heights of its");
            this.writeData("\t\t\t   inline children that have vertical padding. So this");
            this.writeData("\t\t\t   incorrect case selector hack will be applied only by");
            this.writeData("\t\t\t   IE 5.x/Win */");
            this.writeData("}");
            this.writeData("/* everything below this point is related to the page's \"theme\" and could be");
            this.writeData(" * placed in a separate stylesheet to allow for multiple color/font scemes on");
            this.writeData(" * the layout. you should probably leave a default theme within this stylesheet");
            this.writeData(" * just to be on the safe side.\t");
            this.writeData(" */");
            this.writeData("#pageWrapper, #masthead, #innerColumnContainer, #footer, .vnav ul, .vnav ul li, .hnav, .hnav ul li a");
            this.writeData("{");
            this.writeData("\tborder-color: #565;");
            this.writeData("}");
            this.writeData("html, body");
            this.writeData("{");
            this.writeData("\t/* note that both html and body elements are in the selector.");
            this.writeData("\t * this is because we have margins applied to the body element");
            this.writeData("\t * and the HTML's background property will show through if");
            this.writeData("\t * it is ever set. _DO_NOT_ apply a font-size value to the");
            this.writeData("\t * html or body elements, set it in #pageWrapper.");
            this.writeData("\t */");
            this.writeData("\tbackground-color: #eee;");
            this.writeData("\tcolor: #000;");
            this.writeData("    \tfont-family: Verdana, Arial, Tahoma;");
            this.writeData("    \tfont-size: 14px; ");
            this.writeData("    \tmargin:0px;");
            this.writeData("\t");
            this.writeData("}");
            this.writeData("#pageWrapper");
            this.writeData("{");
            this.writeData("\tfont-size: 80%;\t/* set your default font size here. */");
            this.writeData("}");
            this.writeData("#masthead");
            this.writeData("{");
            this.writeData("\tbackground-color: #4411A1;");
            this.writeData("\tcolor: #fff;");
            this.writeData("}");
            this.writeData("#bannerOuterWrapper {");
            this.writeData("\theight:100px;");
            this.writeData("\tbackground-color: #fff;");
            this.writeData("}");
            this.writeData("#bannerWrapper {");
            this.writeData("\theight:100px;");
            this.writeData("}");
            this.writeData("#bannerWrapperRepeat {");
            this.writeData("\theight:100px;");
            this.writeData("}");
            this.writeData(".logo_text {");
            this.writeData("\tfont-size: 220%;");
            this.writeData("\tfont-weight:bold;");
            this.writeData("\tcolor:#CCCCFF;");
            this.writeData("}");
            this.writeData(".logo_body_text {");
            this.writeData("\tfont-size: 100%;");
            this.writeData("\tfont-weight:bold;");
            this.writeData("\tcolor:#4411A1;");
            this.writeData("}");
            this.writeData(".hnav");
            this.writeData("{");
            this.writeData("\tbackground-color: #CCCCFF;");
            this.writeData("\tcolor: #fff;");
            this.writeData("\tborder:0;");
            this.writeData("}");
            this.writeData("#outerColumnContainer");
            this.writeData("{");
            this.writeData("\tborder-left-color: #CCCCFF;\t/* left column background color */");
            this.writeData("\tborder-right-color: #CCCCFF;\t/* right column background color */");
            this.writeData("\tbackground-color: #fff;\t\t/* set the background color for the");
            this.writeData("\t\t\t\t\t   middle column here */");
            this.writeData("}");
            this.writeData(".vnav ul li a:link, .vnav ul li a:visited, .vnav ul li a:active");
            this.writeData("{");
            this.writeData("\ttext-decoration: none;");
            this.writeData("\tbackground-color: #4411A1;");
            this.writeData("\tcolor: #FFF;");
            this.writeData("}");
            this.writeData("#rightColumn .vnav ul li a:link, #rightColumn .vnav ul li a:visited, #rightColumn .vnav ul li a:active");
            this.writeData("{");
            this.writeData("\tbackground-color: #ded;");
            this.writeData("}");
            this.writeData(".vnav ul li a:hover, #rightColumn .vnav ul li a:hover");
            this.writeData("{");
            this.writeData("\ttext-decoration: none;");
            this.writeData("\tbackground-color: #FFFFFF;");
            this.writeData("\tcolor: #000000;");
            this.writeData("}");
            this.writeData(".hnav ul li a:link, .hnav ul li a:visited");
            this.writeData("{");
            this.writeData("\tbackground-color: #4411A1;");
            this.writeData("\tcolor: #fff;");
            this.writeData("}");
            this.writeData(".hnav ul li a:hover");
            this.writeData("{");
            this.writeData("\tbackground-color: #FFF;");
            this.writeData("\tcolor: #000;");
            this.writeData("\ttext-decoration: none;");
            this.writeData("}");
            this.writeData(".login_box");
            this.writeData("{");
            this.writeData("    \tfont-family: Verdana, Arial, Tahoma;");
            this.writeData("    \tfont-size: 10px; ");
            this.writeData("    \tborder-style: solid;");
            this.writeData("    \tborder-width: 3px; ");
            this.writeData("    \tborder-color: #4411A1;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("\tbackground-color: #FFF;");
            this.writeData("\tpadding-bottom:5px;");
            this.writeData("\tpadding-left:3px;");
            this.writeData("}");
            this.writeData("input ");
            this.writeData("{");
            this.writeData("    \tfont-family: Verdana, Arial, Tahoma;");
            this.writeData("    \tfont-size: 10px; ");
            this.writeData("    \tborder-style: solid;");
            this.writeData("    \tborder-width: 1px; ");
            this.writeData("    \tborder-color: #4411A1;");
            this.writeData("    \tbackground-color: #FFFFFF;");
            this.writeData("    \tcolor:#4411A1;");
            this.writeData("}");
            this.writeData("select ");
            this.writeData("{");
            this.writeData("    \tfont-family: Verdana, Arial, Tahoma;");
            this.writeData("    \tfont-size: 10px; ");
            this.writeData("    \tborder-style: solid;");
            this.writeData("    \tborder-width: 1px; ");
            this.writeData("    \tborder-color: #4411A1;");
            this.writeData("    \tbackground-color: #FFFFFF;");
            this.writeData("    \tcolor:#4411A1;");
            this.writeData("}");
            this.writeData(".profile_table");
            this.writeData("{");
            this.writeData("    \tfont-family: Verdana, Arial, Tahoma;");
            this.writeData("    \tfont-size: 10px; ");
            this.writeData("    \tborder-style: solid;");
            this.writeData("    \tborder-width: 1px; ");
            this.writeData("    \tborder-color: #4411A1;");
            this.writeData("    \tbackground-color: #FFFFFF;");
            this.writeData("    \tcolor:#000;");
            this.writeData("}");
            this.writeData("#rightColumn .inside");
            this.writeData("{");
            this.writeData("\t/* if you apply a font size to just #rightColumn, then its width,");
            this.writeData("\t * which is specified in EMs, will also be affected. you don't want");
            this.writeData("\t * that. so apply font size changes to the .inside element which exists");
            this.writeData("\t * inside underneath all three columns");
            this.writeData("\t */");
            this.writeData("\tfont-size: 90%;");
            this.writeData("}");
            this.writeData("#rightColumn .inside .vnav");
            this.writeData("{");
            this.writeData("\tfont-size: 110%;");
            this.writeData("}");
            this.writeData("#footer");
            this.writeData("{");
            this.writeData("\tborder:0;");
            this.writeData("\tcolor: #4411A1;");
            this.writeData("\ttext-align: center;");
            this.writeData("}");
            this.writeData(".input_plain {");
            this.writeData("\tcolor:#000;");
            this.writeData("}");
            this.writeData("/******************************************************************************/");
        }
    }

    class WebConsoleStopper
    extends Thread {
        WebConsoleStopper() {
        }

        public void run() {
            bKeepRunning = false;
            WebConsole.this.logger.info("Stopping WebConsole");
            WebConsole.shutdown();
        }
    }

    class WebConsoleStarter
    extends Thread {
        WebConsoleStarter() {
        }

        public void run() {
            if (alreadyStarted) {
                return;
            }
            try {
                WebConsole.this.logger.verbose("About to bind to port " + port);
                ServerSocket ss = new ServerSocket(port);
                alreadyStarted = true;
                WebConsole.this.logger.verbose("Listening for connections ...");
                while (bKeepRunning) {
                    new SocketHandler(ss.accept()).start();
                }
            }
            catch (IOException ioe) {
                WebConsole.this.logger.error("Cannot start WebConsole on port " + port + " : " + ioe);
                WebConsole.this.logger.printStackTrace(ioe);
            }
        }
    }
}

