/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.console;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class GeneratePoolCode {
    String configFileName;
    String outFileName;
    FileOutputStream outFile;
    boolean genInterface;

    public GeneratePoolCode(String configFileName, String outFileName, String classOrInterface) throws IOException {
        this.configFileName = configFileName;
        this.outFileName = outFileName;
        this.genInterface = !classOrInterface.equals("class");
        this.outFile = new FileOutputStream(outFileName);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("java GeneratePoolCode <config file> <out file> <class|interface>");
        } else {
            GeneratePoolCode gpc = new GeneratePoolCode(args[0], args[1], args[2]);
            gpc.doit();
        }
    }

    public void doit() throws IOException {
        String name;
        String[] parts;
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.configFileName)));
        if (!this.genInterface) {
            while ((line = br.readLine()) != null) {
                parts = line.split("=");
                name = parts[0];
                this.generateClassVars(name);
            }
        }
        br.close();
        br = new BufferedReader(new InputStreamReader(new FileInputStream(this.configFileName)));
        while ((line = br.readLine()) != null) {
            parts = line.split("=");
            name = parts[0];
            this.generateGetSet(name);
        }
        br.close();
        this.outFile.close();
    }

    public void generateClassVars(String name) throws IOException {
        this.outFile.write(("\t// The '" + name + "' pool config property\n").getBytes());
        this.outFile.write(("\tprotected String " + name + ";\n\n").getBytes());
        this.outFile.flush();
    }

    public void generateGetSet(String name) throws IOException {
        String camelName = (name.charAt(0) + "").toUpperCase() + name.substring(1, name.length());
        this.outFile.write("\t/**\n".getBytes());
        this.outFile.write(("\t*\tGet the '" + name + "' pool config property\n").getBytes());
        this.outFile.write("\t*/\n".getBytes());
        if (!this.genInterface) {
            this.outFile.write(("\tpublic String get" + camelName + "() {\n").getBytes());
            this.outFile.write(("\t\treturn " + name + ";\n").getBytes());
            this.outFile.write("\t}\n\n".getBytes());
        } else {
            this.outFile.write(("\tpublic String get" + camelName + "();\n\n").getBytes());
        }
        this.outFile.write("\t/**\n".getBytes());
        this.outFile.write(("\t*\tSet the '" + name + "' pool config property\n").getBytes());
        this.outFile.write("\t*/\n".getBytes());
        if (!this.genInterface) {
            this.outFile.write(("\tpublic void set" + camelName + "(String " + name + ") {\n").getBytes());
            this.outFile.write(("\t\tthis." + name + " = " + name + ";\n").getBytes());
            this.outFile.write("\t}\n\n\n".getBytes());
        } else {
            this.outFile.write(("\tpublic void set" + camelName + "(String " + name + ");\n\n\n").getBytes());
        }
        this.outFile.flush();
    }
}

