/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Dates;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Recur
implements Serializable {
    private static final long serialVersionUID = -7333226591784095142L;
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";
    public static final String SECONDLY = "SECONDLY";
    public static final String MINUTELY = "MINUTELY";
    public static final String HOURLY = "HOURLY";
    public static final String DAILY = "DAILY";
    public static final String WEEKLY = "WEEKLY";
    public static final String MONTHLY = "MONTHLY";
    public static final String YEARLY = "YEARLY";
    private transient Log log = LogFactory.getLog((Class)Recur.class);
    private String frequency;
    private Date until;
    private int count = -1;
    private int interval = -1;
    private NumberList secondList;
    private NumberList minuteList;
    private NumberList hourList;
    private WeekDayList dayList;
    private NumberList monthDayList;
    private NumberList yearDayList;
    private NumberList weekNoList;
    private NumberList monthList;
    private NumberList setPosList;
    private String weekStartDay;
    private Map experimentalValues = new HashMap();

    public Recur(String aValue) throws ParseException {
        StringTokenizer t = new StringTokenizer(aValue, ";=");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (FREQ.equals(token)) {
                this.frequency = t.nextToken();
                continue;
            }
            if (UNTIL.equals(token)) {
                String untilString = t.nextToken();
                try {
                    this.until = new DateTime(untilString);
                    ((DateTime)this.until).setUtc(true);
                }
                catch (ParseException pe) {
                    this.until = new Date(untilString);
                }
                continue;
            }
            if (COUNT.equals(token)) {
                this.count = Integer.parseInt(t.nextToken());
                continue;
            }
            if (INTERVAL.equals(token)) {
                this.interval = Integer.parseInt(t.nextToken());
                continue;
            }
            if (BYSECOND.equals(token)) {
                this.secondList = new NumberList(t.nextToken());
                continue;
            }
            if (BYMINUTE.equals(token)) {
                this.minuteList = new NumberList(t.nextToken());
                continue;
            }
            if (BYHOUR.equals(token)) {
                this.hourList = new NumberList(t.nextToken());
                continue;
            }
            if (BYDAY.equals(token)) {
                this.dayList = new WeekDayList(t.nextToken());
                continue;
            }
            if (BYMONTHDAY.equals(token)) {
                this.monthDayList = new NumberList(t.nextToken());
                continue;
            }
            if (BYYEARDAY.equals(token)) {
                this.yearDayList = new NumberList(t.nextToken());
                continue;
            }
            if (BYWEEKNO.equals(token)) {
                this.weekNoList = new NumberList(t.nextToken());
                continue;
            }
            if (BYMONTH.equals(token)) {
                this.monthList = new NumberList(t.nextToken());
                continue;
            }
            if (BYSETPOS.equals(token)) {
                this.setPosList = new NumberList(t.nextToken());
                continue;
            }
            if (WKST.equals(token)) {
                this.weekStartDay = t.nextToken();
                continue;
            }
            this.experimentalValues.put(token, t.nextToken());
        }
        this.validateFrequency();
    }

    public Recur(String frequency, Date until) {
        this.frequency = frequency;
        this.until = until;
        this.validateFrequency();
    }

    public Recur(String frequency, int count) {
        this.frequency = frequency;
        this.count = count;
        this.validateFrequency();
    }

    public final WeekDayList getDayList() {
        if (this.dayList == null) {
            this.dayList = new WeekDayList();
        }
        return this.dayList;
    }

    public final NumberList getHourList() {
        if (this.hourList == null) {
            this.hourList = new NumberList();
        }
        return this.hourList;
    }

    public final NumberList getMinuteList() {
        if (this.minuteList == null) {
            this.minuteList = new NumberList();
        }
        return this.minuteList;
    }

    public final NumberList getMonthDayList() {
        if (this.monthDayList == null) {
            this.monthDayList = new NumberList();
        }
        return this.monthDayList;
    }

    public final NumberList getMonthList() {
        if (this.monthList == null) {
            this.monthList = new NumberList();
        }
        return this.monthList;
    }

    public final NumberList getSecondList() {
        if (this.secondList == null) {
            this.secondList = new NumberList();
        }
        return this.secondList;
    }

    public final NumberList getSetPosList() {
        if (this.setPosList == null) {
            this.setPosList = new NumberList();
        }
        return this.setPosList;
    }

    public final NumberList getWeekNoList() {
        if (this.weekNoList == null) {
            this.weekNoList = new NumberList();
        }
        return this.weekNoList;
    }

    public final NumberList getYearDayList() {
        if (this.yearDayList == null) {
            this.yearDayList = new NumberList();
        }
        return this.yearDayList;
    }

    public final int getCount() {
        return this.count;
    }

    public final Map getExperimentalValues() {
        return this.experimentalValues;
    }

    public final String getFrequency() {
        return this.frequency;
    }

    public final int getInterval() {
        return this.interval;
    }

    public final Date getUntil() {
        return this.until;
    }

    public final String getWeekStartDay() {
        return this.weekStartDay;
    }

    public final void setWeekStartDay(String weekStartDay) {
        this.weekStartDay = weekStartDay;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append(FREQ);
        b.append('=');
        b.append(this.frequency);
        if (this.weekStartDay != null) {
            b.append(';');
            b.append(WKST);
            b.append('=');
            b.append(this.weekStartDay);
        }
        if (this.interval >= 1) {
            b.append(';');
            b.append(INTERVAL);
            b.append('=');
            b.append(this.interval);
        }
        if (this.until != null) {
            b.append(';');
            b.append(UNTIL);
            b.append('=');
            b.append(this.until);
        }
        if (this.count >= 1) {
            b.append(';');
            b.append(COUNT);
            b.append('=');
            b.append(this.count);
        }
        if (!this.getMonthList().isEmpty()) {
            b.append(';');
            b.append(BYMONTH);
            b.append('=');
            b.append(this.monthList);
        }
        if (!this.getWeekNoList().isEmpty()) {
            b.append(';');
            b.append(BYWEEKNO);
            b.append('=');
            b.append(this.weekNoList);
        }
        if (!this.getYearDayList().isEmpty()) {
            b.append(';');
            b.append(BYYEARDAY);
            b.append('=');
            b.append(this.yearDayList);
        }
        if (!this.getMonthDayList().isEmpty()) {
            b.append(';');
            b.append(BYMONTHDAY);
            b.append('=');
            b.append(this.monthDayList);
        }
        if (!this.getDayList().isEmpty()) {
            b.append(';');
            b.append(BYDAY);
            b.append('=');
            b.append(this.dayList);
        }
        if (!this.getHourList().isEmpty()) {
            b.append(';');
            b.append(BYHOUR);
            b.append('=');
            b.append(this.hourList);
        }
        if (!this.getMinuteList().isEmpty()) {
            b.append(';');
            b.append(BYMINUTE);
            b.append('=');
            b.append(this.minuteList);
        }
        if (!this.getSecondList().isEmpty()) {
            b.append(';');
            b.append(BYSECOND);
            b.append('=');
            b.append(this.secondList);
        }
        if (!this.getSetPosList().isEmpty()) {
            b.append(';');
            b.append(BYSETPOS);
            b.append('=');
            b.append(this.setPosList);
        }
        return b.toString();
    }

    public final DateList getDates(Date periodStart, Date periodEnd, Value value) {
        return this.getDates(periodStart, periodStart, periodEnd, value);
    }

    public final DateList getDates(Date seed, Period period, Value value) {
        return this.getDates(seed, period.getStart(), period.getEnd(), value);
    }

    public final DateList getDates(Date seed, Date periodStart, Date periodEnd, Value value) {
        DateList dates = new DateList(value);
        if (seed instanceof DateTime) {
            if (((DateTime)seed).isUtc()) {
                dates.setUtc(true);
            } else {
                dates.setTimeZone(((DateTime)seed).getTimeZone());
            }
        }
        Calendar cal = Dates.getCalendarInstance(seed);
        cal.setTime(seed);
        if (this.getCount() < 1) {
            Calendar seededCal = (Calendar)cal.clone();
            while (seededCal.getTime().before(periodStart)) {
                cal.setTime(seededCal.getTime());
                this.increment(seededCal);
            }
        }
        int invalidCandidateCount = 0;
        java.util.Date candidate = null;
        while (true) {
            Date candidateSeed = Dates.getInstance(cal.getTime(), value);
            if (this.getUntil() != null && candidate != null && candidate.after(this.getUntil()) || periodEnd != null && candidate != null && candidate.after(periodEnd) || this.getCount() >= 1 && dates.size() + invalidCandidateCount >= this.getCount()) break;
            if (Value.DATE_TIME.equals(value)) {
                if (dates.isUtc()) {
                    ((DateTime)candidateSeed).setUtc(true);
                } else {
                    ((DateTime)candidateSeed).setTimeZone(dates.getTimeZone());
                }
            }
            DateList candidates = this.getCandidates(candidateSeed, value);
            Collections.sort(candidates);
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                candidate = (Date)i.next();
                if (candidate.before(seed)) continue;
                if (candidate.before(periodStart) || !candidate.before(periodEnd)) {
                    ++invalidCandidateCount;
                    continue;
                }
                if (this.getCount() >= 1 && dates.size() + invalidCandidateCount >= this.getCount()) break;
                if (this.getUntil() != null && candidate.after(this.getUntil())) continue;
                dates.add((Date)candidate);
            }
            this.increment(cal);
        }
        Collections.sort(dates);
        return dates;
    }

    private void increment(Calendar cal) {
        int calInterval;
        int n = calInterval = this.getInterval() >= 1 ? this.getInterval() : 1;
        if (SECONDLY.equals(this.getFrequency())) {
            cal.add(13, calInterval);
        } else if (MINUTELY.equals(this.getFrequency())) {
            cal.add(12, calInterval);
        } else if (HOURLY.equals(this.getFrequency())) {
            cal.add(11, calInterval);
        } else if (DAILY.equals(this.getFrequency())) {
            cal.add(6, calInterval);
        } else if (WEEKLY.equals(this.getFrequency())) {
            cal.add(3, calInterval);
        } else if (MONTHLY.equals(this.getFrequency())) {
            cal.add(2, calInterval);
        } else if (YEARLY.equals(this.getFrequency())) {
            cal.add(1, calInterval);
        }
    }

    private DateList getCandidates(Date date, Value value) {
        DateList dates = new DateList(value);
        if (date instanceof DateTime) {
            if (((DateTime)date).isUtc()) {
                dates.setUtc(true);
            } else {
                dates.setTimeZone(((DateTime)date).getTimeZone());
            }
        }
        dates.add(date);
        dates = this.getMonthVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYMONTH processing: " + dates));
        }
        dates = this.getWeekNoVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYWEEKNO processing: " + dates));
        }
        dates = this.getYearDayVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYYEARDAY processing: " + dates));
        }
        dates = this.getMonthDayVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYMONTHDAY processing: " + dates));
        }
        dates = this.getDayVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYDAY processing: " + dates));
        }
        dates = this.getHourVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYHOUR processing: " + dates));
        }
        dates = this.getMinuteVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYMINUTE processing: " + dates));
        }
        dates = this.getSecondVariants(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after BYSECOND processing: " + dates));
        }
        dates = this.applySetPosRules(dates);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Dates after SETPOS processing: " + dates));
        }
        return dates;
    }

    private DateList applySetPosRules(DateList dates) {
        if (this.getSetPosList().isEmpty()) {
            return dates;
        }
        Collections.sort(dates);
        DateList setPosDates = new DateList(dates.getType(), dates.getTimeZone());
        int size = dates.size();
        Iterator i = this.getSetPosList().iterator();
        while (i.hasNext()) {
            Integer setPos = (Integer)i.next();
            int pos = setPos;
            if (pos > 0 && pos <= size) {
                setPosDates.add(dates.get(pos - 1));
                continue;
            }
            if (pos >= 0 || pos < -size) continue;
            setPosDates.add(dates.get(size + pos));
        }
        return setPosDates;
    }

    private DateList getMonthVariants(DateList dates) {
        if (this.getMonthList().isEmpty()) {
            return dates;
        }
        DateList monthlyDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getMonthList().iterator();
            while (j.hasNext()) {
                Integer month = (Integer)j.next();
                cal.roll(2, month - 1 - cal.get(2));
                monthlyDates.add(Dates.getInstance(cal.getTime(), monthlyDates.getType()));
            }
        }
        return monthlyDates;
    }

    private DateList getWeekNoVariants(DateList dates) {
        if (this.getWeekNoList().isEmpty()) {
            return dates;
        }
        DateList weekNoDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getWeekNoList().iterator();
            while (j.hasNext()) {
                Integer weekNo = (Integer)j.next();
                cal.set(3, Dates.getAbsWeekNo(cal.getTime(), weekNo));
                weekNoDates.add(Dates.getInstance(cal.getTime(), weekNoDates.getType()));
            }
        }
        return weekNoDates;
    }

    private DateList getYearDayVariants(DateList dates) {
        if (this.getYearDayList().isEmpty()) {
            return dates;
        }
        DateList yearDayDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getYearDayList().iterator();
            while (j.hasNext()) {
                Integer yearDay = (Integer)j.next();
                cal.set(6, Dates.getAbsYearDay(cal.getTime(), yearDay));
                yearDayDates.add(Dates.getInstance(cal.getTime(), yearDayDates.getType()));
            }
        }
        return yearDayDates;
    }

    private DateList getMonthDayVariants(DateList dates) {
        if (this.getMonthDayList().isEmpty()) {
            return dates;
        }
        DateList monthDayDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getMonthDayList().iterator();
            while (j.hasNext()) {
                Integer monthDay = (Integer)j.next();
                cal.set(5, Dates.getAbsMonthDay(cal.getTime(), monthDay));
                monthDayDates.add(Dates.getInstance(cal.getTime(), monthDayDates.getType()));
            }
        }
        return monthDayDates;
    }

    private DateList getDayVariants(DateList dates) {
        if (this.getDayList().isEmpty()) {
            return dates;
        }
        DateList weekDayDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Iterator j = this.getDayList().iterator();
            while (j.hasNext()) {
                WeekDay weekDay = (WeekDay)j.next();
                if (!this.getYearDayList().isEmpty() || !this.getMonthDayList().isEmpty()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    if (!weekDay.equals(WeekDay.getWeekDay(cal))) continue;
                    weekDayDates.add(date);
                    continue;
                }
                weekDayDates.addAll(this.getAbsWeekDays(date, dates.getType(), weekDay));
            }
        }
        return weekDayDates;
    }

    private List getAbsWeekDays(Date date, Value type, WeekDay weekDay) {
        DateList days;
        block16: {
            int calDay;
            Calendar cal;
            block15: {
                cal = Dates.getCalendarInstance(date);
                cal.setTime(date);
                days = new DateList(type);
                if (date instanceof DateTime) {
                    if (((DateTime)date).isUtc()) {
                        days.setUtc(true);
                    } else {
                        days.setTimeZone(((DateTime)date).getTimeZone());
                    }
                }
                if ((calDay = WeekDay.getCalendarDay(weekDay)) == -1) {
                    return days;
                }
                if (!DAILY.equals(this.getFrequency())) break block15;
                if (cal.get(7) != calDay) break block16;
                days.add(Dates.getInstance(cal.getTime(), type));
                break block16;
            }
            if (WEEKLY.equals(this.getFrequency()) || !this.getWeekNoList().isEmpty()) {
                while (cal.get(7) != calDay) {
                    cal.add(7, 1);
                }
                int weekNo = cal.get(3);
                while (cal.get(3) == weekNo) {
                    days.add(Dates.getInstance(cal.getTime(), type));
                    cal.add(7, 7);
                }
            } else if (MONTHLY.equals(this.getFrequency()) || !this.getMonthList().isEmpty()) {
                int month = cal.get(2);
                cal.set(5, 1);
                while (cal.get(7) != calDay) {
                    cal.add(5, 1);
                }
                while (cal.get(2) == month) {
                    days.add(Dates.getInstance(cal.getTime(), type));
                    cal.add(5, 7);
                }
            } else if (YEARLY.equals(this.getFrequency())) {
                int year = cal.get(1);
                cal.set(6, 1);
                while (cal.get(7) != calDay) {
                    cal.add(6, 1);
                }
                while (cal.get(1) == year) {
                    days.add(Dates.getInstance(cal.getTime(), type));
                    cal.add(6, 7);
                }
            }
        }
        return this.getOffsetDates(days, weekDay.getOffset());
    }

    private List getOffsetDates(DateList dates, int offset) {
        if (offset == 0) {
            return dates;
        }
        DateList offsetDates = new DateList(dates.getType(), dates.getTimeZone());
        int size = dates.size();
        if (offset < 0 && offset >= -size) {
            offsetDates.add(dates.get(size + offset));
        } else if (offset > 0 && offset <= size) {
            offsetDates.add(dates.get(offset - 1));
        }
        return offsetDates;
    }

    private DateList getHourVariants(DateList dates) {
        if (this.getHourList().isEmpty()) {
            return dates;
        }
        DateList hourlyDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getHourList().iterator();
            while (j.hasNext()) {
                Integer hour = (Integer)j.next();
                cal.set(11, hour);
                hourlyDates.add(Dates.getInstance(cal.getTime(), hourlyDates.getType()));
            }
        }
        return hourlyDates;
    }

    private DateList getMinuteVariants(DateList dates) {
        if (this.getMinuteList().isEmpty()) {
            return dates;
        }
        DateList minutelyDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getMinuteList().iterator();
            while (j.hasNext()) {
                Integer minute = (Integer)j.next();
                cal.set(12, minute);
                minutelyDates.add(Dates.getInstance(cal.getTime(), minutelyDates.getType()));
            }
        }
        return minutelyDates;
    }

    private DateList getSecondVariants(DateList dates) {
        if (this.getSecondList().isEmpty()) {
            return dates;
        }
        DateList secondlyDates = new DateList(dates.getType(), dates.getTimeZone());
        Iterator i = dates.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            Iterator j = this.getSecondList().iterator();
            while (j.hasNext()) {
                Integer second = (Integer)j.next();
                cal.set(13, second);
                secondlyDates.add(Dates.getInstance(cal.getTime(), secondlyDates.getType()));
            }
        }
        return secondlyDates;
    }

    private void validateFrequency() {
        if (this.frequency == null) {
            throw new IllegalArgumentException("A recurrence rule MUST contain a FREQ rule part.");
        }
        if (!(this.frequency.equals(SECONDLY) || this.frequency.equals(MINUTELY) || this.frequency.equals(HOURLY) || this.frequency.equals(DAILY) || this.frequency.equals(WEEKLY) || this.frequency.equals(MONTHLY) || this.frequency.equals(YEARLY))) {
            throw new IllegalArgumentException("Invalid FREQ rule part '" + this.frequency + "' in recurrence rule");
        }
    }

    public final void setCount(int count) {
        this.count = count;
        this.until = null;
    }

    public final void setFrequency(String frequency) {
        this.frequency = frequency;
        this.validateFrequency();
    }

    public final void setInterval(int interval) {
        this.interval = interval;
    }

    public final void setUntil(Date until) {
        this.until = until;
        this.count = -1;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LogFactory.getLog((Class)Recur.class);
    }
}

