/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.workflowtasks.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTaskDueDateException;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.workflowtasks.action.ActionUtil;
import java.util.Date;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditWorkflowTaskAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("assign")) {
                this.assignTask(actionRequest);
            } else if (cmd.equals("save")) {
                this.completeTask(actionRequest);
            } else if (cmd.equals("update")) {
                this.updateTask(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof WorkflowTaskDueDateException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof PrincipalException || e instanceof WorkflowException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.workflow_tasks.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getWorkflowTask((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof WorkflowException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.workflow_tasks.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.workflow_tasks.edit_workflow_task"));
    }

    protected void assignTask(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long workflowTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"workflowTaskId");
        long assigneeUserId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"assigneeUserId");
        String comment = ParamUtil.getString((PortletRequest)actionRequest, (String)"comment");
        WorkflowTaskManagerUtil.assignWorkflowTaskToUser((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (long)workflowTaskId, (long)assigneeUserId, (String)comment, null, null);
    }

    protected void completeTask(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long workflowTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"workflowTaskId");
        String transitionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"transitionName");
        String comment = ParamUtil.getString((PortletRequest)actionRequest, (String)"comment");
        WorkflowTaskManagerUtil.completeWorkflowTask((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (long)workflowTaskId, (String)transitionName, (String)comment, null);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void updateTask(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long workflowTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"workflowTaskId");
        String comment = ParamUtil.getString((PortletRequest)actionRequest, (String)"comment");
        int dueDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateMonth");
        int dueDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateDay");
        int dueDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateYear");
        int dueDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateHour");
        int dueDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateMinute");
        int dueDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dueDateAmPm");
        if (dueDateAmPm == 1) {
            dueDateHour += 12;
        }
        Date dueDate = PortalUtil.getDate((int)dueDateMonth, (int)dueDateDay, (int)dueDateYear, (int)dueDateHour, (int)dueDateMinute, (PortalException)new WorkflowTaskDueDateException());
        WorkflowTaskManagerUtil.updateDueDate((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (long)workflowTaskId, (String)comment, (Date)dueDate);
    }
}

