/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.translators;

import com.liferay.portlet.wiki.translators.BaseTranslator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaWikiToCreoleTranslator
extends BaseTranslator {
    public static final String TABLE_OF_CONTENTS = "<<TableOfContents>>\n\n";
    private static final String[] _HTML_TAGS = new String[]{"<blockquote>", "</blockquote>", "<br>", "<br/>", "<br />", "<center>", "</center>", "<cite>", "</cite>", "<code>", "</code>", "<div[^>]*>", "</div>", "<font[^>]*>", "</font>", "<hr>", "<hr/>", "<hr />", "<p>", "</p>", "<tt>", "</tt>", "<var>", "</var>"};

    public MediaWikiToCreoleTranslator() {
        this.initRegexps();
        this.initNowikiRegexps();
    }

    protected void initNowikiRegexps() {
        this.nowikiRegexps.add("(<nowiki>)(.*?)(</nowiki>)");
        this.nowikiRegexps.add("(<pre>)(.*?)(</pre>)");
        this.nowikiRegexps.add("~(\\*\\*|~|//|-|#|\\{\\{|}}|\\\\|~\\[~~[|]]|----|=|\\|)");
    }

    protected void initRegexps() {
        this.regexps.put("= '''([^=]+)''' =", "= $1 =");
        this.regexps.put("== '''([^=]+)''' ==", "== $1 ==");
        this.regexps.put("== '''([^=]+)''' ===", "=== $1 ===");
        this.regexps.put("&lt;", "<");
        this.regexps.put("&gt;", ">");
        this.regexps.put("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*", "");
        this.regexps.put("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}", "");
        this.regexps.put("\\{{2}Work in progress\\}{2}", "");
        this.regexps.put("''''((?s:.)*?)(''''|(\n\n|\r\r|\r\n\r\n))", "**//$1//**$3");
        this.regexps.put("'''((?s:.)*?)('''|(\n\n|\r\r|\r\n\r\n))", "**$1**$3");
        this.regexps.put("''((?s:.)*?)(''|(\n\n|\r\r|\r\n\r\n))", "//$1//$3");
        this.regexps.put("\\[{2}((http|ftp)[^ ]*) ([^\\]]*)\\]{2}", "[$1 $3]");
        this.regexps.put("\\[((http|ftp)[^ ]*)\\]", "[[$1]]");
        this.regexps.put("\\[((http|ftp)[^ ]*) ([^\\]]*)\\]", "[[$1|$3]]");
        this.regexps.put("^\\t([\\w]+):\\t(.*)", "**$1**:\n$2");
        this.regexps.put("^\\t:\\t(.*)", "$1");
        this.regexps.put("(^ (.+))(\\n (.+))*", "{{{\n$0\n}}}");
        this.regexps.put("<nowiki>([^<]*)</nowiki>", "{{{$1}}}");
        this.regexps.put("<pre>([^<]*)</pre>", "{{{$1}}}");
        this.regexps.put("[-]*\\[{2}User:([^\\]]*)\\]{2}", "$1");
    }

    protected String postProcess(String content) {
        Matcher matcher = Pattern.compile("^=([^=]+)=", 8).matcher(content);
        if (matcher.find()) {
            content = this.runRegexp(content, "^===([^=]+)===", "====$1====");
            content = this.runRegexp(content, "^==([^=]+)==", "===$1===");
            content = this.runRegexp(content, "^=([^=]+)=", "==$1==");
        }
        int i = 0;
        while (i < _HTML_TAGS.length) {
            content = content.replaceAll(_HTML_TAGS[i], "");
            ++i;
        }
        matcher = Pattern.compile("\\[{2}Image:([^\\]]*)\\]{2}", 32).matcher(content);
        StringBuffer sb = new StringBuffer(content);
        int offset = 0;
        while (matcher.find()) {
            String image = "{{SharedImages/" + matcher.group(1).toLowerCase() + "}}";
            sb.replace(matcher.start(0) + offset, matcher.end(0) + offset, image);
            offset += "SharedImages".length() - 5;
        }
        content = sb.toString();
        matcher = Pattern.compile("\\[{2}([^\\]]*)\\]{2}", 32).matcher(content);
        sb = new StringBuffer(content);
        while (matcher.find()) {
            String link = matcher.group(1).replace("_", " ");
            sb.replace(matcher.start(1), matcher.end(1), link);
        }
        return TABLE_OF_CONTENTS + super.postProcess(sb.toString());
    }
}

