/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.plugininstaller.action;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.events.GlobalStartupAction;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.plugin.RepositoryReport;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.ProgressInputStream;
import com.liferay.portal.util.HttpImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.UploadException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class InstallPluginAction
extends PortletAction {
    private static final String _DOWNLOAD_DIR = "download";
    private static Log _log = LogFactoryUtil.getLog(InstallPluginAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.plugin_installer.error");
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("deployConfiguration")) {
            this.deployConfiguration(actionRequest);
        } else if (cmd.equals("ignorePackages")) {
            this.ignorePackages(actionRequest);
        } else if (cmd.equals("localDeploy")) {
            this.localDeploy(actionRequest);
        } else if (cmd.equals("reloadRepositories")) {
            this.reloadRepositories(actionRequest);
        } else if (cmd.equals("remoteDeploy")) {
            this.remoteDeploy(actionRequest);
        } else if (cmd.equals("unignorePackages")) {
            this.unignorePackages(actionRequest);
        } else if (cmd.equals("uninstall")) {
            this.uninstall(actionRequest);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    protected void deployConfiguration(ActionRequest actionRequest) throws Exception {
        boolean enabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enabled");
        String deployDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"deployDir");
        String destDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"destDir");
        long interval = ParamUtil.getLong((PortletRequest)actionRequest, (String)"interval");
        int blacklistThreshold = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"blacklistThreshold");
        boolean unpackWar = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"unpackWar");
        boolean customPortletXml = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"customPortletXml");
        String jbossPrefix = ParamUtil.getString((PortletRequest)actionRequest, (String)"jbossPrefix");
        String tomcatConfDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"tomcatConfDir");
        String tomcatLibDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"tomcatLibDir");
        String pluginRepositoriesTrusted = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginRepositoriesTrusted");
        String pluginRepositoriesUntrusted = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginRepositoriesUntrusted");
        boolean pluginNotificationsEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"pluginNotificationsEnabled");
        String pluginPackagesIgnored = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginPackagesIgnored");
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        preferences.setValue("auto.deploy.enabled", String.valueOf(enabled));
        preferences.setValue("auto.deploy.deploy.dir", deployDir);
        preferences.setValue("auto.deploy.dest.dir", destDir);
        preferences.setValue("auto.deploy.interval", String.valueOf(interval));
        preferences.setValue("auto.deploy.blacklist.threshold", String.valueOf(blacklistThreshold));
        preferences.setValue("auto.deploy.unpack.war", String.valueOf(unpackWar));
        preferences.setValue("auto.deploy.custom.portlet.xml", String.valueOf(customPortletXml));
        preferences.setValue("auto.deploy.jboss.prefix", jbossPrefix);
        preferences.setValue("auto.deploy.tomcat.conf.dir", tomcatConfDir);
        preferences.setValue("auto.deploy.tomcat.lib.dir", tomcatLibDir);
        preferences.setValue("plugin.repositories.trusted", pluginRepositoriesTrusted);
        preferences.setValue("plugin.repositories.untrusted", pluginRepositoriesUntrusted);
        preferences.setValue("plugin.notifications.enabled", String.valueOf(pluginNotificationsEnabled));
        preferences.setValue("plugin.notifications.packages.ignored", pluginPackagesIgnored);
        preferences.store();
        this.reloadRepositories(actionRequest);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Unregistering auto deploy directories");
        }
        AutoDeployUtil.unregisterDir((String)"defaultAutoDeployDir");
        if (enabled) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Registering auto deploy directories");
            }
            List<AutoDeployListener> autoDeployListeners = GlobalStartupAction.getAutoDeployListeners();
            AutoDeployDir autoDeployDir = new AutoDeployDir("defaultAutoDeployDir", new File(deployDir), new File(destDir), interval, blacklistThreshold, autoDeployListeners);
            AutoDeployUtil.registerDir((AutoDeployDir)autoDeployDir);
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)"Not registering auto deploy directories");
        }
    }

    protected String[] getSourceForgeMirrors() {
        return PropsUtil.getArray("source.forge.mirrors");
    }

    protected void ignorePackages(ActionRequest actionRequest) throws Exception {
        String pluginPackagesIgnored = ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginPackagesIgnored");
        String oldPluginPackagesIgnored = PrefsPropsUtil.getString("plugin.notifications.packages.ignored");
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        if (Validator.isNotNull((String)oldPluginPackagesIgnored)) {
            preferences.setValue("plugin.notifications.packages.ignored", oldPluginPackagesIgnored.concat("\n").concat(pluginPackagesIgnored));
        } else {
            preferences.setValue("plugin.notifications.packages.ignored", pluginPackagesIgnored);
        }
        preferences.store();
        PluginPackageUtil.refreshUpdatesAvailableCache();
    }

    protected void localDeploy(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String fileName = null;
        String deploymentContext = ParamUtil.getString((PortletRequest)actionRequest, (String)"deploymentContext");
        if (Validator.isNotNull((String)deploymentContext)) {
            fileName = "DEPLOY_TO__" + deploymentContext + ".war";
        } else {
            fileName = GetterUtil.getString((String)uploadRequest.getFileName("file"));
            int pos = fileName.lastIndexOf(46);
            if (pos != -1) {
                deploymentContext = fileName.substring(0, pos);
            }
        }
        File file = uploadRequest.getFile("file");
        byte[] bytes = FileUtil.getBytes((File)file);
        if (bytes == null || bytes.length == 0) {
            SessionErrors.add((PortletRequest)actionRequest, (String)UploadException.class.getName());
            return;
        }
        try {
            PluginPackageUtil.registerPluginPackageInstallation(deploymentContext);
            String source = file.toString();
            String deployDir = PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
            String destination = String.valueOf(deployDir) + "/" + fileName;
            FileUtil.copyFile((String)source, (String)destination);
            SessionMessages.add((PortletRequest)actionRequest, (String)"pluginUploaded");
        }
        finally {
            PluginPackageUtil.endPluginPackageInstallation(deploymentContext);
        }
    }

    protected void reloadRepositories(ActionRequest actionRequest) throws Exception {
        RepositoryReport repositoryReport = PluginPackageUtil.reloadRepositories();
        SessionMessages.add((PortletRequest)actionRequest, (String)"PLUGIN_REPOSITORY_REPORT", (Object)repositoryReport);
    }

    protected void remoteDeploy(ActionRequest actionRequest) throws Exception {
        try {
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
            URL urlObj = new URL(url);
            String host = urlObj.getHost();
            if (host.endsWith(".sf.net") || host.endsWith(".sourceforge.net")) {
                this.remoteDeploySourceForge(urlObj.getPath(), actionRequest);
            } else {
                this.remoteDeploy(url, urlObj, actionRequest, true);
            }
        }
        catch (MalformedURLException murle) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"invalidUrl", (Object)murle);
        }
    }

    protected int remoteDeploy(String url, URL urlObj, ActionRequest actionRequest, boolean failOnError) throws Exception {
        int responseCode;
        block23: {
            responseCode = 200;
            GetMethod getMethod = null;
            String deploymentContext = ParamUtil.getString((PortletRequest)actionRequest, (String)"deploymentContext");
            try {
                HttpImpl httpImpl = (HttpImpl)HttpUtil.getHttp();
                HostConfiguration hostConfig = httpImpl.getHostConfig(url);
                HttpClient client = httpImpl.getClient(hostConfig);
                getMethod = new GetMethod(url);
                String fileName = null;
                if (Validator.isNotNull((String)deploymentContext)) {
                    fileName = "DEPLOY_TO__" + deploymentContext + ".war";
                } else {
                    fileName = url.substring(url.lastIndexOf(47) + 1);
                    int pos = fileName.lastIndexOf(46);
                    if (pos != -1) {
                        deploymentContext = fileName.substring(0, pos);
                    }
                }
                PluginPackageUtil.registerPluginPackageInstallation(deploymentContext);
                responseCode = client.executeMethod(hostConfig, (HttpMethod)getMethod);
                if (responseCode != 200) {
                    if (failOnError) {
                        SessionErrors.add((PortletRequest)actionRequest, (String)"errorConnectingToUrl", (Object)new Object[]{String.valueOf(responseCode)});
                    }
                    int n = responseCode;
                    return n;
                }
                try {
                    long contentLength = getMethod.getResponseContentLength();
                    String progressId = ParamUtil.getString((PortletRequest)actionRequest, (String)"progressId");
                    ProgressInputStream pis = new ProgressInputStream(actionRequest, getMethod.getResponseBodyAsStream(), contentLength, progressId);
                    String deployDir = PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
                    String tmpFilePath = String.valueOf(deployDir) + "/" + _DOWNLOAD_DIR + "/" + fileName;
                    File tmpFile = new File(tmpFilePath);
                    if (!tmpFile.getParentFile().exists()) {
                        tmpFile.getParentFile().mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    try {
                        pis.readAll(fos);
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Downloaded plugin from " + urlObj + " has " + pis.getTotalRead() + " bytes"));
                        }
                    }
                    finally {
                        pis.clearProgress();
                    }
                    getMethod.releaseConnection();
                    if (pis.getTotalRead() > 0L) {
                        String destination = String.valueOf(deployDir) + "/" + fileName;
                        File destinationFile = new File(destination);
                        boolean moved = FileUtil.move((File)tmpFile, (File)destinationFile);
                        if (!moved) {
                            FileUtil.copyFile((File)tmpFile, (File)destinationFile);
                            FileUtil.delete((File)tmpFile);
                        }
                        SessionMessages.add((PortletRequest)actionRequest, (String)"pluginDownloaded");
                        break block23;
                    }
                    if (failOnError) {
                        SessionErrors.add((PortletRequest)actionRequest, (String)UploadException.class.getName());
                    }
                    responseCode = 500;
                }
                catch (MalformedURLException murle) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)"invalidUrl", (Object)murle);
                }
                catch (IOException ioe) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)"errorConnectingToUrl", (Object)ioe);
                }
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                PluginPackageUtil.endPluginPackageInstallation(deploymentContext);
            }
        }
        return responseCode;
    }

    protected void remoteDeploySourceForge(String path, ActionRequest actionRequest) throws Exception {
        String[] sourceForgeMirrors = this.getSourceForgeMirrors();
        int i = 0;
        while (i < sourceForgeMirrors.length) {
            try {
                int responseCode;
                String url = String.valueOf(sourceForgeMirrors[i]) + path;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Downloading from SourceForge mirror " + url));
                }
                URL urlObj = new URL(url);
                boolean failOnError = false;
                if (i + 1 == sourceForgeMirrors.length) {
                    failOnError = true;
                }
                if ((responseCode = this.remoteDeploy(url, urlObj, actionRequest, failOnError)) == 200) {
                    return;
                }
            }
            catch (MalformedURLException murle) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"invalidUrl", (Object)murle);
            }
            ++i;
        }
    }

    protected void unignorePackages(ActionRequest actionRequest) throws Exception {
        Object[] pluginPackagesUnignored = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"pluginPackagesUnignored"), (String)"\n");
        String[] pluginPackagesIgnored = PrefsPropsUtil.getStringArray("plugin.notifications.packages.ignored", "\n", PropsValues.PLUGIN_NOTIFICATIONS_PACKAGES_IGNORED);
        StringBundler sb = new StringBundler();
        int i = 0;
        while (i < pluginPackagesIgnored.length) {
            String packageId = pluginPackagesIgnored[i];
            if (!ArrayUtil.contains((Object[])pluginPackagesUnignored, (Object)packageId)) {
                sb.append(packageId);
                sb.append("\n");
            }
            ++i;
        }
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        preferences.setValue("plugin.notifications.packages.ignored", sb.toString());
        preferences.store();
        PluginPackageUtil.refreshUpdatesAvailableCache();
    }

    protected void uninstall(ActionRequest actionRequest) throws Exception {
        String appServerType = ServerDetector.getServerId();
        String deploymentContext = ParamUtil.getString((PortletRequest)actionRequest, (String)"deploymentContext");
        if (appServerType.startsWith("jboss")) {
            deploymentContext = String.valueOf(deploymentContext) + ".war";
        }
        File deployDir = new File(String.valueOf(DeployUtil.getAutoDeployDestDir()) + "/" + deploymentContext);
        DeployUtil.undeploy(appServerType, deployDir);
    }
}

