/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.util.BBCodeTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BBCodeUtil {
    static Map<Integer, String> fontSizes = new HashMap<Integer, String>();
    static Map<String, String> listStyles = new HashMap<String, String>();
    static String[][] emoticons = new String[][]{{"angry.gif", ":angry:"}, {"bashful.gif", ":bashful:"}, {"big_grin.gif", ":grin:"}, {"blink.gif", ":blink:"}, {"blush.gif", ":*)"}, {"bored.gif", ":bored:"}, {"closed_eyes.gif", "-_-"}, {"cold.gif", ":cold:"}, {"cool.gif", "B)"}, {"darth_vader.gif", ":vader:"}, {"dry.gif", "<_<"}, {"exclamation.gif", ":what:"}, {"girl.gif", ":girl:"}, {"glare.gif", ">_>"}, {"happy.gif", ":)"}, {"huh.gif", ":huh:"}, {"in_love.gif", "<3"}, {"karate_kid.gif", ":kid:"}, {"kiss.gif", ":#"}, {"laugh.gif", ":lol:"}, {"mad.gif", ":mad:"}, {"mellow.gif", ":mellow:"}, {"ninja.gif", ":ph34r:"}, {"oh_my.gif", ":O"}, {"pac_man.gif", ":V"}, {"roll_eyes.gif", ":rolleyes:"}, {"sad.gif", ":("}, {"sleep.gif", ":sleep:"}, {"smile.gif", ":D"}, {"smug.gif", ":smug:"}, {"suspicious.gif", "8o"}, {"tongue.gif", ":P"}, {"unsure.gif", ":unsure:"}, {"wacko.gif", ":wacko:"}, {"wink.gif", ":wink:"}, {"wub.gif", ":wub:"}};
    public static final String[][] EMOTICONS;
    private static final String[] _BBCODE_TAGS;
    private static final String[] _HTML_TAGS;
    private static Log _log;

    static {
        fontSizes.put(new Integer(1), "<span style='font-size: 0.7em;'>");
        fontSizes.put(new Integer(2), "<span style='font-size: 0.8em;'>");
        fontSizes.put(new Integer(3), "<span style='font-size: 0.9em;'>");
        fontSizes.put(new Integer(4), "<span style='font-size: 1.0em;'>");
        fontSizes.put(new Integer(5), "<span style='font-size: 1.1em;'>");
        fontSizes.put(new Integer(6), "<span style='font-size: 1.3em;'>");
        fontSizes.put(new Integer(7), "<span style='font-size: 1.5em;'>");
        listStyles.put("1", "<ol style='list-style: decimal inside;'>");
        listStyles.put("i", "<ol style='list-style: lower-roman inside;'>");
        listStyles.put("I", "<ol style='list-style: upper-roman inside;'>");
        listStyles.put("a", "<ol style='list-style: lower-alpha inside;'>");
        listStyles.put("A", "<ol style='list-style: upper-alpha inside;'>");
        int i = 0;
        while (i < emoticons.length) {
            String[] emoticon = emoticons[i];
            String image = emoticon[0];
            String code = emoticon[1];
            emoticon[0] = "<img alt='emoticon' src='@theme_images_path@/emoticons/" + image + "' />";
            emoticon[1] = HtmlUtil.escape((String)code);
            ++i;
        }
        EMOTICONS = emoticons;
        _BBCODE_TAGS = new String[]{"[b]", "[/b]", "[i]", "[/i]", "[u]", "[/u]", "[s]", "[/s]", "[img]", "[/img]", "[left]", "[center]", "[right]", "[indent]", "[/left]", "[/center]", "[/right]", "[/indent]", "[tt]", "[/tt]"};
        _HTML_TAGS = new String[]{"<b>", "</b>", "<i>", "</i>", "<u>", "</u>", "<strike>", "</strike>", "<img alt='' src='", "' />", "<div style='text-align: left;'>", "<div style='text-align: center;'>", "<div style='text-align: right;'>", "<div style='margin-left: 15px;'>", "</div>", "</div>", "</div>", "</div>", "<tt>", "</tt>"};
        _log = LogFactoryUtil.getLog(BBCodeUtil.class);
    }

    public static String getHTML(MBMessage message) {
        String body = message.getBody();
        try {
            body = BBCodeUtil.getHTML(body);
        }
        catch (Exception e) {
            _log.error((Object)("Could not parse message " + message.getMessageId() + " " + e.getMessage()));
        }
        return body;
    }

    public static String getHTML(String bbcode) {
        String postTag;
        String preTag;
        String html = HtmlUtil.escape((String)bbcode);
        html = StringUtil.replace((String)html, (String[])_BBCODE_TAGS, (String[])_HTML_TAGS);
        int i = 0;
        while (i < emoticons.length) {
            String[] emoticon = emoticons[i];
            html = StringUtil.replace((String)html, (String)emoticon[1], (String)emoticon[0]);
            ++i;
        }
        BBCodeTag tag = null;
        StringBundler sb = null;
        while ((tag = BBCodeUtil.getFirstTag(html, "code")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            String code = tag.getElement().replaceAll("\t", "    ");
            String[] lines = code.split("\\n");
            int digits = String.valueOf(lines.length + 1).length();
            sb = new StringBundler(preTag);
            sb.append("<div class='code'>");
            int i2 = 0;
            while (i2 < lines.length) {
                String index = String.valueOf(i2 + 1);
                int ld = index.length();
                sb.append("<span class='code-lines'>");
                int j = 0;
                while (j < digits - ld) {
                    sb.append("&nbsp;");
                    ++j;
                }
                lines[i2] = StringUtil.replace((String)lines[i2], (String)"   ", (String)"&nbsp; &nbsp;");
                lines[i2] = StringUtil.replace((String)lines[i2], (String)"  ", (String)"&nbsp; ");
                sb.append(String.valueOf(index) + "</span>");
                sb.append(lines[i2]);
                if (index.length() < lines.length) {
                    sb.append("<br />");
                }
                ++i2;
            }
            sb.append("</div>");
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "color")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            if (tag.hasParameter()) {
                sb.append("<span style='color: ");
                sb.append(String.valueOf(tag.getParameter()) + ";'>");
                sb.append(String.valueOf(tag.getElement()) + "</span>");
            } else {
                sb.append(tag.getElement());
            }
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "email")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            String mailto = GetterUtil.getString((String)tag.getParameter(), (String)tag.getElement().trim());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            sb.append(preTag);
            sb.append("<a href='mailto: ");
            sb.append(mailto);
            sb.append("'>");
            sb.append(String.valueOf(tag.getElement()) + "</a>");
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "font")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            if (tag.hasParameter()) {
                sb.append("<span style='font-family: ");
                sb.append(String.valueOf(tag.getParameter()) + ";'>");
                sb.append(String.valueOf(tag.getElement()) + "</span>");
            } else {
                sb.append(tag.getElement());
            }
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "img")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            sb.append("<img alt='' src='");
            sb.append(tag.getElement().trim());
            sb.append("' />");
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "list")) != null) {
            int i3;
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            String[] items = BBCodeUtil._getListItems(tag.getElement());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            if (tag.hasParameter() && listStyles.containsKey(tag.getParameter())) {
                sb.append(listStyles.get(tag.getParameter()));
                i3 = 0;
                while (i3 < items.length) {
                    if (items[i3].trim().length() > 0) {
                        sb.append("<li>" + items[i3].trim() + "</li>");
                    }
                    ++i3;
                }
                sb.append("</ol>");
            } else {
                sb.append("<ul style='list-style: disc inside;'>");
                i3 = 0;
                while (i3 < items.length) {
                    if (items[i3].trim().length() > 0) {
                        sb.append("<li>" + items[i3].trim() + "</li>");
                    }
                    ++i3;
                }
                sb.append("</ul>");
            }
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "quote")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            if (tag.hasParameter()) {
                sb.append("<div class='quote-title'>");
                sb.append(String.valueOf(tag.getParameter()) + ":</div>");
            }
            sb.append("<div class='quote'>");
            sb.append("<div class='quote-content'>");
            sb.append(tag.getElement());
            sb.append("</div></div>");
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "size")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            if (tag.hasParameter()) {
                Integer size = new Integer(GetterUtil.getInteger((String)tag.getParameter()));
                if (size > 7) {
                    size = new Integer(7);
                }
                if (fontSizes.containsKey(size)) {
                    sb.append(fontSizes.get(size));
                    sb.append(String.valueOf(tag.getElement()) + "</span>");
                } else {
                    sb.append(tag.getElement());
                }
            } else {
                sb.append(tag.getElement());
            }
            sb.append(postTag);
            html = sb.toString();
        }
        while ((tag = BBCodeUtil.getFirstTag(html, "url")) != null) {
            preTag = html.substring(0, tag.getStartPos());
            postTag = html.substring(tag.getEndPos());
            String url = GetterUtil.getString((String)tag.getParameter(), (String)tag.getElement().trim());
            if (sb == null) {
                sb = new StringBundler(preTag);
            } else {
                sb.setIndex(0);
                sb.append(preTag);
            }
            sb.append("<a href='");
            sb.append(HtmlUtil.escapeHREF((String)url));
            sb.append("'>");
            sb.append(tag.getElement());
            sb.append("</a>");
            sb.append(postTag);
            html = sb.toString();
        }
        html = StringUtil.replace((String)html, (String)"\n", (String)"<br />");
        return html;
    }

    public static BBCodeTag getFirstTag(String bbcode, String name) {
        BBCodeTag tag = new BBCodeTag();
        String begTag = "[" + name;
        String endTag = "[/" + name + "]";
        String preTag = StringUtil.extractFirst((String)bbcode, (String)begTag);
        if (preTag == null) {
            return null;
        }
        if (preTag.length() != bbcode.length()) {
            tag.setStartPos(preTag.length());
            String remainder = bbcode.substring(preTag.length() + begTag.length());
            int cb = remainder.indexOf("]");
            int end = BBCodeUtil._getEndTagPos(remainder, begTag, endTag);
            if (end > 0) {
                if (cb > 0 && remainder.startsWith("=")) {
                    tag.setParameter(remainder.substring(1, cb));
                    tag.setElement(remainder.substring(cb + 1, end));
                } else if (cb == 0) {
                    try {
                        tag.setElement(remainder.substring(1, end));
                    }
                    catch (StringIndexOutOfBoundsException sioobe) {
                        _log.error((Object)bbcode);
                        throw sioobe;
                    }
                }
            }
        }
        if (tag.hasElement()) {
            int length = begTag.length() + 1 + tag.getElement().length() + endTag.length();
            if (tag.hasParameter()) {
                length += 1 + tag.getParameter().length();
            }
            tag.setEndPos(tag.getStartPos() + length);
            return tag;
        }
        return null;
    }

    private static int _getEndTagPos(String remainder, String begTag, String endTag) {
        int nextBegTagPos = remainder.indexOf(begTag);
        int nextEndTagPos = remainder.indexOf(endTag);
        while (nextBegTagPos < nextEndTagPos && nextBegTagPos >= 0) {
            nextBegTagPos = remainder.indexOf(begTag, nextBegTagPos + begTag.length());
            nextEndTagPos = remainder.indexOf(endTag, nextEndTagPos + endTag.length());
        }
        return nextEndTagPos;
    }

    private static String[] _getListItems(String tagElement) {
        ArrayList<String> items = new ArrayList<String>();
        StringBundler sb = new StringBundler();
        int nestLevel = 0;
        String[] stringArray = StringUtil.split((String)tagElement, (String)"[*]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if ((item = item.trim()).length() != 0) {
                int endTagCount;
                int begTagCount = StringUtil.count((String)item, (String)"[list");
                if (begTagCount > 0) {
                    nestLevel += begTagCount;
                }
                if ((endTagCount = StringUtil.count((String)item, (String)"[/list]")) > 0) {
                    nestLevel -= endTagCount;
                }
                if (nestLevel == 0) {
                    if (begTagCount == 0 && endTagCount == 0) {
                        items.add(item);
                    } else if (endTagCount > 0) {
                        if (sb.length() > 0) {
                            sb.append("[*]");
                        }
                        sb.append(item);
                        items.add(sb.toString());
                        sb.setIndex(0);
                    }
                } else {
                    if (sb.length() > 0) {
                        sb.append("[*]");
                    }
                    sb.append(item);
                }
            }
            ++n2;
        }
        return items.toArray(new String[items.size()]);
    }
}

