/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBTreeWalker;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBTreeWalkerImpl
implements MBTreeWalker {
    private static Log _log = LogFactoryUtil.getLog(MBTreeWalkerImpl.class);
    private Map<Long, Integer> _messageIdsMap = new HashMap<Long, Integer>();
    private List<MBMessage> _messages;
    private boolean _odd;

    public MBTreeWalkerImpl(MBMessage message, int status) {
        try {
            this._messages = MBMessageLocalServiceUtil.getThreadMessages((long)message.getThreadId(), (int)status);
            int i = 0;
            while (i < this._messages.size()) {
                MBMessage curMessage = this._messages.get(i);
                long parentMessageId = curMessage.getParentMessageId();
                if (!curMessage.isRoot() && !this._messageIdsMap.containsKey(parentMessageId)) {
                    this._messageIdsMap.put(parentMessageId, i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    public List<MBMessage> getChildren(MBMessage message) {
        ArrayList<MBMessage> children = new ArrayList<MBMessage>();
        int[] range = this.getChildrenRange(message);
        int i = range[0];
        while (i < range[1]) {
            children.add(this._messages.get(i));
            ++i;
        }
        return children;
    }

    public int[] getChildrenRange(MBMessage message) {
        long messageId = message.getMessageId();
        Integer pos = this._messageIdsMap.get(messageId);
        if (pos == null) {
            return new int[2];
        }
        int[] range = new int[2];
        range[0] = pos;
        int i = range[0];
        while (i < this._messages.size()) {
            MBMessage curMessage = this._messages.get(i);
            if (curMessage.getParentMessageId() != messageId) break;
            range[1] = i + 1;
            ++i;
        }
        return range;
    }

    public List<MBMessage> getMessages() {
        return this._messages;
    }

    public MBMessage getRoot() {
        return this._messages.get(0);
    }

    public boolean isLeaf(MBMessage message) {
        Long messageIdObj = new Long(message.getMessageId());
        return !this._messageIdsMap.containsKey(messageIdObj);
    }

    public boolean isOdd() {
        this._odd = !this._odd;
        return this._odd;
    }
}

