/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.TransformException;
import com.liferay.portlet.journal.util.BaseTemplateParser;
import com.liferay.portlet.journal.util.TemplateNode;
import com.liferay.util.PwdGenerator;
import com.liferay.util.xml.CDATAUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.VelocityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTemplateParser
extends BaseTemplateParser {
    @Override
    protected String doTransform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, String xml, String script) throws Exception {
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        boolean load = false;
        try {
            VelocityContext velocityContext = VelocityEngineUtil.getWrappedRestrictedToolsContext();
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            List<TemplateNode> nodes = this.extractDynamicContents(themeDisplay, root);
            for (TemplateNode node : nodes) {
                velocityContext.put(node.getName(), (Object)node);
            }
            velocityContext.put("xmlRequest", (Object)root.element("request").asXML());
            velocityContext.put("request", this.insertRequestVariables(root.element("request")));
            long companyId = GetterUtil.getLong((String)tokens.get("company_id"));
            Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            long groupId = GetterUtil.getLong((String)tokens.get("group_id"));
            String templateId = tokens.get("template_id");
            String journalTemplatesPath = "_JOURNAL_CONTEXT_/" + companyId + "/" + groupId;
            String randomNamespace = String.valueOf(PwdGenerator.getPassword((String)PwdGenerator.KEY3, (int)4)) + "_";
            velocityContext.put("company", (Object)company);
            velocityContext.put("companyId", (Object)String.valueOf(companyId));
            velocityContext.put("groupId", (Object)String.valueOf(groupId));
            velocityContext.put("journalTemplatesPath", (Object)journalTemplatesPath);
            velocityContext.put("viewMode", (Object)viewMode);
            velocityContext.put("locale", (Object)LocaleUtil.fromLanguageId((String)languageId));
            velocityContext.put("permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
            velocityContext.put("randomNamespace", (Object)randomNamespace);
            script = this.injectEditInPlace(xml, script);
            try {
                String velocityTemplateId = String.valueOf(companyId + groupId) + templateId;
                load = VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)script, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
            }
            catch (VelocityException ve) {
                velocityContext.put("exception", (Object)ve.getMessage());
                velocityContext.put("script", (Object)script);
                if (ve instanceof ParseErrorException) {
                    ParseErrorException pe = (ParseErrorException)ve;
                    velocityContext.put("column", (Object)new Integer(pe.getColumnNumber()));
                    velocityContext.put("line", (Object)new Integer(pe.getLineNumber()));
                }
                String velocityTemplateId = PropsValues.JOURNAL_ERROR_TEMPLATE_VELOCITY;
                String velocityTemplateContent = ContentUtil.get(PropsValues.JOURNAL_ERROR_TEMPLATE_VELOCITY);
                load = VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
            }
        }
        catch (Exception e) {
            if (e instanceof DocumentException) {
                throw new TransformException("Unable to read XML document", e);
            }
            if (e instanceof VelocityException) {
                VelocityException pex = (VelocityException)((Object)e);
                throw new TransformException("Unable to parse velocity template: " + HtmlUtil.escape((String)pex.getMessage()), e);
            }
            if (e instanceof IOException) {
                throw new TransformException("Error reading velocity template", e);
            }
            if (e instanceof TransformException) {
                throw (TransformException)((Object)e);
            }
            throw new TransformException("Unhandled exception", e);
        }
        if (!load) {
            throw new TransformException("Unable to dynamically load velocity transform script");
        }
        return unsyncStringWriter.toString();
    }

    protected List<TemplateNode> extractDynamicContents(ThemeDisplay themeDisplay, Element parent) throws TransformException {
        ArrayList<TemplateNode> nodes = new ArrayList<TemplateNode>();
        HashMap<String, TemplateNode> prototypeNodes = new HashMap<String, TemplateNode>();
        for (Element el : parent.elements("dynamic-element")) {
            Element content = el.element("dynamic-content");
            if (content == null) {
                throw new TransformException("Element missing \"dynamic-content\"");
            }
            String name = el.attributeValue("name", "");
            if (name.length() == 0) {
                throw new TransformException("Element missing \"name\" attribute");
            }
            String type = el.attributeValue("type", "");
            TemplateNode node = new TemplateNode(themeDisplay, name, CDATAUtil.strip((String)content.getText()), type);
            if (el.element("dynamic-element") != null) {
                node.appendChildren(this.extractDynamicContents(themeDisplay, el));
            } else if (content.element("option") != null) {
                for (Element option : content.elements("option")) {
                    node.appendOption(CDATAUtil.strip((String)option.getText()));
                }
            }
            TemplateNode prototypeNode = (TemplateNode)prototypeNodes.get(name);
            if (prototypeNode == null) {
                prototypeNode = node;
                prototypeNodes.put(name, prototypeNode);
                nodes.add(node);
            }
            prototypeNode.appendSibling(node);
        }
        return nodes;
    }

    protected String injectEditInPlace(String xml, String script) throws DocumentException {
        Document doc = SAXReaderUtil.read((String)xml);
        List nodes = doc.selectNodes("//dynamic-element");
        for (Node node : nodes) {
            Element el = (Element)node;
            String name = GetterUtil.getString((String)el.attributeValue("name"));
            String type = GetterUtil.getString((String)el.attributeValue("type"));
            if (name.startsWith("reserved-") || !type.equals("text") && !type.equals("text_box") && !type.equals("text_area")) continue;
            script = this.wrapField(script, name, type, "data");
            script = this.wrapField(script, name, type, "getData()");
        }
        return script;
    }

    protected Map<String, Object> insertRequestVariables(Element parent) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (parent == null) {
            return map;
        }
        for (Element el : parent.elements()) {
            String name = el.getName();
            if (name.equals("attribute")) {
                map.put(el.elementText("name"), el.elementText("value"));
                continue;
            }
            if (name.equals("parameter")) {
                name = el.element("name").getText();
                List valueEls = el.elements("value");
                if (valueEls.size() == 1) {
                    map.put(name, ((Element)valueEls.get(0)).getText());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Element valueEl : valueEls) {
                    values.add(valueEl.getText());
                }
                map.put(name, values);
                continue;
            }
            if (el.elements().size() > 0) {
                map.put(name, this.insertRequestVariables(el));
                continue;
            }
            map.put(name, el.getText());
        }
        return map;
    }

    protected String wrapField(String script, String name, String type, String call) {
        String field = "$" + name + "." + call;
        String wrappedField = "<span class=\"journal-content-eip-" + type + "\" " + "id=\"journal-content-field-name-" + name + "\">" + field + "</span>";
        return StringUtil.replace((String)script, (String)("$editInPlace(" + field + ")"), (String)wrappedField);
    }
}

