/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class JournalArticleAssetRenderer
extends BaseAssetRenderer {
    private JournalArticle _article;

    public JournalArticleAssetRenderer(JournalArticle article) {
        this._article = article;
    }

    public String[] getAvailableLocales() {
        return this._article.getAvailableLocales();
    }

    public long getClassPK() {
        if ((this._article.isDraft() || this._article.isPending()) && this._article.getVersion() != 1.0) {
            return this._article.getPrimaryKey();
        }
        return this._article.getResourcePrimKey();
    }

    public String getDiscussionPath() {
        if (PropsValues.JOURNAL_ARTICLE_COMMENTS_ENABLED) {
            return "edit_article_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._article.getGroupId();
    }

    public String getSummary() {
        return HtmlUtil.stripHtml((String)this._article.getContent());
    }

    public String getTitle() {
        return this._article.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL editPortletURL = liferayPortletResponse.createRenderURL("15");
        editPortletURL.setParameter("struts_action", "/journal/edit_article");
        editPortletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        editPortletURL.setParameter("articleId", this._article.getArticleId());
        editPortletURL.setParameter("version", String.valueOf(this._article.getVersion()));
        return editPortletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL exportPortletURL = liferayPortletResponse.createActionURL();
        exportPortletURL.setParameter("struts_action", "/asset_publisher/export_journal_article");
        exportPortletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        exportPortletURL.setParameter("articleId", this._article.getArticleId());
        return exportPortletURL;
    }

    public String getUrlTitle() {
        return this._article.getUrlTitle();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        String languageId = LanguageUtil.getLanguageId((PortletRequest)liferayPortletRequest);
        JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay((long)this._article.getGroupId(), (String)this._article.getArticleId(), null, null, (String)languageId, (ThemeDisplay)themeDisplay);
        String viewURL = "";
        if (articleDisplay != null) {
            PortletURL viewPortletURL = liferayPortletResponse.createRenderURL();
            viewPortletURL.setParameter("struts_action", "/asset_publisher/view_content");
            viewPortletURL.setParameter("urlTitle", this._article.getUrlTitle());
            viewPortletURL.setParameter("type", "content");
            viewURL = viewPortletURL.toString();
        }
        return viewURL;
    }

    public long getUserId() {
        return this._article.getUserId();
    }

    public String getUuid() {
        return this._article.getUuid();
    }

    public String getViewInContextMessage() {
        return "view";
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return JournalArticlePermission.contains(permissionChecker, this._article, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return JournalArticlePermission.contains(permissionChecker, this._article, "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isLocalizable() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("JOURNAL_ARTICLE", (Object)this._article);
            return "/html/portlet/journal/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

