/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.GroupNameException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.RequiredGroupException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.service.MembershipRequestServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.communities.action.ActionUtil;
import com.liferay.portlet.communities.util.CommunitiesUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditGroupAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateGroup(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteGroup(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.communities.error");
            }
            if (e instanceof DuplicateGroupException || e instanceof GroupFriendlyURLException || e instanceof GroupNameException || e instanceof RequiredGroupException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                if (cmd.equals("delete")) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.communities.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.communities.edit_community"));
    }

    protected void deleteGroup(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (groupId == themeDisplay.getDoAsGroupId() || groupId == themeDisplay.getScopeGroupId()) {
            throw new RequiredGroupException(String.valueOf(groupId));
        }
        GroupServiceUtil.deleteGroup((long)groupId);
        LiveUsers.deleteGroup(themeDisplay.getCompanyId(), groupId);
    }

    protected void updateGroup(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long userId = PortalUtil.getUserId((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
        String friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        Group group = null;
        if (groupId <= 0L) {
            group = GroupServiceUtil.addGroup((String)name, (String)description, (int)type, (String)friendlyURL, (boolean)active, (ServiceContext)serviceContext);
            LiveUsers.joinGroup(themeDisplay.getCompanyId(), group.getGroupId(), userId);
        } else {
            group = GroupServiceUtil.updateGroup((long)groupId, (String)name, (String)description, (int)type, (String)friendlyURL, (boolean)active, (ServiceContext)serviceContext);
            if (type == 1) {
                List membershipRequests = MembershipRequestLocalServiceUtil.search((long)groupId, (int)0, (int)-1, (int)-1);
                for (MembershipRequest membershipRequest : membershipRequests) {
                    MembershipRequestServiceUtil.updateStatus((long)membershipRequest.getMembershipRequestId(), (String)themeDisplay.translate("your-membership-has-been-approved"), (int)1);
                    LiveUsers.joinGroup(themeDisplay.getCompanyId(), membershipRequest.getGroupId(), new long[]{membershipRequest.getUserId()});
                }
            }
        }
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        CommunitiesUtil.applyLayoutSetPrototypes(group, publicLayoutSetPrototypeId, privateLayoutSetPrototypeId);
    }
}

